/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opendap.dap.BaseType;
import opendap.dap.DAPNode;
import opendap.servers.SDArray;
import opendap.servers.ServerDDS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcSDArray;
import thredds.server.opendap.NcSDByte;
import thredds.server.opendap.NcSDCharArray;
import thredds.server.opendap.NcSDFloat32;
import thredds.server.opendap.NcSDFloat64;
import thredds.server.opendap.NcSDGrid;
import thredds.server.opendap.NcSDInt16;
import thredds.server.opendap.NcSDInt32;
import thredds.server.opendap.NcSDString;
import thredds.server.opendap.NcSDStructure;
import thredds.server.opendap.NcSDUInt16;
import thredds.server.opendap.NcSDUInt32;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;

public class NcDDS
extends ServerDDS {
    protected static final boolean HANDLE_DUP_DIM_GRIDS = true;
    private static Logger log = LoggerFactory.getLogger(NcDDS.class);
    private Map<String, Variable> coordvars = new HashMap<String, Variable>(50);
    private List<Variable> ddsvars = new ArrayList<Variable>(50);
    private Map<String, Variable> gridarrays = new HashMap<String, Variable>(50);
    private Map<String, Variable> used = new HashMap<String, Variable>(50);

    private Variable findVariable(String name) {
        for (Variable v : this.ddsvars) {
            if (!v.getFullName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public NcDDS(String name, NetcdfFile ncfile) {
        super(name);
        NetcdfDataset ncd;
        if (ncfile instanceof NetcdfDataset && (ncd = (NetcdfDataset)ncfile).getEnhanceMode().contains(NetcdfDataset.Enhance.CoordSystems)) {
            this.createFromDataset((NetcdfDataset)ncfile);
            return;
        }
        this.createFromFile(ncfile);
    }

    private void createFromFile(NetcdfFile ncfile) {
        this.ddsvars = new ArrayList<Variable>(ncfile.getVariables());
        for (Object e : ncfile.getDimensions()) {
            Dimension dim = (Dimension)e;
            Variable cv = this.findVariable(dim.getShortName());
            if (cv == null || !cv.isCoordinateVariable()) continue;
            this.coordvars.put(dim.getShortName(), cv);
            if (!log.isDebugEnabled()) continue;
            log.debug(" NcDDS adding coordinate variable " + cv.getFullName() + " for dimension " + dim.getShortName());
        }
        for (Variable variable : this.ddsvars) {
            boolean isgridarray;
            boolean bl = isgridarray = variable.getRank() > 1 && variable.getDataType() != DataType.STRUCTURE && variable.getParentStructure() == null;
            if (!isgridarray) continue;
            List dimset = variable.getDimensions();
            int rank = dimset.size();
            for (int i = 0; isgridarray && i < rank; ++i) {
                Dimension dim = (Dimension)dimset.get(i);
                if (dim.getShortName() == null) {
                    isgridarray = false;
                } else {
                    Variable gv = this.coordvars.get(dim.getShortName());
                    if (gv == null) {
                        isgridarray = false;
                    }
                }
                for (int j = i + 1; isgridarray && j < rank; ++j) {
                    if (dimset.get(j) != dim) continue;
                    isgridarray = false;
                }
            }
            if (!isgridarray) continue;
            this.gridarrays.put(variable.getFullName(), variable);
            for (Dimension dim : dimset) {
                Variable gv = this.coordvars.get(dim.getShortName());
                if (gv == null) continue;
                this.used.put(gv.getFullName(), gv);
            }
        }
        for (Object object : this.ddsvars) {
            Variable cv = (Variable)object;
            BaseType bt = this.createVariable(ncfile, cv);
            this.addVariable(bt);
        }
    }

    private void createFromDataset(NetcdfDataset ncd) {
        for (CoordinateAxis axis : ncd.getCoordinateAxes()) {
            this.coordvars.put(axis.getShortName(), (Variable)axis);
        }
        this.ddsvars = new ArrayList<Variable>(50);
        for (Variable v : ncd.getVariables()) {
            Variable gv;
            boolean isgridarray;
            if (this.coordvars.containsKey(v.getShortName())) continue;
            this.ddsvars.add(v);
            boolean bl = isgridarray = v.getRank() > 1 && v.getDataType() != DataType.STRUCTURE && v.getParentStructure() == null;
            if (!isgridarray) continue;
            List dimset = v.getDimensions();
            int rank = dimset.size();
            for (int i = 0; isgridarray && i < rank; ++i) {
                Dimension dim = (Dimension)dimset.get(i);
                if (dim.getShortName() == null) {
                    isgridarray = false;
                    continue;
                }
                gv = this.coordvars.get(dim.getShortName());
                if (gv != null) continue;
                isgridarray = false;
            }
            if (!isgridarray) continue;
            this.gridarrays.put(v.getFullName(), v);
            for (Dimension dim : dimset) {
                gv = this.coordvars.get(dim.getShortName());
                if (gv == null) continue;
                this.used.put(gv.getFullName(), gv);
            }
        }
        for (Variable cv : ncd.getCoordinateAxes()) {
            BaseType bt = this.createVariable((NetcdfFile)ncd, cv);
            this.addVariable(bt);
        }
        for (Variable cv : this.ddsvars) {
            BaseType bt = this.createVariable((NetcdfFile)ncd, cv);
            this.addVariable(bt);
        }
    }

    private BaseType createVariable(NetcdfFile ncfile, Variable v) {
        Object bt = v.getRank() == 0 ? this.createScalarVariable(ncfile, v) : (v.getDataType() == DataType.CHAR ? (v.getRank() > 1 ? new NcSDCharArray(v) : new NcSDString(v)) : (v.getDataType() == DataType.STRING ? (v.getRank() == 0 ? new NcSDString(v) : new NcSDArray(v, (BaseType)new NcSDString(v))) : this.createArray(ncfile, v)));
        return bt;
    }

    private BaseType createScalarVariable(NetcdfFile ncfile, Variable v) {
        DataType dt = v.getDataType();
        if (dt == DataType.DOUBLE) {
            return new NcSDFloat64(v);
        }
        if (dt == DataType.FLOAT) {
            return new NcSDFloat32(v);
        }
        if (dt == DataType.INT) {
            return new NcSDInt32(v);
        }
        if (dt == DataType.UINT) {
            return new NcSDUInt32(v);
        }
        if (dt == DataType.SHORT) {
            return new NcSDInt16(v);
        }
        if (dt == DataType.USHORT) {
            return new NcSDUInt16(v);
        }
        if (dt == DataType.BYTE || dt == DataType.UBYTE) {
            return new NcSDByte(v);
        }
        if (dt == DataType.CHAR) {
            return new NcSDString(v);
        }
        if (dt == DataType.STRING) {
            return new NcSDString(v);
        }
        if (dt == DataType.STRUCTURE) {
            return this.createStructure(ncfile, (Structure)v);
        }
        throw new UnsupportedOperationException("NcDDS Variable data type = " + dt);
    }

    private BaseType createArray(NetcdfFile ncfile, Variable v) {
        boolean isGrid = this.gridarrays.get(v.getFullName()) != null;
        NcSDArray arr = new NcSDArray(v, this.createScalarVariable(ncfile, v));
        if (isGrid) {
            ArrayList<SDArray> list = new ArrayList<SDArray>();
            list.add(arr);
            List dimset = v.getDimensions();
            for (Dimension dim : dimset) {
                Variable v1 = this.used.get(dim.getShortName());
                assert (v1 != null);
                HasNetcdfVariable bt = v1.getDataType() == DataType.CHAR ? (v1.getRank() > 1 ? new NcSDCharArray(v1) : new NcSDString(v1)) : new NcSDArray(v1, this.createScalarVariable(ncfile, v1));
                list.add((SDArray)bt);
            }
            return new NcSDGrid(v.getShortName(), list);
        }
        return arr;
    }

    private BaseType createStructure(NetcdfFile ncfile, Structure s) {
        ArrayList<BaseType> list = new ArrayList<BaseType>();
        for (Object o : s.getVariables()) {
            Variable nested = (Variable)o;
            list.add(this.createVariable(ncfile, nested));
        }
        return new NcSDStructure(s, list);
    }

    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        NcDDS d = (NcDDS)super.cloneDAG(map);
        d.coordvars = this.coordvars;
        return d;
    }
}

