/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.reify;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.core.TdsRequestedDataset;
import thredds.server.reify.DownloadParameters;
import thredds.server.reify.LoadCommon;
import ucar.httpservices.HTTPUtil;
import ucar.nc2.FileWriter2;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.NCheader;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.CancelTaskImpl;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingDefault;
import ucar.unidata.io.RandomAccessFile;

@Controller
@RequestMapping(value={"/download", "/restrictedAccess/download"})
public class DownloadController
extends LoadCommon {
    protected static final boolean DEBUG = true;
    protected static final String DEFAULTREQUESTNAME = "download";
    protected static final String DEFAULTDOWNLOADDIR = "download";
    protected static final String FILESERVERSERVLET = "/fileServer/";
    protected Nc4Chunking.Strategy strategy = Nc4Chunking.Strategy.standard;
    protected Nc4Chunking chunking = new Nc4ChunkingDefault();
    protected DownloadParameters params = null;
    protected String downloadform = null;

    public void doonce(HttpServletRequest req) throws LoadCommon.SendError {
        if (this.once) {
            return;
        }
        super.initOnce(req);
        if (this.downloaddir == null) {
            throw new LoadCommon.SendError(412, "Download disabled");
        }
        this.downloaddirname = new File(this.downloaddir).getName();
        File downform = null;
        downform = this.tdsContext.getDownloadForm();
        if (downform == null) {
            File root = this.tdsContext.getServletRootDirectory();
            downform = new File(root, "WEB-INF/download.html");
        }
        try {
            this.downloadform = DownloadController.loadForm(downform);
        }
        catch (IOException ioe) {
            throw new LoadCommon.SendError(412, ioe);
        }
    }

    public void setup(HttpServletRequest req, HttpServletResponse resp) throws LoadCommon.SendError {
        this.req = req;
        this.res = resp;
        if (!this.once) {
            this.doonce(req);
        }
        try {
            this.params = new DownloadParameters(req);
        }
        catch (IOException ioe) {
            throw new LoadCommon.SendError(400, ioe);
        }
    }

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            this.setup(req, res);
            String sresult = null;
            switch (this.params.command) {
                case DOWNLOAD: {
                    try {
                        String fulltargetpath = this.download();
                        if (this.params.fromform) {
                            this.sendForm("Download succeeded: result file: " + fulltargetpath);
                            break;
                        }
                        HashMap<String, String> result = new HashMap<String, String>();
                        result.put("download", fulltargetpath);
                        sresult = DownloadController.mapToString(result, true, "download");
                        this.sendOK(sresult);
                        break;
                    }
                    catch (LoadCommon.SendError se) {
                        if (this.params.fromform) {
                            this.sendForm("Download failed: " + se.getMessage());
                            break;
                        }
                        throw se;
                    }
                }
                case INQUIRE: {
                    sresult = this.inquire();
                    this.sendOK(sresult);
                    break;
                }
                case NONE: {
                    this.sendForm("No files downloaded");
                }
            }
        }
        catch (LoadCommon.SendError se) {
            this.sendError(se);
        }
        catch (Exception e) {
            String msg = DownloadController.getStackTrace(e);
            this.sendError(500, msg, e);
        }
    }

    protected String download() {
        String truepath;
        URL url;
        String target = this.params.target;
        if (target == null) {
            throw new LoadCommon.SendError(400, "No target specified");
        }
        if (target.indexOf("..") >= 0) {
            throw new LoadCommon.SendError(400, "Target parameter contains '..': " + target);
        }
        File ftarget = new File(target);
        if (ftarget.isAbsolute()) {
            throw new LoadCommon.SendError(400, "Target parameter must be a relative path: " + target);
        }
        if (this.downloaddir == null) {
            throw new LoadCommon.SendError(400, "No download directory specified for relative target: " + target);
        }
        StringBuilder b = new StringBuilder();
        b.append(this.downloaddir);
        b.append('/');
        b.append(target);
        ftarget = new File(b.toString());
        String fulltarget = HTTPUtil.canonicalpath((String)ftarget.getAbsolutePath());
        File parent = ftarget.getParentFile();
        if (!parent.exists() && !ftarget.getParentFile().mkdirs()) {
            throw new LoadCommon.SendError(403, "Target file parent directory cannot be created: " + fulltarget);
        }
        if (!this.params.overwrite && ftarget.exists()) {
            throw new LoadCommon.SendError(403, "Target file exists and overwrite is not set");
        }
        if (this.params.overwrite && ftarget.exists() && !ftarget.delete()) {
            throw new LoadCommon.SendError(403, "Target file exists and cannot be deleted");
        }
        String surl = this.params.url;
        try {
            url = new URL(surl);
        }
        catch (MalformedURLException mue) {
            throw new LoadCommon.SendError(400, "Malformed URL: " + surl);
        }
        String path = url.getPath();
        if (path.toLowerCase().indexOf(this.requestname) >= 0) {
            throw new LoadCommon.SendError(403, String.format("URL is recursive on /%s: %s", this.requestname, path));
        }
        if (!path.startsWith("/" + this.threddsname)) {
            throw new LoadCommon.SendError(403, String.format("URL does not reference %s: %s", this.threddsname, path));
        }
        b.setLength(0);
        b.append(url.getProtocol());
        b.append("://");
        b.append(this.server);
        b.append(path);
        String trueurl = b.toString();
        boolean directcopy = false;
        if (path.indexOf(FILESERVERSERVLET) >= 0 && (directcopy = this.canCopy(truepath = this.directAccess(path, this.req, this.res), this.params.format))) {
            try {
                Path src = new File(truepath).toPath();
                Path dst = new File(fulltarget).toPath();
                Files.deleteIfExists(dst);
                Files.copy(src, dst, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new LoadCommon.SendError(403, truepath);
            }
        }
        if (!directcopy) {
            NetcdfFile ncfile = null;
            try {
                CancelTaskImpl cancel = new CancelTaskImpl();
                ncfile = NetcdfDataset.openFile((String)trueurl, (CancelTask)cancel);
                switch (this.params.format) {
                    case NETCDF3: {
                        this.makeNetcdf3(ncfile, fulltarget);
                        break;
                    }
                    case NETCDF4: {
                        this.makeNetcdf4(ncfile, fulltarget);
                        break;
                    }
                    default: {
                        throw new LoadCommon.SendError(501, String.format("%s: return format %s not implemented", path, this.params.format.getName()));
                    }
                }
            }
            catch (IOException ioe) {
                throw new LoadCommon.SendError(400, ioe);
            }
        }
        return fulltarget;
    }

    protected void makeNetcdf4(NetcdfFile ncfile, String target) throws IOException {
        CancelTaskImpl cancel = new CancelTaskImpl();
        FileWriter2 writer = new FileWriter2(ncfile, target, NetcdfFileWriter.Version.netcdf4, this.chunking);
        writer.getNetcdfFileWriter().setLargeFile(true);
        NetcdfFile ncfileOut = writer.write((CancelTask)cancel);
        if (ncfileOut != null) {
            ncfileOut.close();
        }
        cancel.setDone(true);
    }

    protected void makeNetcdf3(NetcdfFile ncfile, String target) throws IOException {
        CancelTaskImpl cancel = new CancelTaskImpl();
        FileWriter2 writer = new FileWriter2(ncfile, target, NetcdfFileWriter.Version.netcdf3, this.chunking);
        writer.getNetcdfFileWriter().setLargeFile(true);
        NetcdfFile ncfileOut = writer.write((CancelTask)cancel);
        if (ncfileOut != null) {
            ncfileOut.close();
        }
        cancel.setDone(true);
    }

    protected static String escapeString(String s) {
        StringBuilder buf = new StringBuilder();
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block8;
                }
                case '\n': {
                    buf.append('\n');
                    continue block8;
                }
                case '\r': {
                    buf.append('\r');
                    continue block8;
                }
                case '\t': {
                    buf.append('\r');
                    continue block8;
                }
                case '\f': {
                    buf.append('\f');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        buf.append(String.format("\\x%02x", c & 0xFF));
                        continue block8;
                    }
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected String directAccess(String relpath, HttpServletRequest req, HttpServletResponse res) {
        int index = relpath.indexOf(FILESERVERSERVLET);
        assert (index >= 0);
        relpath = relpath.substring(index + FILESERVERSERVLET.length(), relpath.length());
        String realpath = TdsRequestedDataset.getLocationFromRequestPath(relpath = HTTPUtil.abspath((String)HTTPUtil.canonicalpath((String)relpath)));
        File f = new File(realpath);
        if (!f.exists() || !f.canRead()) {
            throw new LoadCommon.SendError(404, "Not found: " + realpath);
        }
        if (!TdsRequestedDataset.resourceControlOk(req, res, realpath)) {
            throw new LoadCommon.SendError(403, "Permissions failure: " + realpath);
        }
        return realpath;
    }

    protected boolean canCopy(String truepath, LoadCommon.FileFormat targetformat) {
        try {
            RandomAccessFile raf = new RandomAccessFile(truepath, "r");
            int format = NCheader.checkFileType((RandomAccessFile)raf);
            switch (format) {
                case 1: 
                case 2: {
                    return targetformat == LoadCommon.FileFormat.NETCDF3;
                }
                case 3: 
                case 5: 
                case 28677: {
                    return targetformat == LoadCommon.FileFormat.NETCDF4;
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    @Override
    protected String buildForm(String msg) {
        StringBuilder svc = new StringBuilder();
        svc.append(this.server);
        svc.append("/");
        svc.append(this.threddsname);
        String form = String.format(this.downloadform, svc.toString(), msg);
        return form;
    }
}

