/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.restrict;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import thredds.servlet.restrict.Authorizer;
import thredds.servlet.restrict.RoleSource;

public class TomcatAuthorizer
implements Authorizer {
    private static Logger log = LoggerFactory.getLogger(TomcatAuthorizer.class);
    @Autowired
    private TdsContext tdsContext;
    private boolean useSSL = false;
    private String sslPort = "8443";

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setSslPort(String sslPort) {
        this.sslPort = sslPort;
    }

    @Override
    public void setRoleSource(RoleSource db) {
    }

    @Override
    public boolean authorize(HttpServletRequest req, HttpServletResponse res, String role) throws IOException {
        String urlr;
        if (log.isDebugEnabled()) {
            log.debug("TomcatAuthorizer.authorize req=" + ServletUtil.getRequest(req));
        }
        if (req.isUserInRole(role)) {
            if (log.isDebugEnabled()) {
                log.debug("TomcatAuthorizer.authorize ok for role {}", (Object)role);
            }
            return true;
        }
        HttpSession session = req.getSession();
        session.setAttribute("origRequest", (Object)ServletUtil.getRequest(req));
        session.setAttribute("role", (Object)role);
        String string = urlr = this.useSSL ? "https://" + req.getServerName() + ":" + this.sslPort + this.tdsContext.getContextPath() + "/restrictedAccess/" + role : "http://" + req.getServerName() + ":" + req.getServerPort() + this.tdsContext.getContextPath() + "/restrictedAccess/" + role;
        if (log.isDebugEnabled()) {
            log.debug("redirect to = {}", (Object)urlr);
        }
        res.setStatus(307);
        res.addHeader("Location", urlr);
        res.setHeader("Last-Modified", "");
        return false;
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession();
        if (session != null) {
            String origURI = (String)session.getAttribute("origRequest");
            String role = (String)session.getAttribute("role");
            if (req.isUserInRole(role)) {
                if (origURI != null) {
                    res.setStatus(307);
                    String frag = origURI.indexOf("?") > 0 ? "&auth" : "?auth";
                    res.addHeader("Location", origURI);
                    if (log.isDebugEnabled()) {
                        log.debug("redirect to origRequest = " + origURI);
                    }
                    return;
                }
                res.setStatus(200);
                return;
            }
        }
        res.sendError(403, "Not authorized to access this dataset.");
    }
}

