/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import thredds.client.catalog.ServiceType;

public enum StandardService {
    catalogRemote(ServiceType.Catalog, "/catalog/"),
    cdmRemote(ServiceType.CdmRemote, "/cdmremote/"),
    cdmrFeatureGrid(ServiceType.CdmrFeature, "/cdmrfeature/grid/"),
    cdmrFeaturePoint(ServiceType.CdmrFeature, "/cdmrfeature/point/"),
    dap4(ServiceType.DAP4, "/dap4/"),
    httpServer(ServiceType.HTTPServer, "/fileServer/"),
    jupyterNotebook(ServiceType.JupyterNotebook, "/notebook/"),
    resolver(ServiceType.Resolver, ""),
    netcdfSubsetGrid(ServiceType.NetcdfSubset, "/ncss/grid/"),
    netcdfSubsetPoint(ServiceType.NetcdfSubset, "/ncss/point/"),
    opendap(ServiceType.OPENDAP, "/dodsC/"),
    wcs(ServiceType.WCS, "/wcs/"),
    wms(ServiceType.WMS, "/wms/"),
    wfs(ServiceType.WFS, "/wfs/"),
    iso(ServiceType.ISO, "/iso/"),
    iso_ncml(ServiceType.NCML, "/ncml/"),
    uddc(ServiceType.UDDC, "/uddc/");

    final ServiceType type;
    final String base;

    public static StandardService getStandardServiceIgnoreCase(String typeS) {
        for (StandardService s : StandardService.values()) {
            if (!s.toString().equalsIgnoreCase(typeS)) continue;
            return s;
        }
        return null;
    }

    private StandardService(ServiceType type, String base) {
        this.type = type;
        this.base = base;
    }

    public ServiceType getType() {
        return this.type;
    }

    public String getBase() {
        return this.base;
    }
}

