/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import thredds.server.cdmremote.CdmRemoteQueryBean;

public class CdmRemoteQueryBeanValidator
implements Validator {
    public boolean supports(Class<?> clazz) {
        return CdmRemoteQueryBean.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"req", (String)"req.empty", (String)"must have a req parameter");
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"var", (String)"var.empty", (String)"data request must have a var paramater");
        CdmRemoteQueryBean bean = (CdmRemoteQueryBean)target;
        if (bean.getReq() == null) {
            bean.addError("must have a req parameter");
        }
        if (bean.getVar() == null) {
            bean.addError("data request must have a var parameter");
        }
        CdmRemoteQueryBean.RequestType reqType = bean.getReq().equalsIgnoreCase("capabilities") ? CdmRemoteQueryBean.RequestType.capabilities : (bean.getReq().equalsIgnoreCase("cdl") ? CdmRemoteQueryBean.RequestType.cdl : (bean.getReq().equalsIgnoreCase("form") ? CdmRemoteQueryBean.RequestType.cdl : (bean.getReq().equalsIgnoreCase("data") ? CdmRemoteQueryBean.RequestType.data : (bean.getReq().equalsIgnoreCase("header") ? CdmRemoteQueryBean.RequestType.header : (bean.getReq().equalsIgnoreCase("ncml") ? CdmRemoteQueryBean.RequestType.ncml : CdmRemoteQueryBean.RequestType.data)))));
        bean.setReqType(reqType);
        int deflateLevel = bean.getDeflate();
        if (deflateLevel >= 0) {
            bean.setDeflate(deflateLevel);
        }
    }
}

