/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmrfeature;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import thredds.core.AllowedServices;
import thredds.core.StandardService;
import thredds.core.TdsRequestedDataset;
import thredds.server.config.TdsContext;
import thredds.server.exception.ServiceNotAllowed;
import thredds.server.ncss.params.NcssGridParamsBean;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.remote.CdmrFeatureProto;
import ucar.nc2.ft2.coverage.remote.CdmrfWriter;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamDataCol;
import ucar.nc2.stream.NcStreamProto;

@Controller
@RequestMapping(value={"/cdmrfeature/grid"})
public class CdmrGridController {
    private static final boolean showReq = false;
    private static final boolean showRes = false;
    @Autowired
    TdsContext tdsContext;
    @Autowired
    private AllowedServices allowedServices;

    @RequestMapping(value={"/**"}, method={RequestMethod.GET}, params={"req=featureType"})
    public ResponseEntity<String> handleFeatureTypeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.allowedServices.isAllowed(StandardService.cdmrFeatureGrid)) {
            throw new ServiceNotAllowed(StandardService.cdmrFeatureGrid.toString());
        }
        String datasetPath = TdsPathUtils.extractPath(request, StandardService.cdmrFeatureGrid.getBase());
        try (CoverageCollection cc = TdsRequestedDataset.getCoverageCollection(request, response, datasetPath);){
            if (cc == null) {
                ResponseEntity<String> responseEntity = null;
                return responseEntity;
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Type", ContentType.text.getContentHeader());
            ResponseEntity responseEntity = new ResponseEntity((Object)cc.getCoverageType().toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
            return responseEntity;
        }
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET}, params={"req=header"})
    public void handleHeaderRequest(HttpServletRequest request, HttpServletResponse response, OutputStream out) throws IOException {
        if (!this.allowedServices.isAllowed(StandardService.cdmrFeatureGrid)) {
            throw new ServiceNotAllowed(StandardService.cdmrFeatureGrid.toString());
        }
        String datasetPath = TdsPathUtils.extractPath(request, StandardService.cdmrFeatureGrid.getBase());
        try (CoverageCollection gridCoverageDataset = TdsRequestedDataset.getCoverageCollection(request, response, datasetPath);){
            if (gridCoverageDataset == null) {
                return;
            }
            response.setContentType(ContentType.binary.getContentHeader());
            response.setHeader("Content-Description", "ncstream");
            response.addDateHeader("Last-Modified", TdsRequestedDataset.getLastModified(datasetPath));
            CdmrfWriter writer = new CdmrfWriter();
            long size = writer.sendHeader(out, gridCoverageDataset, ServletUtil.getRequestBase(request));
            out.flush();
        }
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET}, params={"req=form"})
    public ResponseEntity<String> handleFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.allowedServices.isAllowed(StandardService.cdmrFeatureGrid)) {
            throw new ServiceNotAllowed(StandardService.cdmrFeatureGrid.toString());
        }
        String datasetPath = TdsPathUtils.extractPath(request, StandardService.cdmrFeatureGrid.getBase());
        try (CoverageCollection gridCoverageDataset = TdsRequestedDataset.getCoverageCollection(request, response, datasetPath);){
            if (gridCoverageDataset == null) {
                ResponseEntity<String> responseEntity = null;
                return responseEntity;
            }
            String text = gridCoverageDataset.toString();
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Type", ContentType.text.getContentHeader());
            responseHeaders.setDate("Last-Modified", TdsRequestedDataset.getLastModified(datasetPath));
            ResponseEntity responseEntity = new ResponseEntity((Object)text, (MultiValueMap)responseHeaders, HttpStatus.OK);
            return responseEntity;
        }
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET}, params={"req=coord"})
    public void handleCoordRequest(HttpServletRequest request, HttpServletResponse response, @RequestParam String var, OutputStream out) throws IOException, BindException, InvalidRangeException {
        if (!this.allowedServices.isAllowed(StandardService.cdmrFeatureGrid)) {
            throw new ServiceNotAllowed(StandardService.cdmrFeatureGrid.toString());
        }
        String datasetPath = TdsPathUtils.extractPath(request, StandardService.cdmrFeatureGrid.getBase());
        try (CoverageCollection gridCoverageDataset = TdsRequestedDataset.getCoverageCollection(request, response, datasetPath);){
            String[] coordNames;
            if (gridCoverageDataset == null) {
                return;
            }
            response.setContentType(ContentType.binary.getContentHeader());
            response.setHeader("Content-Description", "ncstream");
            for (String coordName : coordNames = var.split(",")) {
                double[] values;
                CoverageCoordAxis coord = gridCoverageDataset.findCoordAxis(coordName);
                if (!coord.isRegular()) {
                    values = coord.getValues();
                } else {
                    values = new double[coord.getNcoords()];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = coord.getStartValue() + (double)i * coord.getResolution();
                    }
                }
                this.sendCoordData(coord.getName(), new Section(new Range[]{new Range(values.length)}), Array.makeFromJavaArray((Object)values), out);
            }
            out.flush();
        }
        catch (Throwable t) {
            throw new RuntimeException("CdmrGridController on dataset " + datasetPath, t);
        }
    }

    private long sendCoordData(String name, Section section, Array data, OutputStream out) throws IOException, InvalidRangeException {
        NcStreamDataCol encoder = new NcStreamDataCol();
        NcStreamProto.DataCol dataProto = encoder.encodeData2(name, false, section, data);
        long size = 0L;
        size += (long)this.writeBytes(out, NcStream.MAGIC_DATA2);
        byte[] datab = dataProto.toByteArray();
        size += (long)NcStream.writeVInt((OutputStream)out, (int)datab.length);
        return size += (long)this.writeBytes(out, datab);
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET}, params={"req=data"})
    public void handleDataRequest(HttpServletRequest request, HttpServletResponse response, @Valid NcssGridParamsBean qb, BindingResult validationResult, OutputStream out) throws IOException, BindException, InvalidRangeException {
        long start = System.currentTimeMillis();
        if (!this.allowedServices.isAllowed(StandardService.cdmrFeatureGrid)) {
            throw new ServiceNotAllowed(StandardService.cdmrFeatureGrid.toString());
        }
        if (validationResult.hasErrors()) {
            throw new BindException(validationResult);
        }
        String datasetPath = TdsPathUtils.extractPath(request, StandardService.cdmrFeatureGrid.getBase());
        try (CoverageCollection gridCoverageDataset = TdsRequestedDataset.getCoverageCollection(request, response, datasetPath);){
            if (gridCoverageDataset == null) {
                return;
            }
            response.setContentType(ContentType.binary.getContentHeader());
            response.setHeader("Content-Description", "ncstream");
            SubsetParams params = qb.makeSubset(gridCoverageDataset);
            ArrayList<GeoReferencedArray> arrays = new ArrayList<GeoReferencedArray>();
            for (String gridWanted : qb.getVar()) {
                Coverage grid = gridCoverageDataset.findCoverage(gridWanted);
                GeoReferencedArray array = grid.readData(params);
                arrays.add(array);
            }
            this.sendDataResponse(arrays, out, false);
            out.flush();
        }
        catch (Throwable t) {
            throw new RuntimeException("CdmrGridController on dataset " + datasetPath, t);
        }
    }

    private long sendDataResponse(List<GeoReferencedArray> arrays, OutputStream out, boolean deflate) throws IOException, InvalidRangeException {
        Set sysSet = arrays.stream().map(GeoReferencedArray::getCoordSysForData).collect(Collectors.toSet());
        HashSet transformSet = new HashSet();
        HashSet axisSet = new HashSet();
        for (CoverageCoordSys sys : sysSet) {
            axisSet.addAll(sys.getAxes().stream().collect(Collectors.toList()));
            transformSet.addAll(sys.getTransforms().stream().collect(Collectors.toList()));
        }
        CdmrfWriter cdmrfWriter = new CdmrfWriter();
        long size = 0L;
        size += (long)this.writeBytes(out, NcStream.MAGIC_DATACOV);
        CdmrFeatureProto.CoverageDataResponse dataProto = cdmrfWriter.encodeDataResponse(axisSet, sysSet, transformSet, arrays, deflate);
        byte[] datab = dataProto.toByteArray();
        size += (long)NcStream.writeVInt((OutputStream)out, (int)datab.length);
        return size += (long)this.writeBytes(out, datab);
    }

    private long sendData(Array data, OutputStream out, boolean deflate) throws IOException, InvalidRangeException {
        long uncompressedLength = data.getSizeBytes();
        long size = 0L;
        if (deflate) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DeflaterOutputStream dout = new DeflaterOutputStream(bout);
            IospHelper.copyToOutputStream((Array)data, (OutputStream)dout);
            dout.close();
            int deflatedSize = bout.size();
            size += (long)NcStream.writeVInt((OutputStream)out, (int)deflatedSize);
            bout.writeTo(out);
            size += (long)deflatedSize;
            float f = (float)uncompressedLength / (float)deflatedSize;
        } else {
            size += (long)NcStream.writeVInt((OutputStream)out, (int)((int)uncompressedLength));
            size += IospHelper.copyToOutputStream((Array)data, (OutputStream)out);
        }
        return size;
    }

    private int writeBytes(OutputStream out, byte[] b) throws IOException {
        out.write(b);
        return b.length;
    }
}

