/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.root;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import thredds.server.config.TdsContext;
import thredds.util.RequestForwardUtils;
import thredds.util.TdsPathUtils;

@Controller
public class RootController {
    @Autowired
    private TdsContext tdsContext;

    @RequestMapping(value={"/", "/catalog.html"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public String redirectRootCatalog() {
        return "redirect:/catalog/catalog.html";
    }

    @RequestMapping(value={"/catalog.xml"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public String redirectRootCatalogXml() {
        return "redirect:/catalog/catalog.xml";
    }

    @RequestMapping(value={"*.css", "*.gif", "*.jpg", "*.png", "*.jsp", "sitemap.xml"}, method={RequestMethod.GET})
    public ModelAndView serveFromPublicDirectory(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String path = TdsPathUtils.extractPath(req, null);
        File file = this.tdsContext.getPublicContentDirSource().getFile(path);
        if (file == null) {
            RequestForwardUtils.forwardRequest(path, this.tdsContext.getDefaultRequestDispatcher(), req, res);
            return null;
        }
        return new ModelAndView("threddsFileView", "file", (Object)file);
    }
}

