/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wfs;

import ucar.nc2.ft2.simpgeometry.Line;
import ucar.nc2.ft2.simpgeometry.Point;
import ucar.nc2.ft2.simpgeometry.Polygon;
import ucar.nc2.ft2.simpgeometry.SimpleGeometry;

public class GMLFeatureWriter {
    public String writeFeature(SimpleGeometry geom) {
        if (geom instanceof Point) {
            return this.writePoint((Point)geom);
        }
        if (geom instanceof Line) {
            return this.writeLine((Line)geom);
        }
        if (geom instanceof Polygon) {
            return this.writePolygon((Polygon)geom);
        }
        return null;
    }

    private String writePoint(Point point) {
        String xml = "";
        xml = xml + "<gml:Point srsName=\"http://www.opengis.net/gml/srs/epsg.xml@900913\" srsDimension=\"2\"><gml:pos>" + point.getX() + " " + point.getY() + "</gml:pos></gml:Point>";
        return xml;
    }

    private String writeLine(Line line) {
        String xml = "";
        xml = xml + "<gml:LineString><gml:posList>";
        for (Point point : line.getPoints()) {
            xml = xml + point.getX() + " " + point.getY() + " ";
        }
        xml = xml + "</gml:posList></gml:LineString>";
        return xml;
    }

    private String writePolygon(Polygon poly) {
        String xml = "";
        xml = xml + "<gml:Polygon>";
        Polygon polygon = poly;
        if (!polygon.getInteriorRing()) {
            xml = xml + "<gml:exterior><gml:LinearRing><gml:posList>";
            for (Point point : polygon.getPoints()) {
                xml = xml + point.getX() + " " + point.getY() + " ";
            }
            xml = xml + "</gml:posList></gml:LinearRing></gml:exterior>";
        } else {
            xml = xml + "<gml:interior><gml:LinearRing><gml:posList>";
            for (Point point : polygon.getPoints()) {
                xml = xml + point.getX() + " " + point.getY() + " ";
            }
            xml = xml + "</gml:posList></gml:LinearRing></gml:interior>";
        }
        xml = xml + "</gml:Polygon>";
        return xml;
    }
}

