/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wfs;

import java.io.PrintWriter;
import java.util.List;
import thredds.server.wfs.GMLFeatureWriter;
import thredds.server.wfs.WFSXMLHelper;
import ucar.nc2.ft2.simpgeometry.SimpleGeometry;

public class WFSGetFeatureWriter {
    private PrintWriter response;
    private String fileOutput = "";
    private final String namespace;
    private final String server;
    private final String ftName;
    private List<SimpleGeometry> geometries;

    private void writeHeadersAndBB() {
        double[] boundUpper;
        double[] boundLower;
        this.fileOutput = this.fileOutput + "<wfs:FeatureCollection xsi:schemaLocation=" + WFSXMLHelper.encQuotes("http://www.opengis.net/wfs/2.0 http://schemas.opengis.net/wfs/2.0/wfs.xsd " + this.namespace + " " + this.server + "?request=DescribeFeatureType" + "&amp;" + "service=wfs" + "&amp;" + "version=2.0.0" + "&amp;" + "typename=" + "tdswfs" + "%3A" + this.ftName) + " xmlns:xsi=" + WFSXMLHelper.encQuotes("http://www.w3.org/2001/XMLSchema-instance") + " xmlns:xlink=" + WFSXMLHelper.encQuotes("http://www.w3.org/1999/xlink") + " xmlns:gml=" + WFSXMLHelper.encQuotes("http://opengis.net/gml/3.2") + " xmlns:fes=" + WFSXMLHelper.encQuotes("http://www.opengis.net/fes/2.0") + " xmlns:ogc=" + WFSXMLHelper.encQuotes("http://www.opengis.net/ogc") + " xmlns:wfs=" + WFSXMLHelper.encQuotes("http://opengis.net/wfs/2.0") + " xmlns:" + "tdswfs" + "=" + WFSXMLHelper.encQuotes(this.namespace) + " xmlns=" + WFSXMLHelper.encQuotes("http://www.opengis.net/wfs/2.0") + " version=\"2.0.0\" numberMatched=" + WFSXMLHelper.encQuotes(String.valueOf(this.geometries.size())) + " numberReturned=" + WFSXMLHelper.encQuotes(String.valueOf(this.geometries.size())) + ">";
        if (this.geometries.isEmpty()) {
            boundLower = new double[2];
            boundUpper = new double[2];
            boundLower[0] = -180.0;
            boundLower[1] = -90.0;
            boundUpper[0] = 180.0;
            boundUpper[1] = 90.0;
        } else {
            boundLower = this.geometries.get(0).getBBLower();
            boundUpper = this.geometries.get(0).getBBUpper();
        }
        for (SimpleGeometry item : this.geometries) {
            double[] upper;
            double[] low = item.getBBLower();
            if (boundLower[0] > low[0]) {
                boundLower[0] = low[0];
            }
            if (boundLower[1] > low[1]) {
                boundLower[1] = low[1];
            }
            if (boundUpper[0] < (upper = item.getBBUpper())[0]) {
                boundUpper[0] = upper[0];
            }
            if (boundUpper[1] < upper[1]) {
                boundUpper[1] = upper[1];
            }
            boundLower[0] = boundLower[0] - 10.0;
            boundLower[1] = boundLower[1] - 10.0;
            boundUpper[0] = boundUpper[0] + 10.0;
            boundUpper[1] = boundUpper[1] + 10.0;
        }
        this.fileOutput = this.fileOutput + "<wfs:boundedBy><wfs:Envelope srsName=\"urn:ogc:def:crs:EPSG::4326\"><wfs:lowerCorner>" + boundLower[0] + " " + boundLower[1] + "</wfs:lowerCorner><wfs:upperCorner>" + boundUpper[0] + " " + boundUpper[1] + "</wfs:upperCorner></wfs:Envelope></wfs:boundedBy>";
    }

    public void startXML() {
        this.fileOutput = this.fileOutput + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        this.writeHeadersAndBB();
    }

    public void writeMembers() {
        int index = 1;
        GMLFeatureWriter writer = new GMLFeatureWriter();
        for (SimpleGeometry geometryItem : this.geometries) {
            double[] lowerCorner = geometryItem.getBBLower();
            double[] upperCorner = geometryItem.getBBUpper();
            this.fileOutput = this.fileOutput + "<wfs:member><tdswfs:" + this.ftName + " gml:id=\"" + this.ftName + "." + index + "\"><gml:boundedBy><gml:Envelope srsName=\"urn:ogc:def:crs:EPSG::4326\"><gml:lowerCorner>" + lowerCorner[0] + " " + lowerCorner[1] + "</gml:lowerCorner><gml:upperCorner>" + upperCorner[0] + " " + upperCorner[1] + "</gml:upperCorner></gml:Envelope></gml:boundedBy><" + "tdswfs" + ":geometryInformation>";
            this.fileOutput = this.fileOutput + writer.writeFeature(geometryItem);
            this.fileOutput = this.fileOutput + "</tdswfs:geometryInformation></tdswfs:" + this.ftName + "></wfs:member>";
            ++index;
        }
    }

    public void finishXML() {
        this.fileOutput = this.fileOutput + "</wfs:FeatureCollection>";
        this.response.append(this.fileOutput);
        this.fileOutput = null;
        this.response = null;
    }

    public WFSGetFeatureWriter(PrintWriter response, String server, String namespace, List<SimpleGeometry> geometries, String ftName) {
        this.response = response;
        this.server = server;
        this.namespace = namespace;
        this.geometries = geometries;
        this.ftName = ftName;
    }
}

