/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.ServiceType;
import thredds.server.catalog.CatalogScan;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalogservice.CatalogItemContext;
import thredds.server.catalogservice.DatasetContext;
import thredds.server.catalogservice.JsonLD;
import thredds.server.catalogservice.RemoteCatalogRequest;
import thredds.server.config.HtmlConfigBean;
import thredds.server.config.TdsContext;
import thredds.server.config.TdsServerInfoBean;
import thredds.server.viewer.ViewerService;
import ucar.unidata.util.StringUtil2;

@Component
public class CatalogViewContextParser {
    @Autowired
    private ViewerService viewerService;
    @Autowired
    private HtmlConfigBean htmlConfig;
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private TdsServerInfoBean serverInfo;

    public Map<String, Object> getCatalogViewContext(Catalog cat, HttpServletRequest req, boolean isLocalCatalog) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.addBaseContext(model);
        try {
            if (cat.getParent() == null) {
                model.put("rootCatalog", true);
            }
        }
        catch (Exception e) {
            model.put("rootCatalog", false);
        }
        ArrayList<CatalogItemContext> catalogItems = new ArrayList<CatalogItemContext>();
        this.addCatalogItems((DatasetNode)cat, catalogItems, isLocalCatalog, 0);
        model.put("items", catalogItems);
        return model;
    }

    public Map<String, Object> getDatasetViewContext(Dataset ds, HttpServletRequest req, boolean isLocalCatalog) {
        String jsonLD;
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.addBaseContext(model);
        DatasetContext context = new DatasetContext(ds, isLocalCatalog, this.tdsContext, req);
        this.populateDatasetContext(ds, context, req, isLocalCatalog);
        model.put("dataset", context);
        if (this.htmlConfig.getGenerateDatasetJsonLD().booleanValue() && !(jsonLD = JsonLD.makeDatasetJsonLD(ds, context, this.tdsContext)).isEmpty()) {
            model.put("jsonLD", jsonLD);
        }
        return model;
    }

    private void addBaseContext(Map<String, Object> model) {
        String googleTrackingCode = this.htmlConfig.getGoogleTrackingCode();
        if (googleTrackingCode.isEmpty()) {
            googleTrackingCode = null;
        }
        model.put("googleTracking", googleTrackingCode);
        model.put("serverName", this.serverInfo.getName());
        model.put("logoUrl", this.serverInfo.getLogoUrl());
        model.put("logoAlt", this.serverInfo.getLogoAltText());
        model.put("installName", this.htmlConfig.getInstallName());
        model.put("installUrl", this.htmlConfig.getInstallUrl());
        model.put("webappName", this.htmlConfig.getWebappName());
        model.put("webappUrl", this.htmlConfig.getWebappUrl());
        model.put("webappVersion", this.htmlConfig.getWebappVersion());
        model.put("webappBuildTimestamp", this.htmlConfig.getWebappVersionBuildDate());
        model.put("webappDocsUrl", this.htmlConfig.getWebappDocsUrl());
        model.put("contextPath", this.htmlConfig.getWebappContextPath());
        model.put("hostInst", this.htmlConfig.getHostInstName());
        model.put("hostInstUrl", this.htmlConfig.getHostInstUrl());
        model.put("standardCSS", this.htmlConfig.getPageCssUrl());
        model.put("catalogCSS", this.htmlConfig.getCatalogCssUrl());
        model.put("datasetCSS", this.htmlConfig.getDatasetCssUrl());
    }

    protected void addCatalogItems(DatasetNode cat, List<CatalogItemContext> catalogItems, boolean isLocalCatalog, int level) {
        for (Dataset ds : cat.getDatasets()) {
            this.populateItemContext(ds, catalogItems, isLocalCatalog, level);
        }
    }

    protected void populateItemContext(Dataset ds, List<CatalogItemContext> catalogItems, boolean isLocalCatalog, int level) {
        CatalogItemContext context = new CatalogItemContext(ds, level);
        context.setHref(this.getCatalogItemHref(ds, isLocalCatalog));
        context.setIconSrc(this.getFolderIconSrc(ds));
        catalogItems.add(context);
        if (!(ds instanceof CatalogRef)) {
            this.addCatalogItems((DatasetNode)ds, catalogItems, isLocalCatalog, level + 1);
        }
    }

    protected void populateDatasetContext(Dataset ds, DatasetContext context, HttpServletRequest req, boolean isLocalCatalog) {
        if (ds instanceof CatalogRef) {
            CatalogRef catref = (CatalogRef)ds;
            context.addContextItem("href", this.getCatalogRefHref(catref, isLocalCatalog));
        }
        if (isLocalCatalog) {
            context.setViewers(ds, this.viewerService.getViewerLinks(ds, req));
        }
    }

    private String getCatalogItemHref(Dataset ds, boolean isLocalCatalog) {
        if (ds instanceof CatalogRef) {
            CatalogRef catref = (CatalogRef)ds;
            String href = catref.getXlinkHref();
            if (!isLocalCatalog) {
                URI hrefUri = ds.getParentCatalog().getBaseURI().resolve(href);
                href = hrefUri.toString();
            }
            try {
                URI uri = new URI(href);
                if (uri.isAbsolute()) {
                    boolean defaultUseRemoteCatalogService = this.htmlConfig.getUseRemoteCatalogService();
                    Boolean dsUseRemoteCatalogService = ((CatalogRef)ds).useRemoteCatalogService();
                    boolean useRemoteCatalogService = defaultUseRemoteCatalogService;
                    if (dsUseRemoteCatalogService == null) {
                        dsUseRemoteCatalogService = defaultUseRemoteCatalogService;
                    }
                    if (defaultUseRemoteCatalogService != dsUseRemoteCatalogService) {
                        useRemoteCatalogService = dsUseRemoteCatalogService;
                    }
                    if (useRemoteCatalogService) {
                        href = this.tdsContext.getContextPath() + "/remoteCatalogService?catalog=" + href;
                    } else {
                        int pos = href.lastIndexOf(46);
                        href = href.substring(0, pos) + ".html";
                    }
                } else {
                    int pos = href.lastIndexOf(46);
                    href = href.substring(0, pos) + ".html";
                }
            }
            catch (Exception uri) {
                // empty catch block
            }
            return href;
        }
        if (ds.getAccess().size() == 1 && ServiceType.Resolver == ((Access)ds.getAccess().get(0)).getService().getType()) {
            Access access = (Access)ds.getAccess().get(0);
            String accessUrlName = access.getUnresolvedUrlName();
            int pos = accessUrlName.lastIndexOf(".xml");
            if (accessUrlName.equalsIgnoreCase("latest.xml") && !isLocalCatalog) {
                String catBaseUriPath = "";
                String catBaseUri = ds.getParentCatalog().getBaseURI().toString();
                pos = catBaseUri.lastIndexOf("catalog.xml");
                if (pos != -1) {
                    catBaseUriPath = catBaseUri.substring(0, pos);
                }
                accessUrlName = this.tdsContext.getContextPath() + "/remoteCatalogService?catalog=" + catBaseUriPath + accessUrlName;
            } else if (pos != -1) {
                accessUrlName = accessUrlName.substring(0, pos) + ".html";
            }
            return accessUrlName;
        }
        if (ds.findProperty("NotAThreddsDataset") != null) {
            return this.makeFileServerUrl(ds);
        }
        if (ds.getID() != null) {
            String catHtml;
            Catalog cat = ds.getParentCatalog();
            if (!isLocalCatalog) {
                catHtml = this.tdsContext.getContextPath() + "/remoteCatalogService?command=" + (Object)((Object)RemoteCatalogRequest.Command.SUBSET) + "&catalog=" + cat.getUriString() + "&";
            } else {
                int pos;
                URI catURI = cat.getBaseURI();
                catHtml = catURI.getPath();
                if (catHtml == null) {
                    catHtml = cat.getUriString();
                }
                if ((pos = catHtml.lastIndexOf("/")) != -1) {
                    catHtml = catHtml.substring(pos + 1);
                }
                catHtml = (pos = catHtml.lastIndexOf(46)) < 0 ? catHtml + "catalog.html?" : catHtml.substring(0, pos) + ".html?";
            }
            return catHtml + "dataset=" + StringUtil2.replace((String)ds.getID(), (char)'+', (String)"%2B");
        }
        return null;
    }

    private String getCatalogRefHref(CatalogRef catref, boolean isLocalCatalog) {
        String href = catref.getXlinkHref();
        if (!isLocalCatalog) {
            href = CatalogViewContextParser.makeHrefResolve((Dataset)catref, href);
        }
        return href;
    }

    protected static String makeHrefResolve(Dataset ds, String href) {
        Catalog cat = ds.getParentCatalog();
        if (cat != null) {
            try {
                URI uri = cat.resolveUri(href);
                href = uri.toString();
            }
            catch (URISyntaxException e) {
                return "CatalogViewContextParser: error parsing URL= " + href;
            }
        }
        return href;
    }

    private String getFolderIconSrc(Dataset ds) {
        String iconSrc = null;
        if (ds instanceof CatalogRef) {
            iconSrc = ds instanceof CatalogScan || ds.hasProperty("CatalogScan") ? "cat_folder.png" : (ds instanceof DatasetScan || ds.hasProperty("DatasetScan") ? "scan_folder.png" : (ds instanceof FeatureCollectionRef ? "fc_folder.png" : "folder.png"));
        } else if (ds.hasNestedDatasets()) {
            iconSrc = "folder.png";
        }
        if (iconSrc != null) {
            iconSrc = this.htmlConfig.prepareUrlStringForHtml(iconSrc);
        }
        return iconSrc;
    }

    private String makeFileServerUrl(Dataset ds) {
        Access acc = ds.getAccess(ServiceType.HTTPServer);
        assert (acc != null);
        return acc.getStandardUrlName();
    }
}

