/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import thredds.server.catalogservice.CatalogViewContextParser;
import thredds.server.config.TdsContext;
import thredds.server.viewer.ViewerLinkProvider;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

class DatasetContext {
    private String contentDir;
    private String name;
    private String catUrl;
    private String catName;
    private Map<String, Object> context;
    private List<Map<String, String>> documentation;
    private List<Map<String, String>> access;
    private List<Map<String, String>> contributors;
    private List<Map<String, String>> keywords;
    private List<Map<String, String>> dates;
    private List<Map<String, String>> projects;
    private List<Map<String, String>> creators;
    private List<Map<String, String>> publishers;
    private List<Map<String, Object>> variables;
    private String variableMapLink;
    private Map<String, Object> geospatialCoverage;
    private Map<String, Object> timeCoverage;
    private List<Map<String, String>> metadata;
    private List<Map<String, String>> properties;
    private List<Map<String, String>> viewerLinks;

    public DatasetContext(Dataset ds, boolean isLocalCatalog, TdsContext tdsContext, HttpServletRequest req) {
        String reqUri;
        this.contentDir = tdsContext.getContentRootPathProperty();
        this.name = ds.getName();
        String catUrl = ds.getCatalogUrl();
        if (catUrl.indexOf(35) > 0) {
            catUrl = catUrl.substring(0, catUrl.lastIndexOf(35));
        }
        if ((catUrl = catUrl.replace("xml", "html")).startsWith("/") && (reqUri = req.getRequestURL().toString()).contains(req.getContextPath())) {
            String baseUriString = reqUri.split(req.getContextPath())[0];
            catUrl = baseUriString + catUrl;
        }
        this.catUrl = catUrl;
        this.catName = ds.getParentCatalog().getName();
        this.setContext(ds);
        this.setDocumentation(ds);
        this.setAccess(ds, isLocalCatalog);
        this.setContributors(ds);
        this.setKeywords(ds);
        this.setDates(ds);
        this.setProjects(ds);
        this.setCreators(ds, isLocalCatalog);
        this.setPublishers(ds, isLocalCatalog);
        this.setVariables(ds, isLocalCatalog);
        this.setGeospatialCoverage(ds);
        this.setTimeCoverage(ds);
        this.setMetadata(ds, isLocalCatalog);
        this.setProperties(ds, isLocalCatalog);
        this.viewerLinks = new ArrayList<Map<String, String>>();
    }

    private void setContext(Dataset ds) {
        String restrictAccess;
        String id;
        String authority;
        boolean isHarvest;
        String collectionType;
        String featureType;
        long dataSize;
        this.context = new HashMap<String, Object>();
        String dataFormat = ds.getDataFormatName();
        if (dataFormat != null) {
            this.context.put("dataFormat", dataFormat);
        }
        if ((dataSize = ds.getDataSize()) > 0L) {
            this.context.put("dataSize", dataSize);
        }
        if ((featureType = ds.getFeatureTypeName()) != null) {
            this.context.put("featureType", featureType);
        }
        if ((collectionType = ds.getCollectionType()) != null) {
            this.context.put("collectionType", collectionType);
        }
        if (isHarvest = ds.isHarvest()) {
            this.context.put("isHarvest", true);
        }
        if ((authority = ds.getAuthority()) != null) {
            this.context.put("authority", authority);
        }
        if ((id = ds.getId()) != null) {
            this.context.put("id", id);
        }
        if ((restrictAccess = ds.getRestrictAccess()) != null) {
            this.context.put("restrictAccess", restrictAccess);
        }
    }

    private void setDocumentation(Dataset ds) {
        List docs = ds.getDocumentation();
        this.documentation = new ArrayList<Map<String, String>>(docs.size());
        for (Documentation doc : docs) {
            HashMap<String, String> docMap = new HashMap<String, String>();
            String inlineContent = doc.getInlineContent();
            if (inlineContent.isEmpty()) {
                inlineContent = null;
            }
            docMap.put("inlineContent", inlineContent);
            String type = doc.getType();
            if (type == null) {
                type = "";
            }
            docMap.put("type", type);
            if (doc.hasXlink()) {
                docMap.put("href", doc.getXlinkHref());
                docMap.put("title", doc.getXlinkTitle());
            }
            this.documentation.add(docMap);
        }
    }

    private void setAccess(Dataset ds, boolean isLocalCatalog) {
        List access = ds.getAccess();
        this.access = new ArrayList<Map<String, String>>(access.size());
        for (Access a : access) {
            Service s = a.getService();
            String urlString = !isLocalCatalog ? a.getStandardUrlName() : a.getUnresolvedUrlName();
            String queryString = null;
            String catalogUrl = null;
            String datasetId = null;
            ServiceType stype = s.getType();
            if (stype != null) {
                switch (stype) {
                    case OPENDAP: 
                    case DODS: {
                        urlString = urlString + ".html";
                        break;
                    }
                    case DAP4: {
                        urlString = urlString + ".dmr.xml";
                        break;
                    }
                    case WCS: {
                        queryString = "service=WCS&version=1.0.0&request=GetCapabilities";
                        break;
                    }
                    case WMS: {
                        queryString = "service=WMS&version=1.3.0&request=GetCapabilities";
                        break;
                    }
                    case WFS: {
                        queryString = "service=WFS&version=2.0.0&request=GetCapabilities";
                        break;
                    }
                    case NCML: 
                    case UDDC: 
                    case ISO: {
                        catalogUrl = ds.getCatalogUrl();
                        datasetId = ds.getId();
                        if (catalogUrl == null || datasetId == null) break;
                        if (catalogUrl.indexOf(35) > 0) {
                            catalogUrl = catalogUrl.substring(0, catalogUrl.lastIndexOf(35));
                        }
                        queryString = "catalog=" + catalogUrl + "&dataset=" + datasetId;
                        break;
                    }
                    case JupyterNotebook: {
                        datasetId = ds.getId();
                        catalogUrl = ds.getCatalogUrl();
                        if (catalogUrl.indexOf(35) > 0) {
                            catalogUrl = catalogUrl.substring(0, catalogUrl.lastIndexOf(35));
                        }
                        if (catalogUrl.indexOf(this.contentDir) > -1) {
                            catalogUrl = catalogUrl.substring(catalogUrl.indexOf(this.contentDir) + this.contentDir.length());
                        }
                        catalogUrl = catalogUrl.substring(catalogUrl.indexOf("/catalog/") + "/catalog/".length()).replace("html", "xml");
                        queryString = "catalog=" + catalogUrl;
                        urlString = urlString.substring(0, urlString.indexOf(s.getBase()) + s.getBase().length()) + datasetId;
                        break;
                    }
                    case NetcdfSubset: {
                        urlString = urlString + "/dataset.html";
                        break;
                    }
                    case CdmRemote: {
                        queryString = "req=cdl";
                        break;
                    }
                    case CdmrFeature: {
                        queryString = "req=form";
                    }
                }
            }
            HashMap<String, String> accessMap = new HashMap<String, String>();
            accessMap.put("serviceTypeName", s.getServiceTypeName());
            accessMap.put("serviceDesc", s.getDesc());
            accessMap.put("accessType", s.getAccessType());
            accessMap.put("href", queryString == null ? urlString : urlString + "?" + queryString);
            this.access.add(accessMap);
        }
    }

    private void setContributors(Dataset ds) {
        List contributors = ds.getContributors();
        this.contributors = new ArrayList<Map<String, String>>(contributors.size());
        for (ThreddsMetadata.Contributor t : contributors) {
            HashMap<String, String> contribMap = new HashMap<String, String>();
            contribMap.put("role", t.getRole() == null ? "" : t.getRole());
            contribMap.put("name", t.getName());
            this.contributors.add(contribMap);
        }
    }

    private void setKeywords(Dataset ds) {
        List keywords = ds.getKeywords();
        this.keywords = new ArrayList<Map<String, String>>(keywords.size());
        for (ThreddsMetadata.Vocab t : keywords) {
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put("vocab", t.getVocabulary() == null ? "" : t.getVocabulary());
            keyMap.put("text", t.getText());
            this.keywords.add(keyMap);
        }
    }

    private void setDates(Dataset ds) {
        List dates = ds.getDates();
        this.dates = new ArrayList<Map<String, String>>(dates.size());
        for (DateType d : dates) {
            HashMap<String, String> dateMap = new HashMap<String, String>();
            dateMap.put("type", d.getType() == null ? "" : d.getType());
            dateMap.put("text", d.getText());
            this.dates.add(dateMap);
        }
    }

    private void setProjects(Dataset ds) {
        List projects = ds.getProjects();
        this.projects = new ArrayList<Map<String, String>>(projects.size());
        for (ThreddsMetadata.Vocab t : projects) {
            HashMap<String, String> projectMap = new HashMap<String, String>();
            projectMap.put("vocab", t.getVocabulary() == null ? "" : t.getVocabulary());
            projectMap.put("text", t.getText());
            this.projects.add(projectMap);
        }
    }

    private void setCreators(Dataset ds, boolean isLocalCatalog) {
        List creators = ds.getCreators();
        this.creators = new ArrayList<Map<String, String>>(creators.size());
        for (ThreddsMetadata.Source t : creators) {
            HashMap<String, String> creatorMap = new HashMap<String, String>();
            creatorMap.put("name", t.getName());
            creatorMap.put("email", t.getEmail());
            String href = t.getUrl();
            if (!isLocalCatalog) {
                href = CatalogViewContextParser.makeHrefResolve(ds, href);
            }
            creatorMap.put("href", href);
            this.creators.add(creatorMap);
        }
    }

    private void setPublishers(Dataset ds, boolean isLocalCatalog) {
        this.publishers = new ArrayList<Map<String, String>>();
        List publishers = ds.getPublishers();
        for (ThreddsMetadata.Source t : publishers) {
            HashMap<String, String> pubMap = new HashMap<String, String>();
            pubMap.put("name", t.getName());
            pubMap.put("email", t.getEmail());
            String href = t.getUrl();
            if (!isLocalCatalog) {
                href = CatalogViewContextParser.makeHrefResolve(ds, href);
            }
            pubMap.put("href", href);
            this.publishers.add(pubMap);
        }
    }

    private void setVariables(Dataset ds, boolean isLocalCatalog) {
        List vars = ds.getVariables();
        this.variables = new ArrayList<Map<String, Object>>(vars.size());
        for (ThreddsMetadata.VariableGroup t : vars) {
            HashMap<String, Object> varGroup = new HashMap<String, Object>();
            String vocab = t.getVocabulary();
            varGroup.put("title", vocab);
            ThreddsMetadata.UriResolved vocabUri = t.getVocabUri();
            if (vocabUri != null) {
                varGroup.put("href", isLocalCatalog ? vocabUri.href : vocabUri.resolved.toString());
            }
            ArrayList varList = new ArrayList();
            List vlist = t.getVariableList();
            for (ThreddsMetadata.Variable v : vlist) {
                HashMap<String, String> var = new HashMap<String, String>();
                String units = v.getUnits() == null || v.getUnits().length() == 0 ? "" : " (" + v.getUnits() + ") ";
                var.put("nameAndUnits", v.getName() + units);
                var.put("description", v.getDescription());
                var.put("vocabularyName", v.getVocabularyName());
                varList.add(var);
            }
            varGroup.put("varList", varList);
            this.variables.add(varGroup);
        }
        ThreddsMetadata.UriResolved uri = ds.getVariableMapLink();
        if (uri != null) {
            this.variableMapLink = uri.resolved.toASCIIString();
        }
    }

    private void setGeospatialCoverage(Dataset ds) {
        ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
        this.geospatialCoverage = new HashMap<String, Object>();
        if (gc != null) {
            this.geospatialCoverage.put("eastWestRange", this.rangeString(gc.getEastWestRange()));
            this.geospatialCoverage.put("northSouthRange", this.rangeString(gc.getNorthSouthRange()));
            ThreddsMetadata.GeospatialRange r = gc.getUpDownRange();
            if (r != null && r.getSize() > 0.0) {
                this.geospatialCoverage.put("upDownRange", this.rangeString(r));
                this.geospatialCoverage.put("zPositive", gc.getZPositive());
            }
            ArrayList<String> names = new ArrayList<String>();
            List nlist = gc.getNames();
            if (nlist != null) {
                for (ThreddsMetadata.Vocab elem : nlist) {
                    names.add(elem.getText());
                }
            }
            this.geospatialCoverage.put("names", names);
        }
    }

    private void setTimeCoverage(Dataset ds) {
        DateRange tc = ds.getTimeCoverage();
        this.timeCoverage = new HashMap<String, Object>();
        if (tc != null) {
            TimeDuration resolution;
            TimeDuration duration;
            DateType end;
            DateType start = tc.getStart();
            if (start != null) {
                this.timeCoverage.put("start", start.toString());
            }
            if ((end = tc.getEnd()) != null) {
                this.timeCoverage.put("end", end.toString());
            }
            if ((duration = tc.getDuration()) != null) {
                this.timeCoverage.put("duration", duration.toString());
            }
            if ((resolution = tc.getResolution()) != null) {
                this.timeCoverage.put("resolution", resolution.toString());
            }
        }
    }

    private void setMetadata(Dataset ds, boolean isLocalCatalog) {
        List metadata = ds.getMetadataOther();
        this.metadata = new ArrayList<Map<String, String>>(metadata.size());
        for (ThreddsMetadata.MetadataOther m : metadata) {
            HashMap<String, String> metadataMap = new HashMap<String, String>();
            if (m.getXlinkHref() == null) continue;
            String type = m.getType() == null ? "" : m.getType();
            metadataMap.put("title", m.getTitle() == null ? "Type " + type : m.getTitle());
            String mdLink = m.getXlinkHref();
            if (!isLocalCatalog) {
                mdLink = CatalogViewContextParser.makeHrefResolve(ds, mdLink);
            }
            metadataMap.put("href", mdLink);
        }
    }

    private void setProperties(Dataset ds, boolean isLocalCatalog) {
        List propsOrg = ds.getProperties();
        ArrayList<Property> props = new ArrayList<Property>(ds.getProperties().size());
        for (Property p : propsOrg) {
            if (p.getName().startsWith("viewer")) continue;
            props.add(p);
        }
        this.properties = new ArrayList<Map<String, String>>(props.size());
        for (Property p : props) {
            HashMap<String, String> propsMap = new HashMap<String, String>();
            if (p.getName().equals("attachments")) {
                propsMap.put("href", !isLocalCatalog ? CatalogViewContextParser.makeHrefResolve(ds, p.getValue()) : p.getValue());
            }
            propsMap.put("name", p.getName());
            propsMap.put("value", p.getValue());
            this.properties.add(propsMap);
        }
    }

    private String rangeString(ThreddsMetadata.GeospatialRange r) {
        if (r == null) {
            return "";
        }
        String units = r.getUnits() == null ? "" : " " + r.getUnits();
        String resolution = r.hasResolution() ? " Resolution=" + r.getResolution() : "";
        return r.getStart() + " to " + (r.getStart() + r.getSize()) + resolution + units;
    }

    private String makeHrefResolve(Dataset ds, String href) {
        Catalog cat = ds.getParentCatalog();
        if (cat != null) {
            try {
                URI uri = cat.resolveUri(href);
                href = uri.toString();
            }
            catch (URISyntaxException e) {
                return "CatalogViewContextParser: error parsing URL= " + href;
            }
        }
        return href;
    }

    public String getName() {
        return this.name;
    }

    public String getCatUrl() {
        return this.catUrl;
    }

    public String getCatName() {
        return this.catName;
    }

    public List<Map<String, String>> getDocumentation() {
        return this.documentation;
    }

    public List<Map<String, String>> getAccess() {
        return this.access;
    }

    public List<Map<String, String>> getContributors() {
        return this.contributors;
    }

    public List<Map<String, String>> getKeywords() {
        return this.keywords;
    }

    public List<Map<String, String>> getDates() {
        return this.dates;
    }

    public List<Map<String, String>> getProjects() {
        return this.projects;
    }

    public List<Map<String, String>> getCreators() {
        return this.creators;
    }

    public List<Map<String, String>> getPublishers() {
        return this.publishers;
    }

    public List<Map<String, Object>> getVariables() {
        return this.variables;
    }

    public String getVariableMapLink() {
        return this.variableMapLink;
    }

    public Map<String, Object> getGeospatialCoverage() {
        return this.geospatialCoverage;
    }

    public Map<String, Object> getTimeCoverage() {
        return this.timeCoverage;
    }

    public List<Map<String, String>> getMetadata() {
        return this.metadata;
    }

    public List<Map<String, String>> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getAllContext() {
        return this.context;
    }

    public Object getContextItem(String key) {
        return this.context.get(key);
    }

    protected void addContextItem(String key, Object value) {
        this.context.put(key, value);
    }

    public List<Map<String, String>> getViewerLinks() {
        return this.viewerLinks;
    }

    protected void setViewers(Dataset ds, List<ViewerLinkProvider.ViewerLink> viewerLinks) {
        for (ViewerLinkProvider.ViewerLink viewer : viewerLinks) {
            HashMap<String, String> viewerMap = new HashMap<String, String>();
            viewerMap.put("title", viewer.getTitle());
            viewerMap.put("href", viewer.getUrl());
            this.viewerLinks.add(viewerMap);
        }
    }
}

