/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import thredds.client.catalog.Service;
import thredds.client.catalog.tools.CatalogXmlWriter;
import thredds.client.catalog.tools.DataFactory;
import thredds.core.AllowedServices;
import thredds.core.ConfigCatalogInitialization;
import thredds.core.DatasetManager;
import thredds.core.StandardService;
import thredds.featurecollection.CollectionUpdater;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.server.catalog.AllowedServicesIF;
import thredds.server.catalog.ConfigCatalogCache;
import thredds.server.catalog.DatasetScan;
import thredds.server.config.TdsConfigMapper;
import thredds.server.config.TdsContext;
import thredds.server.config.TdsUpdateConfigBean;
import thredds.server.config.ThreddsConfig;
import thredds.server.ncss.controller.NcssDiskCache;
import thredds.server.ncss.format.FormatsAvailabilityService;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.notebook.JupyterNotebookServiceCache;
import ucar.nc2.FileWriter2;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.ft.point.standard.PointDatasetStandardFactory;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.Grib;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DebugFlagsImpl;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;

@Component
public class TdsInit
implements ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private static final Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private static final Logger logCatalogInit = LoggerFactory.getLogger((String)"catalogInit");
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    TdsConfigMapper tdsConfigMapper;
    @Autowired
    private TdsUpdateConfigBean tdsUpdateConfig;
    @Autowired
    private DatasetManager datasetManager;
    @Autowired
    private ConfigCatalogCache ccc;
    @Autowired
    private ConfigCatalogInitialization configCatalogInitializer;
    @Autowired
    CollectionUpdater collectionUpdater;
    @Autowired
    @Qualifier(value="fcTriggerExecutor")
    private ExecutorService executor;
    @Autowired
    private AllowedServices allowedServices;
    @Autowired
    private JupyterNotebookServiceCache jupyterNotebooks;
    @Autowired
    private NcssDiskCache ncssDiskCache;
    private Timer cdmDiskCacheTimer;
    private boolean wasInitialized;
    private XMLStore store;
    private PreferencesExt mainPrefs;
    private boolean useBuilders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextRefreshedEvent event) {
        String awsRegion = System.getProperty("aws.region");
        if (awsRegion == null) {
            System.setProperty("aws.region", "us-east-1");
        }
        if (event != null) {
            TdsInit tdsInit = this;
            synchronized (tdsInit) {
                if (!this.wasInitialized) {
                    this.wasInitialized = true;
                    startupLog.info("TdsInit: {}", (Object)event);
                    startupLog.info("TdsInit: getContentRootPathAbsolute= " + this.tdsContext.getContentRootPathProperty());
                    String tdsDebugFlags = this.tdsContext.getTdsDebugFlags();
                    if (!tdsDebugFlags.isEmpty()) {
                        startupLog.info(String.format("Setting the following debug flags: %s", tdsDebugFlags));
                        this.setDebugFlags((DebugFlags)new DebugFlagsImpl(tdsDebugFlags));
                    }
                    this.readState();
                    this.initThreddsConfig();
                    this.readThreddsConfig();
                    this.logVersionMessage();
                    startupLog.warn("Web Start has been deprecated for >Java 9 and is slated for removal - see http://www.oracle.com/technetwork/java/eol-135779.html)");
                    String readModeS = ThreddsConfig.get("ConfigCatalog.reread", "always");
                    ConfigCatalogInitialization.ReadMode readMode = ConfigCatalogInitialization.ReadMode.get(readModeS);
                    if (readMode == null) {
                        readMode = ConfigCatalogInitialization.ReadMode.always;
                    }
                    this.configCatalogInitializer.init(readMode, (PreferencesExt)this.mainPrefs.node("configCatalog"));
                    startupLog.info("TdsInit complete");
                }
            }
        }
    }

    private void setDebugFlags(DebugFlags debugFlags) {
        NetcdfFile.setDebugFlags((DebugFlags)debugFlags);
        H5iosp.setDebugFlags((DebugFlags)debugFlags);
        NcMLReader.setDebugFlags((DebugFlags)debugFlags);
        DODSNetcdfFile.setDebugFlags((DebugFlags)debugFlags);
        CdmRemote.setDebugFlags((DebugFlags)debugFlags);
        Nc4Iosp.setDebugFlags((DebugFlags)debugFlags);
        DataFactory.setDebugFlags((DebugFlags)debugFlags);
        FileWriter2.setDebugFlags((DebugFlags)debugFlags);
        PointDatasetStandardFactory.setDebugFlags((DebugFlags)debugFlags);
        Grib.setDebugFlags((DebugFlags)debugFlags);
    }

    private void readState() {
        File prefsDir = new File(this.tdsContext.getThreddsDirectory(), "/state/");
        if (!prefsDir.exists()) {
            boolean ok = prefsDir.mkdirs();
            startupLog.info("TdsInit: makeDir= " + prefsDir.getAbsolutePath() + " ok=" + ok);
        }
        File prefsFile = new File(prefsDir, "prefs.xml");
        try {
            this.store = XMLStore.createFromFile(prefsFile.getAbsolutePath(), null);
            this.mainPrefs = this.store.getPreferences();
        }
        catch (IOException e) {
            startupLog.error("TdsInit: failed to get prefs file= " + prefsDir.getAbsolutePath(), (Throwable)e);
        }
    }

    private void initThreddsConfig() {
        File tdsConfigFile = new File(this.tdsContext.getThreddsDirectory(), this.tdsContext.getConfigFileProperty());
        if (!tdsConfigFile.exists()) {
            startupLog.warn("TdsInit: TDS configuration file '{}' doesn't exist, using all defaults ", (Object)tdsConfigFile.getAbsolutePath());
            return;
        }
        ThreddsConfig.init(tdsConfigFile.getPath());
    }

    private void logVersionMessage() {
        Map<String, String> latestVersionInfo;
        String version = this.tdsContext.getVersionInfo();
        String message = "You are currently running TDS version " + version;
        logCatalogInit.info(message);
        if (this.tdsUpdateConfig.isLogVersionInfo() && !(latestVersionInfo = this.tdsUpdateConfig.getLatestVersionInfo(version)).isEmpty()) {
            logCatalogInit.info("Latest Available TDS Version Info:");
            for (Map.Entry<String, String> entry : latestVersionInfo.entrySet()) {
                message = "latest " + entry.getKey() + " version = " + entry.getValue();
                startupLog.info("TdsInit: " + message);
                logCatalogInit.info("    " + message);
            }
            logCatalogInit.info("");
        }
    }

    private void readThreddsConfig() {
        int jvmPercent;
        long maxSizeBytes;
        Boolean useForReading;
        this.tdsConfigMapper.init(this.tdsContext);
        this.useBuilders = ThreddsConfig.getBoolean("Experimental.useNetcdfJavaBuilders", false);
        if (!this.useBuilders) {
            this.useBuilders = Boolean.getBoolean("thredds.test.experimental.useNetcdfJavaBuilders");
        }
        this.datasetManager.setUseNetcdfJavaBuilders(this.useBuilders);
        DataFactory.setPreferCdm((boolean)true);
        NetcdfFile.setProperty((String)"syncExtendOnly", (String)"true");
        boolean useBytesForDataSize = ThreddsConfig.getBoolean("catalogWriting.useBytesForDataSize", false);
        CatalogXmlWriter.useBytesForDataSize((boolean)useBytesForDataSize);
        startupLog.info("TdsInit: catalogWriting.useBytesForDataSize= " + useBytesForDataSize);
        ThreddsConfig.getRootList("datasetSource").forEach(this.datasetManager::registerDatasetSource);
        this.allowedServices.setAllowService(StandardService.catalogRemote, ThreddsConfig.getBoolean("CatalogServices.allowRemote"));
        this.allowedServices.setAllowService(StandardService.wcs, ThreddsConfig.getBoolean("WCS.allow"));
        this.allowedServices.setAllowService(StandardService.wms, ThreddsConfig.getBoolean("WMS.allow"));
        this.allowedServices.setAllowService(StandardService.netcdfSubsetGrid, ThreddsConfig.getBoolean("NetcdfSubsetService.allow"));
        this.allowedServices.setAllowService(StandardService.netcdfSubsetPoint, ThreddsConfig.getBoolean("NetcdfSubsetService.allow"));
        this.allowedServices.setAllowService(StandardService.iso_ncml, ThreddsConfig.getBoolean("NCISO.ncmlAllow"));
        this.allowedServices.setAllowService(StandardService.uddc, ThreddsConfig.getBoolean("NCISO.uddcAllow"));
        this.allowedServices.setAllowService(StandardService.iso, ThreddsConfig.getBoolean("NCISO.isoAllow"));
        this.allowedServices.setAllowService(StandardService.jupyterNotebook, ThreddsConfig.getBoolean("JupyterNotebookService.allow"));
        this.allowedServices.finish();
        InvDatasetFeatureCollection.setAllowedServices(this.allowedServices);
        InvDatasetFeatureCollection.setUseNetcdfJavaBuilders(this.useBuilders);
        DatasetScan.setSpecialServices((Service)this.allowedServices.getStandardService(StandardService.resolver), (Service)this.allowedServices.getStandardService(StandardService.httpServer));
        DatasetScan.setAllowedServices((AllowedServicesIF)this.allowedServices);
        this.allowedServices.makeDebugActions();
        String libraryPath = ThreddsConfig.get("Netcdf4Clibrary.libraryPath", null);
        String libraryName = ThreddsConfig.get("Netcdf4Clibrary.libraryName", null);
        if (libraryPath != null || libraryName != null) {
            Nc4Iosp.setLibraryAndPath((String)libraryPath, (String)libraryName);
        }
        if ((useForReading = Boolean.valueOf(ThreddsConfig.getBoolean("Netcdf4Clibrary.useForReading", false))).booleanValue()) {
            if (Nc4Iosp.isClibraryPresent()) {
                try {
                    NetcdfFile.registerIOProvider(Nc4Iosp.class);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    startupLog.error("TdsInit: Unable to register IOSP: " + Nc4Iosp.class.getCanonicalName(), (Throwable)e);
                }
            } else {
                startupLog.warn("TdsInit: In threddsConfig.xml, 'Netcdf4Clibrary.useForReading' is 'true' but the native C library couldn't be found on the system. Falling back to the pure-Java reader.");
            }
        }
        if (Nc4Iosp.isClibraryPresent()) {
            FormatsAvailabilityService.setFormatAvailability(SupportedFormat.NETCDF4, true);
        }
        String typicalDataset = ThreddsConfig.get("Aggregation.typicalDataset", "penultimate");
        Aggregation.setTypicalDatasetMode((String)typicalDataset);
        startupLog.info("TdsInit: Aggregation.setTypicalDatasetMode= " + typicalDataset);
        String dir = ThreddsConfig.get("DiskCache.dir", new File(this.tdsContext.getThreddsDirectory(), "/cache/cdm/").getPath());
        boolean alwaysUse = ThreddsConfig.getBoolean("DiskCache.alwaysUse", false);
        int scourSecs = ThreddsConfig.getSeconds("DiskCache.scour", 3600);
        long maxSize = ThreddsConfig.getBytes("DiskCache.maxSize", 1000000000L);
        DiskCache.setRootDirectory((String)dir);
        DiskCache.setCachePolicy((boolean)alwaysUse);
        startupLog.info("TdsInit: CdmCache= " + dir + " scour = " + scourSecs + " maxSize = " + maxSize);
        if (scourSecs > 0) {
            Calendar c = Calendar.getInstance();
            c.add(13, scourSecs / 2);
            this.cdmDiskCacheTimer = new Timer("CdmDiskCache");
            this.cdmDiskCacheTimer.scheduleAtFixedRate((TimerTask)new CacheScourTask(maxSize), c.getTime(), 1000L * (long)scourSecs);
        }
        dir = ThreddsConfig.get("AggregationCache.dir", new File(this.tdsContext.getThreddsDirectory().getPath(), "/cache/agg/").getPath());
        scourSecs = ThreddsConfig.getSeconds("AggregationCache.scour", 86400);
        int maxAgeSecs = ThreddsConfig.getSeconds("AggregationCache.maxAge", 7776000);
        DiskCache2 aggCache = new DiskCache2(dir, false, maxAgeSecs / 60, scourSecs / 60);
        String cachePathPolicy = ThreddsConfig.get("AggregationCache.cachePathPolicy", null);
        aggCache.setPolicy(cachePathPolicy);
        Aggregation.setPersistenceCache((DiskCache2)aggCache);
        startupLog.info("TdsInit: AggregationCache= " + dir + " scour = " + scourSecs + " maxAgeSecs = " + maxAgeSecs);
        String gribIndexDir = ThreddsConfig.get("GribIndex.dir", new File(this.tdsContext.getThreddsDirectory(), "/cache/grib/").getPath());
        Boolean gribIndexAlwaysUse = ThreddsConfig.getBoolean("GribIndex.alwaysUse", false);
        Boolean gribIndexNeverUse = ThreddsConfig.getBoolean("GribIndex.neverUse", false);
        String gribIndexPolicy = ThreddsConfig.get("GribIndex.policy", null);
        int gribIndexScourSecs = ThreddsConfig.getSeconds("GribIndex.scour", 0);
        int gribIndexMaxAgeSecs = ThreddsConfig.getSeconds("GribIndex.maxAge", 7776000);
        DiskCache2 gribCache = new DiskCache2(gribIndexDir, false, gribIndexMaxAgeSecs / 60, gribIndexScourSecs / 60);
        gribCache.setPolicy(gribIndexPolicy);
        gribCache.setAlwaysUseCache(gribIndexAlwaysUse.booleanValue());
        gribCache.setNeverUseCache(gribIndexNeverUse.booleanValue());
        GribIndexCache.setDiskCache2((DiskCache2)gribCache);
        startupLog.info("TdsInit: GribIndex=" + gribCache);
        this.ncssDiskCache.init();
        String fcCache = ThreddsConfig.get("FeatureCollectionCache.dir", null);
        if (fcCache == null) {
            fcCache = ThreddsConfig.get("FeatureCollection.dir", null);
        }
        if (fcCache == null) {
            fcCache = ThreddsConfig.get("FeatureCollection.cacheDirectory", this.tdsContext.getThreddsDirectory().getPath() + "/cache/collection/");
        }
        if ((maxSizeBytes = ThreddsConfig.getBytes("FeatureCollectionCache.maxSize", -1L)) == -1L) {
            maxSizeBytes = ThreddsConfig.getBytes("FeatureCollection.maxSize", 0L);
        }
        if (-1 == (jvmPercent = ThreddsConfig.getInt("FeatureCollectionCache.jvmPercent", -1))) {
            jvmPercent = ThreddsConfig.getInt("FeatureCollection.jvmPercent", 2);
        }
        int min = ThreddsConfig.getInt("RandomAccessFile.minFiles", 400);
        int max = ThreddsConfig.getInt("RandomAccessFile.maxFiles", 500);
        int secs = ThreddsConfig.getSeconds("RandomAccessFile.scour", 660);
        if (max > 0) {
            RandomAccessFile.setGlobalFileCache((FileCacheIF)new FileCache("RandomAccessFile", min, max, -1, secs));
            startupLog.info("TdsInit: RandomAccessFile.initPartitionCache= [" + min + "," + max + "] scour = " + secs);
        }
        min = ThreddsConfig.getInt("NetcdfFileCache.minFiles", 100);
        max = ThreddsConfig.getInt("NetcdfFileCache.maxFiles", 150);
        secs = ThreddsConfig.getSeconds("NetcdfFileCache.scour", 720);
        if (max > 0) {
            NetcdfDatasets.initNetcdfFileCache((int)min, (int)max, (int)secs);
            startupLog.info("TdsInit: NetcdfDatasets.initNetcdfFileCache= [" + min + "," + max + "] scour = " + secs);
            NetcdfDataset.initNetcdfFileCache((int)min, (int)max, (int)secs);
            startupLog.info("TdsInit: NetcdfDataset.initNetcdfFileCache= [" + min + "," + max + "] scour = " + secs);
        }
        min = ThreddsConfig.getInt("TimePartition.minFiles", 100);
        max = ThreddsConfig.getInt("TimePartition.maxFiles", 150);
        secs = ThreddsConfig.getSeconds("TimePartition.scour", 780);
        if (max > 0) {
            GribCdmIndex.initDefaultCollectionCache((int)min, (int)max, (int)secs);
            startupLog.info("TdsInit: GribCdmIndex.initDefaultCollectionCache= [" + min + "," + max + "] scour = " + secs);
        }
        max = ThreddsConfig.getInt("ConfigCatalog.keepInMemory", 100);
        String rootPath = this.tdsContext.getContentRootPathProperty() + "thredds/";
        this.ccc.init(rootPath, max);
        String trackerDir = ThreddsConfig.get("ConfigCatalog.dir", new File(this.tdsContext.getThreddsDirectory().getPath(), "/cache/catalog/").getPath());
        int trackerMax = ThreddsConfig.getInt("ConfigCatalog.maxDatasets", 10000);
        File trackerDirFile = new File(trackerDir);
        if (!trackerDirFile.exists()) {
            boolean ok = trackerDirFile.mkdirs();
            startupLog.info("TdsInit: tracker directory {} make ok = {}", (Object)trackerDir, (Object)ok);
        }
        this.configCatalogInitializer.setTrackerDir(trackerDir);
        this.configCatalogInitializer.setMaxDatasetToTrack(trackerMax);
        if (this.allowedServices.isAllowed(StandardService.jupyterNotebook)) {
            max = ThreddsConfig.getInt("JupyterNotebookService.maxFiles", 100);
            secs = ThreddsConfig.getSeconds("JupyterNotebookService.maxAge", 3600);
            this.jupyterNotebooks.init(max, secs);
        }
    }

    public void destroy() {
        System.out.printf("TdsInit.destroy() is called%n", new Object[0]);
        try {
            this.store.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            startupLog.error("TdsInit: Prefs save failed", (Throwable)ioe);
        }
        if (this.cdmDiskCacheTimer != null) {
            this.cdmDiskCacheTimer.cancel();
        }
        FileCache.shutdown();
        DiskCache2.exit();
        this.executor.shutdownNow();
        RandomAccessFile.shutdown();
        NetcdfDataset.shutdown();
        NetcdfDatasets.shutdown();
        GribCdmIndex.shutdown();
        this.datasetManager.setDatasetTracker(null);
        this.collectionUpdater.shutdown();
        startupLog.info("TdsInit shutdown");
        MDC.clear();
    }

    private static class CacheScourTask
    extends TimerTask {
        long maxBytes;

        CacheScourTask(long maxBytes) {
            this.maxBytes = maxBytes;
        }

        @Override
        public void run() {
            StringBuilder sbuff = new StringBuilder();
            DiskCache.cleanCache((long)this.maxBytes, (StringBuilder)sbuff);
            sbuff.append("----------------------\n");
        }
    }
}

