/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.reify;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import thredds.server.reify.LoadCommon;
import ucar.httpservices.HTTPUtil;

class Parameters {
    public HttpServletRequest req;
    Map<String, String[]> params;
    public Map<String, String> testinfo = new HashMap<String, String>();
    public LoadCommon.Command command = null;

    public Parameters(HttpServletRequest req) throws IOException {
        assert (req != null);
        this.req = req;
        this.params = new HashMap<String, String[]>();
        if (req.getParameterMap() == null) {
            this.command = LoadCommon.Command.NONE;
        } else {
            this.params.putAll(req.getParameterMap());
            String s = this.getparam("testinfo");
            if (s != null) {
                this.testinfo = LoadCommon.parseMap(s, ';', true);
            }
            if ((s = this.getparam("request")) == null) {
                this.command = LoadCommon.Command.NONE;
            } else {
                this.command = LoadCommon.Command.parse(s);
                if (this.command == null) {
                    throw new IOException("Unknown request: " + s);
                }
            }
        }
    }

    protected String[] getparamset(String key) throws IOException {
        String[] values = this.params.get(key);
        return values == null ? new String[]{} : values;
    }

    public String getparam(String key) throws IOException {
        String[] values = this.getparamset(key);
        if (values.length == 0) {
            return null;
        }
        String value = URLDecoder.decode(values[0], "UTF-8");
        value = HTTPUtil.nullify((String)value);
        return value;
    }
}

