/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.server.viewer.Viewer;
import thredds.server.viewer.ViewerLinkProvider;

public class Godiva3Viewer
implements Viewer {
    private static final Logger logger = LoggerFactory.getLogger(Godiva3Viewer.class);
    private static final String title = "Godiva3 (browser-based)";

    @Override
    public boolean isViewable(Dataset ds) {
        Access access = ds.getAccess(ServiceType.WMS);
        return access != null;
    }

    @Override
    public String getViewerLinkHtml(Dataset ds, HttpServletRequest req) {
        ViewerLinkProvider.ViewerLink viewerLink = this.getViewerLink(ds, req);
        return "<a href='" + viewerLink.getUrl() + "'>" + viewerLink.getTitle() + "</a>";
    }

    @Override
    public ViewerLinkProvider.ViewerLink getViewerLink(Dataset ds, HttpServletRequest req) {
        Access access = ds.getAccess(ServiceType.WMS);
        if (access == null) {
            return null;
        }
        URI dataURI = access.getStandardUri();
        if (dataURI == null) {
            logger.warn("Godiva3Viewer access URL failed on {}", (Object)ds.getName());
            return null;
        }
        try {
            URI base = new URI(req.getRequestURL().toString());
            dataURI = base.resolve(dataURI);
        }
        catch (URISyntaxException e) {
            logger.warn("Godiva3Viewer URL=" + req.getRequestURL().toString(), (Throwable)e);
            return null;
        }
        String url = req.getContextPath() + "/Godiva.html?server=" + dataURI.toString();
        return new ViewerLinkProvider.ViewerLink(title, url);
    }
}

