/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.core.TdsRequestedDataset;
import thredds.server.wms.ThreddsWmsCatalogue;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import uk.ac.rdg.resc.edal.graphics.exceptions.EdalLayerNotFoundException;
import uk.ac.rdg.resc.edal.wms.RequestParams;
import uk.ac.rdg.resc.edal.wms.WmsCatalogue;
import uk.ac.rdg.resc.edal.wms.WmsServlet;

public class ThreddsWmsServlet
extends WmsServlet {
    private Map<String, WmsCatalogue> catalogueCache = new HashMap<String, WmsCatalogue>();

    protected void dispatchWmsRequest(String request, RequestParams params, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WmsCatalogue catalogue) throws Exception {
        String removePrefix = null;
        TdsRequestedDataset tdsDataset = new TdsRequestedDataset(httpServletRequest, removePrefix);
        if (this.catalogueCache.containsKey(tdsDataset.getPath())) {
            catalogue = this.catalogueCache.get(tdsDataset.getPath());
        } else {
            NetcdfFile ncf = TdsRequestedDataset.getNetcdfFile(httpServletRequest, httpServletResponse, tdsDataset.getPath());
            NetcdfDataset ncd = tdsDataset.useNetcdfJavaBuilders() ? NetcdfDatasets.enhance((NetcdfFile)ncf, (Set)NetcdfDataset.getDefaultEnhanceMode(), null) : NetcdfDataset.wrap((NetcdfFile)ncf, (Set)NetcdfDataset.getDefaultEnhanceMode());
            String netcdfFilePath = ncf.getLocation();
            if (netcdfFilePath == null) {
                throw new EdalLayerNotFoundException("The requested dataset is not available on this server");
            }
            catalogue = new ThreddsWmsCatalogue(ncd, tdsDataset.getPath());
            this.catalogueCache.put(tdsDataset.getPath(), catalogue);
        }
        super.dispatchWmsRequest(request, params, httpServletRequest, httpServletResponse, catalogue);
    }
}

