/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CookieFilter
implements Filter {
    public static final String JSESSIONID = "JSESSIONID";
    public static final String SESSION_PATH = "SESSION_PATH";

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest _request, ServletResponse _response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(_request, _response);
        if (_response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)_request;
            HttpServletResponse httpResponse = (HttpServletResponse)_response;
            HttpSession session = httpRequest.getSession(false);
            if (session != null && session.getId() != null && session.getAttribute(SESSION_PATH) != null) {
                Cookie sessionCookie = new Cookie(JSESSIONID, session.getId());
                sessionCookie.setPath((String)session.getAttribute(SESSION_PATH));
                httpResponse.addCookie(sessionCookie);
            }
        }
    }

    public void destroy() {
    }
}

