/*
 * Decompiled with CFR 0.152.
 */
package thredds.util.filesource;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.List;
import thredds.util.filesource.DescendantFileSource;
import thredds.util.filesource.FileSource;

public class ChainedFileSource
implements FileSource {
    private final List<DescendantFileSource> chain;

    public ChainedFileSource(List<DescendantFileSource> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new IllegalArgumentException("Locator chain must not be null or empty.");
        }
        for (DescendantFileSource dfs : chain) {
            if (dfs != null) continue;
            throw new IllegalArgumentException("Locator chain must not contain null items.");
        }
        this.chain = chain;
    }

    @Override
    public File getFile(String path) {
        for (DescendantFileSource curLocator : this.chain) {
            File file = curLocator.getFile(path);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("chain", this.chain).toString();
    }
}

