/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import com.coverity.security.Escape;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.tools.DatasetHtmlWriter;
import thredds.server.catalog.CatalogScan;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.config.HtmlConfigBean;
import thredds.server.config.TdsContext;
import thredds.server.viewer.ViewerService;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import ucar.nc2.units.DateType;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil2;

@Component
public class ConfigCatalogHtmlWriter {
    private static Logger log = LoggerFactory.getLogger(ConfigCatalogHtmlWriter.class);
    @Autowired
    private ViewerService viewerService;
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private HtmlConfigBean htmlConfig;

    public static String getHtmlDoctypeAndOpenTag() {
        return "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n        'http://www.w3.org/TR/html4/loose.dtd'>\n<html>\n";
    }

    public static String getXHtmlDoctypeAndOpenTag() {
        return "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN'\n        'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>\n<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>";
    }

    public int writeCatalog(HttpServletRequest req, HttpServletResponse res, Catalog cat, boolean isLocalCatalog) throws IOException {
        String catHtmlAsString = this.convertCatalogToHtml(cat, isLocalCatalog);
        res.setContentType(ContentType.html.getContentHeader());
        int len = ServletUtil.setResponseContentLength(res, catHtmlAsString);
        if (!req.getMethod().equals("HEAD")) {
            PrintWriter writer = res.getWriter();
            writer.write(catHtmlAsString);
            writer.flush();
        }
        return len;
    }

    String convertCatalogToHtml(Catalog cat, boolean isLocalCatalog) {
        StringBuilder sb = new StringBuilder(10000);
        String uri = cat.getUriString();
        if (uri == null) {
            uri = cat.getName();
        }
        if (uri == null) {
            uri = "unknown";
        }
        String catname = Escape.html((String)uri);
        sb.append(ConfigCatalogHtmlWriter.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>");
        sb.append("<title>");
        sb.append("Catalog ").append(catname);
        sb.append("</title>\r\n");
        sb.append(this.getTdsCatalogCssLink()).append("\n");
        sb.append(this.getGoogleTrackingContent());
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        String logoUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallLogoUrl());
        if (logoUrl != null) {
            sb.append("<img src='").append(logoUrl);
            String logoAlt = this.htmlConfig.getInstallLogoAlt();
            if (logoAlt != null) {
                sb.append("' alt='").append(logoAlt);
            }
            sb.append("' align='left' valign='top'").append(">\n");
        }
        sb.append(" Catalog ").append(catname);
        sb.append("</h1>");
        sb.append("<HR size='1' noshade='noshade'>");
        sb.append("<table width='100%' cellspacing='0' cellpadding='5' align='center'>\r\n");
        sb.append("<tr>\r\n");
        sb.append("<th align='left'><font size='+1'>");
        sb.append("Dataset");
        sb.append("</font></th>\r\n");
        sb.append("<th align='center'><font size='+1'>");
        sb.append("Size");
        sb.append("</font></th>\r\n");
        sb.append("<th align='right'><font size='+1'>");
        sb.append("Last Modified");
        sb.append("</font></th>\r\n");
        sb.append("</tr>");
        this.doDatasets(cat, cat.getDatasetsLocal(), sb, false, 0, isLocalCatalog);
        sb.append("</table>\r\n");
        sb.append("<HR size='1' noshade='noshade'>");
        this.appendSimpleFooter(sb);
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private boolean doDatasets(Catalog cat, List<Dataset> datasets, StringBuilder sb, boolean shade, int level, boolean isLocalCatalog) {
        Object catHtml;
        if (!isLocalCatalog) {
            catHtml = this.tdsContext.getContextPath() + "/remoteCatalogService?command=subset&catalog=" + cat.getUriString() + "&";
        } else {
            int pos;
            URI catURI = cat.getBaseURI();
            catHtml = catURI.getPath();
            if (catHtml == null) {
                catHtml = cat.getUriString();
            }
            if ((pos = ((String)catHtml).lastIndexOf("/")) != -1) {
                catHtml = ((String)catHtml).substring(pos + 1);
            }
            catHtml = (pos = ((String)catHtml).lastIndexOf(46)) < 0 ? (String)catHtml + "catalog.html?" : ((String)catHtml).substring(0, pos) + ".html?";
        }
        for (Dataset ds : datasets) {
            String name = ds.getName();
            name = name == null ? "" : Escape.html((String)ds.getName());
            sb.append("<tr");
            if (shade) {
                sb.append(" bgcolor='#eeeeee'");
            }
            sb.append(">\r\n");
            shade = !shade;
            sb.append("<td align='left'>");
            for (int j = 0; j <= level; ++j) {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            sb.append("\r\n");
            if (ds instanceof CatalogRef) {
                CatalogRef catref = (CatalogRef)ds;
                Object href = catref.getXlinkHref();
                if (!isLocalCatalog) {
                    URI hrefUri = cat.getBaseURI().resolve((String)href);
                    href = hrefUri.toString();
                }
                try {
                    URI uri = new URI((String)href);
                    if (uri.isAbsolute()) {
                        boolean defaultUseRemoteCatalogService = this.htmlConfig.getUseRemoteCatalogService();
                        Boolean dsUseRemoteCatalogSerivce = ((CatalogRef)ds).useRemoteCatalogService();
                        boolean useRemoteCatalogService = defaultUseRemoteCatalogService;
                        if (dsUseRemoteCatalogSerivce == null) {
                            dsUseRemoteCatalogSerivce = defaultUseRemoteCatalogService;
                        }
                        if (defaultUseRemoteCatalogService != dsUseRemoteCatalogSerivce) {
                            useRemoteCatalogService = dsUseRemoteCatalogSerivce;
                        }
                        if (useRemoteCatalogService) {
                            href = this.tdsContext.getContextPath() + "/remoteCatalogService?catalog=" + (String)href;
                        } else {
                            int pos = ((String)href).lastIndexOf(46);
                            href = ((String)href).substring(0, pos) + ".html";
                        }
                    } else {
                        int pos = ((String)href).lastIndexOf(46);
                        href = ((String)href).substring(0, pos) + ".html";
                    }
                }
                catch (URISyntaxException e) {
                    log.error((String)href, (Throwable)e);
                }
                String folderIcon = ds instanceof CatalogScan || ds.hasProperty("CatalogScan") ? "cat_folder.png" : (ds instanceof DatasetScan || ds.hasProperty("DatasetScan") ? "scan_folder.png" : (ds instanceof FeatureCollectionRef ? "fc_folder.png" : "folder.png"));
                sb.append("<img src='").append(this.htmlConfig.prepareUrlStringForHtml(folderIcon)).append("' alt='").append(this.htmlConfig.getFolderIconAlt()).append("'> &nbsp;");
                sb.append("<a href='");
                sb.append(Escape.html((String)href));
                sb.append("'><tt>");
                sb.append(name);
                sb.append("</tt></a></td>\r\n");
            } else {
                if (ds.hasNestedDatasets()) {
                    sb.append("<img src='").append(this.htmlConfig.prepareUrlStringForHtml("folder.png")).append("' alt='").append(this.htmlConfig.getFolderIconAlt()).append("'> &nbsp;");
                }
                if (ds.getAccess().size() == 1 && ServiceType.Resolver == ((Access)ds.getAccess().get(0)).getService().getType()) {
                    Access access = (Access)ds.getAccess().get(0);
                    Object accessUrlName = access.getUnresolvedUrlName();
                    int pos = ((String)accessUrlName).lastIndexOf(".xml");
                    if (((String)accessUrlName).equalsIgnoreCase("latest.xml") && !isLocalCatalog) {
                        String catBaseUriPath = "";
                        String catBaseUri = cat.getBaseURI().toString();
                        pos = catBaseUri.lastIndexOf("catalog.xml");
                        if (pos != -1) {
                            catBaseUriPath = catBaseUri.substring(0, pos);
                        }
                        accessUrlName = this.tdsContext.getContextPath() + "/remoteCatalogService?catalog=" + catBaseUriPath + (String)accessUrlName;
                    } else if (pos != -1) {
                        accessUrlName = ((String)accessUrlName).substring(0, pos) + ".html";
                    }
                    sb.append("<a href='");
                    sb.append(Escape.html((String)accessUrlName));
                    sb.append("'><tt>");
                    String tmpName = name;
                    if (tmpName.endsWith(".xml")) {
                        tmpName = tmpName.substring(0, tmpName.lastIndexOf(46));
                    }
                    sb.append(tmpName);
                    sb.append("</tt></a></td>\r\n");
                } else if (ds.findProperty("NotAThreddsDataset") != null) {
                    sb.append("<a href='");
                    sb.append(Escape.html((String)this.makeFileServerUrl(ds)));
                    sb.append("'><tt>");
                    sb.append(name);
                    sb.append("</tt></a></td>\r\n");
                } else if (ds.getID() != null) {
                    sb.append("<a href='");
                    sb.append(Escape.html((String)catHtml));
                    sb.append("dataset=");
                    sb.append(StringUtil2.replace((String)ds.getID(), (char)'+', (String)"%2B"));
                    sb.append("'><tt>");
                    sb.append(name);
                    sb.append("</tt></a></td>\r\n");
                } else {
                    sb.append("<tt>");
                    sb.append(name);
                    sb.append("</tt></td>\r\n");
                }
            }
            sb.append("<td align='right'><tt>");
            double size = ds.getDataSize();
            if (size > 0.0 && !Double.isNaN(size)) {
                sb.append(Format.formatByteSize((double)size));
            } else {
                sb.append("&nbsp;");
            }
            sb.append("</tt></td>\r\n");
            sb.append("<td align='right'><tt>");
            DateType lastModDateType = ds.getLastModifiedDate();
            if (lastModDateType == null) {
                sb.append("--");
            } else {
                sb.append(lastModDateType.toDateTimeString());
            }
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
            if (ds instanceof CatalogRef) continue;
            shade = this.doDatasets(cat, ds.getDatasetsLocal(), sb, shade, level + 1, isLocalCatalog);
        }
        return shade;
    }

    private String makeFileServerUrl(Dataset ds) {
        Access acc = ds.getAccess(ServiceType.HTTPServer);
        assert (acc != null);
        return acc.getStandardUrlName();
    }

    private String convertDatasetToHtml(String catURL, Dataset dataset, HttpServletRequest request, boolean isLocalCatalog) {
        Formatter out = new Formatter();
        out.format("%s<head>%n", ConfigCatalogHtmlWriter.getHtmlDoctypeAndOpenTag());
        out.format("<title>Catalog Services</title>%n", new Object[0]);
        out.format("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>%n", new Object[0]);
        out.format("%s%n", this.getTdsPageCssLink());
        out.format(this.getGoogleTrackingContent(), new Object[0]);
        out.format("</head>%n", new Object[0]);
        out.format("<body>%n", new Object[0]);
        StringBuilder sb = new StringBuilder();
        this.appendOldStyleHeader(sb);
        out.format("%s%n", sb);
        out.format("<h2> Catalog %s</h2>%n", catURL);
        DatasetHtmlWriter writer = new DatasetHtmlWriter();
        writer.writeHtmlDescription(out, dataset, false, true, false, false, !isLocalCatalog);
        if (isLocalCatalog) {
            this.viewerService.showViewers(out, dataset, request);
        }
        out.format("</body>%n", new Object[0]);
        out.format("</html>%n", new Object[0]);
        return out.toString();
    }

    public int showDataset(String catURL, Dataset dataset, HttpServletRequest request, HttpServletResponse response, boolean isLocalCatalog) throws IOException {
        String datasetAsHtml = this.convertDatasetToHtml(catURL, dataset, request, isLocalCatalog);
        response.setStatus(200);
        response.setContentType(ContentType.html.getContentHeader());
        if (!request.getMethod().equals("HEAD")) {
            PrintWriter pw = response.getWriter();
            pw.write(datasetAsHtml);
            pw.flush();
        }
        return datasetAsHtml.length();
    }

    public String getUserCSS() {
        return "<link rel='stylesheet' href='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getPageCssUrl()) + "' type='text/css' >";
    }

    public String getTdsCatalogCssLink() {
        return "<link rel='stylesheet' href='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getCatalogCssUrl()) + "' type='text/css' >";
    }

    public String getTdsPageCssLink() {
        return "<link rel='stylesheet' href='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getPageCssUrl()) + "' type='text/css' >";
    }

    public String getUserHead() {
        return "<table width='100%'><tr><td>\n" + "  <img src='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstLogoUrl()) + "'\n" + "       alt='" + this.htmlConfig.getHostInstLogoAlt() + "'\n" + "       align='left' valign='top'\n" + "       hspace='10' vspace='2'>\n" + "  <h3><strong>" + this.tdsContext.getWebappDisplayName() + "</strong></h3>\n" + "</td></tr></table>\n";
    }

    public void appendOldStyleHeader(StringBuilder sb) {
        this.appendOldStyleHeader(sb, this.htmlConfig.getWebappName(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getWebappUrl()), this.htmlConfig.getInstallLogoAlt(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallLogoUrl()), this.htmlConfig.getInstallName(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallUrl()), this.htmlConfig.getHostInstName(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstUrl()));
    }

    public void appendOldStyleHeader(StringBuilder sb, String webappName, String webappUrl, String logoAlt, String logoUrl, String installName, String installUrl, String hostName, String hostUrl) {
        sb.append("<table width='100%'>\n").append("<tr><td>\n");
        sb.append("<img src='").append(logoUrl).append("' alt='").append(logoAlt).append("' align='left' valign='top'").append(" hspace='10' vspace='2'").append(">\n");
        sb.append("<h3><strong>").append("<a href='").append(installUrl).append("'>").append(installName).append("</a>").append("</strong>");
        sb.append("</h3>\n");
        sb.append("<h3><strong>").append("<a href='").append(webappUrl).append("'>").append(webappName).append("</a>").append("</strong></h3>\n");
        sb.append("</td></tr>\n").append("</table>\n");
    }

    public void appendSimpleFooter(StringBuilder sb) {
        sb.append("<h3>");
        if (this.htmlConfig.getInstallName() != null) {
            String installUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallUrl());
            if (installUrl != null) {
                sb.append("<a href='").append(installUrl).append("'>");
            }
            sb.append(this.htmlConfig.getInstallName());
            if (installUrl != null) {
                sb.append("</a>");
            }
        }
        if (this.htmlConfig.getHostInstName() != null) {
            sb.append(" at ");
            String hostInstUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstUrl());
            if (hostInstUrl != null) {
                sb.append("<a href='").append(hostInstUrl).append("'>");
            }
            sb.append(this.htmlConfig.getHostInstName());
            if (hostInstUrl != null) {
                sb.append("</a>");
            }
            sb.append(" see <a href='" + this.tdsContext.getContextPath() + "/info/serverInfo.html'> Info </a>");
            sb.append("<br>\n");
        }
        sb.append(this.tdsContext.getWebappDisplayName()).append(" [Version ").append(this.tdsContext.getVersionInfo());
        sb.append("] <a href='").append(this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getWebappDocsUrl())).append("'> Documentation</a>");
        sb.append("</h3>\n");
    }

    public String getGoogleTrackingContent() {
        if (this.htmlConfig.getGoogleTrackingCode().isEmpty()) {
            return "";
        }
        return "<!-- Google Analytics -->\n" + "<script>\n" + "(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){\n" + "(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\n" + "m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\n" + "})(window,document,'script','https://www.google-analytics.com/analytics.js','ga');\n" + '\n' + "ga('create', '" + this.htmlConfig.getGoogleTrackingCode() + "', 'auto');\n" + "ga('send', 'pageview');\n" + "</script>\n" + "<!-- End Google Analytics -->\n";
    }
}

