/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.core.DatasetManager;
import thredds.servlet.ServletUtil;
import thredds.util.TdsPathUtils;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.simpgeometry.SimpleGeometryFeatureDataset;

public class TdsRequestedDataset {
    private static DatasetManager datasetManager;
    private boolean isRemote = false;
    private String path;

    public static void setDatasetManager(DatasetManager _datasetManager) {
        datasetManager = _datasetManager;
    }

    public static DatasetManager getDatasetManager() {
        return datasetManager;
    }

    public static FeatureDatasetPoint getPointDataset(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        TdsRequestedDataset trd = new TdsRequestedDataset(request, null);
        if (path != null) {
            trd.path = path;
        }
        return trd.openAsPointDataset(request, response);
    }

    public static ucar.nc2.dt.GridDataset getGridDataset(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        TdsRequestedDataset trd = new TdsRequestedDataset(request, null);
        if (path != null) {
            trd.path = path;
        }
        return trd.openAsGridDataset(request, response);
    }

    public static CoverageCollection getCoverageCollection(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        TdsRequestedDataset trd = new TdsRequestedDataset(request, null);
        if (path != null) {
            trd.path = path;
        }
        return trd.openAsCoverageDataset(request, response);
    }

    public static SimpleGeometryFeatureDataset getSimpleGeometryFeatureDataset(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        TdsRequestedDataset trd = new TdsRequestedDataset(request, null);
        if (path != null) {
            trd.path = path;
        }
        return trd.openAsSimpleGeometryDataset(request, response);
    }

    public static NetcdfFile getNetcdfFile(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        TdsRequestedDataset trd = new TdsRequestedDataset(request, null);
        if (path != null) {
            trd.path = path;
        }
        return trd.openAsNetcdfFile(request, response);
    }

    public static long getLastModified(String reqPath) {
        File file = TdsRequestedDataset.getFile(reqPath);
        return file == null ? -1L : file.lastModified();
    }

    public static File getFile(String reqPath) {
        String location = TdsRequestedDataset.getLocationFromRequestPath(reqPath);
        return location == null ? null : new File(location);
    }

    public static String getLocationFromRequestPath(String reqPath) {
        return datasetManager.getLocationFromRequestPath(reqPath);
    }

    public static boolean useNetcdfJavaBuilders() {
        return datasetManager.useNetcdfJavaBuilders();
    }

    public static boolean resourceControlOk(HttpServletRequest request, HttpServletResponse response, String path) {
        return datasetManager.resourceControlOk(request, response, path);
    }

    public TdsRequestedDataset(HttpServletRequest request, String removePrefix) throws IOException {
        this.path = TdsPathUtils.extractPath(request, removePrefix);
        if (this.path == null) {
            this.path = ServletUtil.getParameterIgnoreCase(request, "dataset");
            boolean bl = this.isRemote = this.path != null;
        }
        if (this.path == null) {
            throw new FileNotFoundException("Request does not specify a dataset.");
        }
    }

    public FeatureDatasetPoint openAsPointDataset(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return datasetManager.openPointDataset(request, response, this.path);
    }

    public CoverageCollection openAsCoverageDataset(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return datasetManager.openCoverageDataset(request, response, this.path);
    }

    public SimpleGeometryFeatureDataset openAsSimpleGeometryDataset(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.isRemote ? SimpleGeometryFeatureDataset.open((String)this.path) : datasetManager.openSimpleGeometryDataset(request, response, this.path);
    }

    public ucar.nc2.dt.GridDataset openAsGridDataset(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.isRemote ? GridDataset.open((String)this.path) : datasetManager.openGridDataset(request, response, this.path);
    }

    public NetcdfFile openAsNetcdfFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object ncf = null;
        ncf = this.isRemote ? (datasetManager.useNetcdfJavaBuilders() || DatasetManager.isLocationObjectStore(this.path) ? NetcdfDatasets.openDataset((String)this.path) : NetcdfDataset.openDataset((String)this.path)) : datasetManager.openNetcdfFile(request, response, this.path);
        return ncf;
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public String getPath() {
        return this.path;
    }
}

