/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import java.io.IOException;
import java.net.URI;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Service;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.client.catalog.tools.ThreddsMetadataAcdd;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFileCollectionManager;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.writer.ThreddsMetadataExtractor;
import ucar.nc2.Attribute;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.unidata.util.StringUtil2;

public class InvDatasetFcPoint
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcPoint.class);
    private static final String FC = "fc.cdmr";
    private final FeatureDatasetPoint fd;
    private final Set<FeatureCollectionConfig.PointDatasetType> wantDatasets;

    InvDatasetFcPoint(FeatureCollectionRef parent, FeatureCollectionConfig config) {
        super(parent, config);
        this.makeCollection();
        Formatter errlog = new Formatter();
        try {
            this.fd = (FeatureDatasetPoint)CompositeDatasetFactory.factory((String)this.name, (FeatureType)this.fcType.getFeatureType(), (MFileCollectionManager)this.datasetCollection, (Formatter)errlog);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new RuntimeException("Failed to create InvDatasetFcPoint, cause=", e.getCause());
            }
            throw new RuntimeException("Failed to create InvDatasetFcPoint", e);
        }
        this.state = new InvDatasetFeatureCollection.State(null);
        this.wantDatasets = config.pointConfig.datasets;
    }

    @Override
    public void close() {
        if (this.fd != null) {
            try {
                this.fd.close();
            }
            catch (IOException e) {
                logger.error("Cant close {}", (Object)this.fd.getLocation(), (Object)e);
            }
        }
        super.close();
    }

    @Override
    public FeatureDatasetPoint getPointDataset(String matchPath) {
        return this.fd;
    }

    @Override
    public void updateCollection(InvDatasetFeatureCollection.State localState, CollectionUpdateType force) {
        try {
            ((UpdateableCollection)this.fd).update();
        }
        catch (IOException e) {
            logger.error("update failed", (Throwable)e);
        }
    }

    @Override
    public CatalogBuilder makeCatalog(String match, String orgPath, URI catURI) throws IOException {
        logger.debug("FcPoint make catalog for " + match + " " + catURI);
        InvDatasetFeatureCollection.State localState = this.checkState();
        try {
            if (match == null || match.length() == 0) {
                CatalogBuilder main = this.makeCatalogTop(catURI, localState);
                main.removeAnyService();
                return main;
            }
            if (match.startsWith("files") && this.wantDatasets.contains(FeatureCollectionConfig.PointDatasetType.Files)) {
                return this.makeCatalogFiles(catURI, localState, this.datasetCollection.getFilenames(), true);
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.configPath, (Throwable)e);
        }
        return null;
    }

    @Override
    protected DatasetBuilder makeDatasetTop(URI catURI, InvDatasetFeatureCollection.State localState) {
        DatasetBuilder top = new DatasetBuilder(null);
        top.transferInheritedMetadata((DatasetNode)this.parent);
        top.setName(this.name);
        Service topService = allowedServices.getStandardCollectionServices(this.fd.getFeatureType());
        assert (topService != null);
        top.addServiceToCatalog(topService);
        ThreddsMetadata tmi = top.getInheritableMetadata();
        tmi.set("FeatureType", (Object)FeatureType.GRID.toString());
        tmi.set("ServiceName", (Object)topService.getName());
        if (localState.coverage != null) {
            tmi.set("GeospatialCoverage", (Object)localState.coverage);
        }
        if (localState.dateRange != null) {
            tmi.set("TimeCoverage", (Object)localState.dateRange);
        }
        if (localState.vars != null) {
            tmi.set("VariableGroups", (Object)localState.vars);
        }
        if (this.wantDatasets.contains(FeatureCollectionConfig.PointDatasetType.cdmrFeature)) {
            DatasetBuilder ds = new DatasetBuilder(top);
            ds.setName("Feature Collection");
            Object myname = this.name + "_fc.cdmr";
            myname = StringUtil2.replace((String)myname, (char)' ', (String)"_");
            ds.put("UrlPath", (Object)(this.configPath + "/" + (String)myname));
            ds.put("Id", (Object)(this.configPath + "/" + (String)myname));
            ds.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Collection of Point Data"));
            top.addDataset(ds);
        }
        if (this.wantDatasets.contains(FeatureCollectionConfig.PointDatasetType.Files) && this.topDirectory != null) {
            CatalogRefBuilder filesCat = new CatalogRefBuilder(top);
            filesCat.setName("files");
            filesCat.setTitle("files");
            filesCat.setHref(this.getCatalogHref("files"));
            top.addDataset((DatasetBuilder)filesCat);
        }
        ThreddsMetadataAcdd acdd = new ThreddsMetadataAcdd(Attribute.makeMap((List)this.fd.getGlobalAttributes()), top);
        acdd.extract();
        ThreddsMetadataExtractor extractor = new ThreddsMetadataExtractor();
        ThreddsMetadata.GeospatialCoverage coverage = (ThreddsMetadata.GeospatialCoverage)top.get("GeospatialCoverage");
        if (this.fd.getBoundingBox() == null) {
            if (coverage != null) {
                ((PointDatasetImpl)this.fd).setBoundingBox(coverage.getBoundingBox());
            }
        } else if (coverage == null && (coverage = extractor.extractGeospatial(this.fd)) != null) {
            tmi.set("GeospatialCoverage", (Object)coverage);
        }
        tmi.set("VariableGroups", (Object)extractor.extractVariables(this.fd));
        return top;
    }
}

