/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.server.config.HtmlConfigBean;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import ucar.nc2.time.CalendarDate;

@Component
public class HtmlWriting {
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private HtmlConfigBean htmlConfig;

    public String getHtmlDoctypeAndOpenTag() {
        return "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n        'http://www.w3.org/TR/html4/loose.dtd'>\n<html>\n";
    }

    public String getGoogleTrackingContent() {
        if (this.htmlConfig.getGoogleTrackingCode().isEmpty()) {
            return "";
        }
        return "<!-- Google Analytics -->\n" + "<script>\n" + "(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){\n" + "(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\n" + "m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\n" + "})(window,document,'script','https://www.google-analytics.com/analytics.js','ga');\n" + '\n' + "ga('create', '" + this.htmlConfig.getGoogleTrackingCode() + "', 'auto');\n" + "ga('send', 'pageview');\n" + "</script>\n" + "<!-- End Google Analytics -->\n";
    }

    public String getTdsCatalogCssLink() {
        return "<link rel='stylesheet' href='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getCatalogCssUrl()) + "' type='text/css' >";
    }

    public String getTdsPageCssLink() {
        return "<link rel='stylesheet' href='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getPageCssUrl()) + "' type='text/css' >";
    }

    public String getUserHead() {
        return "<table width='100%'><tr><td>\n" + "  <img src='" + this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstLogoUrl()) + "'\n" + "       alt='" + this.htmlConfig.getHostInstLogoAlt() + "'\n" + "       align='left' valign='top'\n" + "       hspace='10' vspace='2'>\n" + "  <h3><strong>" + this.tdsContext.getWebappDisplayName() + "</strong></h3>\n" + "</td></tr></table>\n";
    }

    public String getOldStyleHeader() {
        StringBuilder sb = new StringBuilder();
        this.appendOldStyleHeader(sb);
        return sb.toString();
    }

    public void appendOldStyleHeader(StringBuilder sb) {
        this.appendOldStyleHeader(sb, this.htmlConfig.getWebappName(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getWebappUrl()), this.htmlConfig.getInstallLogoAlt(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallLogoUrl()), this.htmlConfig.getInstallName(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallUrl()), this.htmlConfig.getHostInstName(), this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstUrl()));
    }

    public void appendOldStyleHeader(StringBuilder sb, String webappName, String webappUrl, String logoAlt, String logoUrl, String installName, String installUrl, String hostName, String hostUrl) {
        sb.append("<table width='100%'>\n").append("<tr><td>\n");
        sb.append("<img src='").append(logoUrl).append("' alt='").append(logoAlt).append("' align='left' valign='top'").append(" hspace='10' vspace='2'").append(">\n");
        sb.append("<h3><strong>").append("<a href='").append(installUrl).append("'>").append(installName).append("</a>").append("</strong>");
        sb.append("</h3>\n");
        sb.append("<h3><strong>").append("<a href='").append(webappUrl).append("'>").append(webappName).append("</a>").append("</strong></h3>\n");
        sb.append("</td></tr>\n").append("</table>\n");
    }

    public void appendSimpleFooter(StringBuilder sb) {
        sb.append("<h3>");
        if (this.htmlConfig.getInstallName() != null) {
            String installUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getInstallUrl());
            if (installUrl != null) {
                sb.append("<a href='").append(installUrl).append("'>");
            }
            sb.append(this.htmlConfig.getInstallName());
            if (installUrl != null) {
                sb.append("</a>");
            }
        }
        if (this.htmlConfig.getHostInstName() != null) {
            sb.append(" at ");
            String hostInstUrl = this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getHostInstUrl());
            if (hostInstUrl != null) {
                sb.append("<a href='").append(hostInstUrl).append("'>");
            }
            sb.append(this.htmlConfig.getHostInstName());
            if (hostInstUrl != null) {
                sb.append("</a>");
            }
            sb.append(String.format(" see <a href='%s/serverInfo.html'> Info </a>", this.tdsContext.getContextPath()));
            sb.append("<br>\n");
        }
        sb.append(this.tdsContext.getWebappDisplayName()).append(" [Version ").append(this.tdsContext.getVersionInfo());
        sb.append("] <a href='").append(this.htmlConfig.prepareUrlStringForHtml(this.htmlConfig.getWebappDocsUrl())).append("'> Documentation</a>");
        sb.append("</h3>\n");
    }

    public int writeDirectory(HttpServletResponse res, File dir, String path) throws IOException {
        if (dir == null) {
            res.sendError(404);
            return 0;
        }
        if (!dir.exists() || !dir.isDirectory()) {
            res.sendError(404);
            return 0;
        }
        String dirHtmlString = this.getDirectory(path, dir);
        ServletUtil.setResponseContentLength(res, dirHtmlString);
        res.setContentType(ContentType.html.getContentHeader());
        PrintWriter writer = res.getWriter();
        writer.write(dirHtmlString);
        writer.flush();
        return dirHtmlString.length();
    }

    private String getDirectory(String path, File dir) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>");
        sb.append("<title>");
        sb.append("Directory listing for ").append(dir.getPath());
        sb.append("</title>\r\n");
        sb.append(this.getTdsCatalogCssLink()).append("\n");
        sb.append(this.getGoogleTrackingContent());
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        sb.append("<h1>");
        sb.append("Directory listing for ").append(dir.getPath());
        sb.append("</h1>\r\n");
        sb.append("<HR size='1' noshade='noshade'>");
        sb.append("<table width='100%' cellspacing='0' cellpadding='5' align='center'>\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align='left'><font size='+1'><strong>");
        sb.append("Filename");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align='center'><font size='+1'><strong>");
        sb.append("Size");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align='right'><font size='+1'><strong>");
        sb.append("Last Modified");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        boolean shade = false;
        File[] children = dir.listFiles();
        List<Object> fileList = children == null ? new ArrayList() : Arrays.asList(children);
        Collections.sort(fileList);
        for (File file : fileList) {
            Object childname = file.getName();
            if (((String)childname).equalsIgnoreCase("WEB-INF") || ((String)childname).equalsIgnoreCase("META-INF")) continue;
            if (file.isDirectory()) {
                childname = (String)childname + "/";
            }
            sb.append("<tr");
            if (shade) {
                sb.append(" bgcolor='#eeeeee'");
            }
            sb.append(">\r\n");
            shade = !shade;
            sb.append("<td align='left'>&nbsp;&nbsp;\r\n");
            sb.append("<a href='");
            sb.append((String)childname);
            sb.append("'><tt>");
            sb.append((String)childname);
            sb.append("</tt></a></td>\r\n");
            sb.append("<td align='right'><tt>");
            if (file.isDirectory()) {
                sb.append("&nbsp;");
            } else {
                sb.append(this.renderSize(file.length()));
            }
            sb.append("</tt></td>\r\n");
            sb.append("<td align='right'><tt>");
            sb.append(CalendarDate.of((long)file.lastModified()).toString());
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
        }
        sb.append("</table>\r\n");
        sb.append("<HR size='1' noshade='noshade'>");
        this.appendSimpleFooter(sb);
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return leftSide + "." + rightSide + " kb";
    }
}

