/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.core.CatalogManager;
import thredds.core.TdsRequestedDataset;
import thredds.server.catalogservice.CatalogRequest;
import thredds.server.catalogservice.CatalogViewContextParser;

@Controller
@RequestMapping(value={"/catalog"})
public class CatalogServiceController {
    @Autowired
    private CatalogManager catalogManager;
    @Autowired
    CatalogViewContextParser parser;

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    protected ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response, CatalogRequest params) throws Exception {
        Catalog catalog;
        TdsRequestedDataset reqD = new TdsRequestedDataset(request, "/catalog");
        String path = reqD.getPath();
        boolean isHtml = path.endsWith(".html");
        String catalogPath = path.replaceAll(".html$", ".xml");
        String baseUriString = request.getRequestURL().toString();
        try {
            URI baseUri = new URI(baseUriString);
            catalog = this.catalogManager.getCatalog(catalogPath, baseUri);
        }
        catch (URISyntaxException e) {
            String msg = "Bad URI syntax [" + baseUriString + "]: " + e.getMessage();
            throw new URISyntaxException(msg, e.getReason());
        }
        if (catalog == null) {
            throw new FileNotFoundException(request.getRequestURI());
        }
        if (isHtml) {
            return this.handleHTMLRequest(request, response, catalog, params);
        }
        return this.handleXMLRequest(request, response, catalog, params);
    }

    protected ModelAndView handleXMLRequest(HttpServletRequest request, HttpServletResponse response, Catalog catalog, CatalogRequest params) throws Exception {
        if (params.dataset != null) {
            Dataset dataset = catalog.findDatasetByID(params.dataset);
            if (dataset == null) {
                throw new FileNotFoundException("Did not find dataset [" + params.dataset + "] in catalog [" + request.getRequestURL().toString() + "].");
            }
            Catalog subsetCat = catalog.subsetCatalogOnDataset(dataset);
            return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)subsetCat);
        }
        return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)catalog);
    }

    protected ModelAndView handleHTMLRequest(HttpServletRequest request, HttpServletResponse response, Catalog catalog, CatalogRequest params) throws Exception {
        if (params.dataset != null) {
            Dataset dataset = catalog.findDatasetByID(params.dataset);
            if (dataset == null) {
                throw new FileNotFoundException("Did not find dataset [" + params.dataset + "] in catalog [" + request.getRequestURL().toString() + "].");
            }
            return new ModelAndView("templates/dataset", this.parser.getDatasetViewContext(dataset, request, true));
        }
        return new ModelAndView("templates/catalog", this.parser.getCatalogViewContext(catalog, request, true));
    }
}

