/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;

@Component
public class TdsUpdateConfigBean {
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private boolean logVersionInfo;

    public boolean isLogVersionInfo() {
        return this.logVersionInfo;
    }

    public void setLogVersionInfo(boolean logVersionInfo) {
        this.logVersionInfo = logVersionInfo;
    }

    public Map<String, String> getLatestVersionInfo(String version) {
        int socTimeout = 1;
        int connectionTimeout = 3;
        HashMap<String, String> latestVersionInfo = new HashMap<String, String>();
        String versionUrl = "https://www.unidata.ucar.edu/software/tds/latest.xml";
        try (HTTPMethod method = HTTPFactory.Get((String)versionUrl);){
            HTTPSession httpClient = method.getSession();
            httpClient.setSoTimeout(socTimeout * 1000);
            httpClient.setConnectionTimeout(connectionTimeout * 1000);
            httpClient.setUserAgent("TDS_" + version.replace(" ", ""));
            method.execute();
            InputStream responseIs = method.getResponseBodyAsStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(responseIs);
            Element docEle = dom.getDocumentElement();
            NodeList versionElements = docEle.getElementsByTagName("version");
            if (versionElements != null && versionElements.getLength() > 0) {
                for (int i = 0; i < versionElements.getLength(); ++i) {
                    Element versionElement = (Element)versionElements.item(i);
                    String verType = versionElement.getAttribute("name");
                    String verStr = versionElement.getAttribute("value");
                    latestVersionInfo.put(verType, verStr);
                }
            }
        }
        catch (IOException e) {
            startupLog.warn("TdsContext - Could not get latest version information from Unidata.");
        }
        catch (ParserConfigurationException e) {
            startupLog.error("TdsContext - Error configuring latest version xml parser" + e.getMessage() + ".");
        }
        catch (SAXException e) {
            startupLog.error("TdsContext - Could not parse latest version information.");
        }
        return latestVersionInfo;
    }
}

