/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_0_0_1;

import javax.annotation.Nonnull;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import thredds.server.wcs.Request;
import thredds.server.wcs.v1_0_0_1.WcsDataset;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public abstract class WcsRequest {
    protected static final Namespace wcsNS = Namespace.getNamespace((String)"http://www.opengis.net/wcs");
    protected static final Namespace gmlNS = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml");
    protected static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private Request.Operation operation;
    private String version;
    protected WcsDataset wcsDataset;

    WcsRequest(@Nonnull Request.Operation operation, String version, @Nonnull WcsDataset dataset) {
        this.operation = operation;
        this.version = version;
        this.wcsDataset = dataset;
    }

    public Request.Operation getOperation() {
        return this.operation;
    }

    public String getVersion() {
        return this.version;
    }

    public WcsDataset getWcsDataset() {
        return this.wcsDataset;
    }

    protected Element genCoverageOfferingBriefElem(String elemName, String covName, String covLabel, String covDescription, CoverageCoordSys gridCoordSys) {
        Element briefElem = new Element(elemName, wcsNS);
        if (covDescription != null && !covDescription.equals("")) {
            briefElem.addContent((Content)new Element("description", wcsNS).addContent(covDescription));
        }
        briefElem.addContent((Content)new Element("name", wcsNS).addContent(covName));
        briefElem.addContent((Content)new Element("label", wcsNS).addContent(covLabel));
        briefElem.addContent((Content)this.genLonLatEnvelope(this.wcsDataset.getDataset(), gridCoordSys));
        return briefElem;
    }

    protected Element genLonLatEnvelope(CoverageCollection gcd, CoverageCoordSys gcs) {
        CalendarDateRange dr;
        Element lonLatEnvelopeElem = new Element("lonLatEnvelope", wcsNS);
        lonLatEnvelopeElem.setAttribute("srsName", "urn:ogc:def:crs:OGC:1.3:CRS84");
        LatLonRect llbb = gcd.getLatlonBoundingBox();
        LatLonPointImpl llpt = llbb.getLowerLeftPoint();
        LatLonPointImpl urpt = llbb.getUpperRightPoint();
        String firstPosition = llpt.getLongitude() + " " + llpt.getLatitude();
        double lon = llpt.getLongitude() + llbb.getWidth();
        String secondPosition = lon + " " + urpt.getLatitude();
        lonLatEnvelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(firstPosition));
        lonLatEnvelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(secondPosition));
        CoverageCoordAxis timeCoord = gcs.getTimeAxis();
        if (timeCoord != null && (dr = timeCoord.getDateRange()) != null) {
            lonLatEnvelopeElem.addContent((Content)new Element("timePosition", gmlNS).addContent(dr.getStart().toString()));
            lonLatEnvelopeElem.addContent((Content)new Element("timePosition", gmlNS).addContent(dr.getEnd().toString()));
        }
        return lonLatEnvelopeElem;
    }
}

