/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import java.io.File;
import java.io.FileNotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import thredds.core.TdsRequestedDataset;
import thredds.server.admin.HtmlWriting;
import thredds.server.config.TdsContext;
import thredds.util.TdsPathUtils;

@Controller
@RequestMapping(value={"/admin/dir"})
public class AdminDirDisplayController {
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    HtmlWriting htmlu;

    @RequestMapping(value={"**"})
    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = TdsPathUtils.extractPath(req, "/admin/dir");
        File file = null;
        if (path.startsWith("catalogs/")) {
            file = new File(this.tdsContext.getThreddsDirectory(), path.substring(9));
        } else if (path.startsWith("content/")) {
            file = new File(this.tdsContext.getContentRootDir(), path.substring(8));
        } else if (path.startsWith("logs/")) {
            file = new File(this.tdsContext.getTomcatLogDirectory(), path.substring(5));
        } else if (path.startsWith("dataDir/")) {
            String root = path.substring(8);
            file = TdsRequestedDataset.getFile(root);
        }
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(path);
        }
        if (file.exists() && file.isDirectory()) {
            int i = this.htmlu.writeDirectory(res, file, path);
            res.setStatus(i == 0 ? 404 : 200);
            return null;
        }
        return new ModelAndView("threddsFileView", "file", (Object)file);
    }
}

