/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.notebook;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import thredds.client.catalog.Dataset;
import thredds.core.StandardService;
import thredds.server.exception.MethodNotImplementedException;
import thredds.server.notebook.JupyterNotebookServiceCache;
import thredds.server.notebook.NotebookMetadata;
import thredds.server.viewer.Viewer;
import thredds.server.viewer.ViewerLinkProvider;
import thredds.server.viewer.ViewerService;

public class JupyterNotebookViewerService
implements ViewerService {
    private JupyterNotebookServiceCache jupyterNotebooks;
    private String contentDir;
    private List<Viewer> viewers = new ArrayList<Viewer>();

    public JupyterNotebookViewerService(JupyterNotebookServiceCache jupyterNotebooks, String contentDir) {
        this.jupyterNotebooks = jupyterNotebooks;
        this.contentDir = contentDir;
        this.buildViewerList();
    }

    @Override
    public List<Viewer> getViewers() {
        return this.viewers;
    }

    @Override
    public Viewer getViewer(String viewer) {
        return null;
    }

    @Override
    public String getViewerTemplate(String template) {
        throw new MethodNotImplementedException("JupyterNotebookViewerService.getViewerTemplate is not implemented");
    }

    @Override
    public boolean registerViewer(Viewer v) {
        return this.viewers.add(v);
    }

    @Override
    public boolean registerViewers(List<Viewer> v) {
        return this.viewers.addAll(v);
    }

    @Override
    public void showViewers(Formatter sbuff, Dataset dataset, HttpServletRequest req) {
        throw new MethodNotImplementedException("JupyterNotebookViewerService.showViewers is not implemented");
    }

    @Override
    public List<ViewerLinkProvider.ViewerLink> getViewerLinks(Dataset dataset, HttpServletRequest req) {
        return null;
    }

    private void buildViewerList() {
        this.jupyterNotebooks.getAllNotebooks().forEach(notebook -> this.registerViewer(new JupyterNotebookViewer((NotebookMetadata)notebook, this.contentDir)));
    }

    public static class JupyterNotebookViewer
    implements Viewer {
        private static final ViewerLinkProvider.ViewerLink.ViewerType type = ViewerLinkProvider.ViewerLink.ViewerType.JupyterNotebook;
        private String contentDir;
        private NotebookMetadata notebook;

        public JupyterNotebookViewer(NotebookMetadata notebook, String contentDir) {
            this.notebook = notebook;
            this.contentDir = contentDir;
        }

        @Override
        public boolean isViewable(Dataset ds) {
            return this.notebook.isValidForDataset(ds);
        }

        @Override
        public String getViewerLinkHtml(Dataset ds, HttpServletRequest req) {
            ViewerLinkProvider.ViewerLink viewerLink = this.getViewerLink(ds, req);
            return "<a href='" + viewerLink.getUrl() + "'>" + viewerLink.getTitle() + "</a>";
        }

        @Override
        public ViewerLinkProvider.ViewerLink getViewerLink(Dataset ds, HttpServletRequest req) {
            String catUrl = ds.getCatalogUrl();
            if (catUrl.indexOf(35) > 0) {
                catUrl = catUrl.substring(0, catUrl.lastIndexOf(35));
            }
            if (catUrl.indexOf(this.contentDir) > -1) {
                catUrl = catUrl.substring(catUrl.indexOf(this.contentDir) + this.contentDir.length());
            }
            String catalogServiceBase = StandardService.catalogRemote.getBase();
            catUrl = catUrl.substring(catUrl.indexOf(catalogServiceBase) + catalogServiceBase.length()).replace("html", "xml");
            String url = req.getContextPath() + StandardService.jupyterNotebook.getBase() + ds.getID() + "?catalog=" + catUrl + "&filename=" + this.notebook.getFilename();
            return new ViewerLinkProvider.ViewerLink(this.notebook.getFilename(), url, this.notebook.getDescription(), type);
        }
    }
}

