/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wfs;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import thredds.server.wfs.WFSFeature;
import thredds.server.wfs.WFSFeatureAttribute;
import thredds.server.wfs.WFSXMLHelper;

public class WFSDescribeFeatureTypeWriter {
    private PrintWriter response;
    private String fileOutput;
    private final String server;
    private final String namespace;
    private List<WFSFeature> featureList;

    public WFSDescribeFeatureTypeWriter(PrintWriter response, String server, String namespace) {
        this.response = response;
        this.fileOutput = "";
        this.server = server;
        this.namespace = namespace;
        this.featureList = new ArrayList<WFSFeature>();
    }

    public void startXML() {
        this.fileOutput = this.fileOutput + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        this.fileOutput = this.fileOutput + "<schema xmlns:tdswfs=" + WFSXMLHelper.encQuotes(this.namespace) + " xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns=\"http://www.w3.org/2001/XMLSchema\" xmlns:gml=\"http://www.opengis.net/gml\" targetNamespace=\"" + this.server + "\" elementFormDefault=\"qualified\" version=\"0.1\">";
        this.fileOutput = this.fileOutput + "<xsd:import namespace=\"http://www.opengis.net/gml\" schemaLocation=\"http://schemas.opengis.net/gml/2.1.2/feature.xsd\"/>";
    }

    public void addFeature(WFSFeature feature) {
        this.featureList.add(feature);
    }

    public void writeFeatures() {
        for (WFSFeature feat : this.featureList) {
            this.fileOutput = this.fileOutput + "<xsd:complexType name=\"" + feat.getTitle() + "\">";
            this.fileOutput = this.fileOutput + "<xsd:complexContent>";
            this.fileOutput = this.fileOutput + "<xsd:extension base=\"gml:" + feat.getType() + "\">";
            this.fileOutput = this.fileOutput + "<xsd:sequence>";
            for (WFSFeatureAttribute attribute : feat.getAttributes()) {
                this.fileOutput = this.fileOutput + "<xsd:element name =\"" + attribute.getName() + "\" type=\"" + attribute.getType() + "\"/>";
            }
            this.fileOutput = this.fileOutput + "</xsd:sequence>";
            this.fileOutput = this.fileOutput + "</xsd:extension>";
            this.fileOutput = this.fileOutput + "</xsd:complexContent>";
            this.fileOutput = this.fileOutput + "</xsd:complexType>";
            this.fileOutput = this.fileOutput + "<xsd:element name =\"" + feat.getName() + "\" type=\"tds:" + feat.getTitle() + "\"/>";
        }
    }

    public void finishXML() {
        this.fileOutput = this.fileOutput + "</schema>";
        this.response.append(this.fileOutput);
        this.response = null;
        this.fileOutput = null;
    }
}

