/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import thredds.server.config.TdsServerInfoBean;
import thredds.server.config.WmsConfigBean;
import thredds.server.wms.TdsEnhancedVariableMetadata;
import thredds.server.wms.TdsWmsDatasetFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.NetcdfDataset;
import uk.ac.rdg.resc.edal.dataset.DataSource;
import uk.ac.rdg.resc.edal.dataset.Dataset;
import uk.ac.rdg.resc.edal.dataset.DiscreteLayeredDataset;
import uk.ac.rdg.resc.edal.domain.MapDomain;
import uk.ac.rdg.resc.edal.exceptions.EdalException;
import uk.ac.rdg.resc.edal.graphics.exceptions.EdalLayerNotFoundException;
import uk.ac.rdg.resc.edal.graphics.utils.EnhancedVariableMetadata;
import uk.ac.rdg.resc.edal.graphics.utils.FeatureCatalogue;
import uk.ac.rdg.resc.edal.graphics.utils.LayerNameMapper;
import uk.ac.rdg.resc.edal.graphics.utils.PlottingDomainParams;
import uk.ac.rdg.resc.edal.graphics.utils.SldTemplateStyleCatalogue;
import uk.ac.rdg.resc.edal.graphics.utils.StyleCatalogue;
import uk.ac.rdg.resc.edal.metadata.DiscreteLayeredVariableMetadata;
import uk.ac.rdg.resc.edal.metadata.VariableMetadata;
import uk.ac.rdg.resc.edal.util.CollectionUtils;
import uk.ac.rdg.resc.edal.wms.WmsCatalogue;
import uk.ac.rdg.resc.edal.wms.util.ContactInfo;
import uk.ac.rdg.resc.edal.wms.util.ServerInfo;

public class ThreddsWmsCatalogue
implements WmsCatalogue {
    TdsWmsDatasetFactory datasetFactory = new TdsWmsDatasetFactory();
    private final DiscreteLayeredDataset<? extends DataSource, ? extends DiscreteLayeredVariableMetadata> dataset;
    private static final StyleCatalogue styleCatalogue = SldTemplateStyleCatalogue.getStyleCatalogue();
    private static TdsServerInfoBean serverInfo;
    private static WmsConfigBean wmsConfig;
    private final String datasetTitle;
    private final String tdsDatasetPath;
    private static final boolean downloadableDefault = true;

    public ThreddsWmsCatalogue(NetcdfDataset ncd, String tdsDatasetPath) throws IOException, EdalException {
        Attribute datasetTitleAttr;
        this.datasetFactory.setNetcdfDataset(ncd);
        String possibleDatasetTitle = ncd.getTitle();
        if (possibleDatasetTitle == null && (datasetTitleAttr = ncd.findGlobalAttributeIgnoreCase("title")) != null) {
            possibleDatasetTitle = datasetTitleAttr.getStringValue();
        }
        this.datasetTitle = possibleDatasetTitle != null ? possibleDatasetTitle : "No dataset title found.";
        String location = ncd.getLocation();
        this.dataset = this.datasetFactory.createDataset(tdsDatasetPath, location);
        this.tdsDatasetPath = tdsDatasetPath;
    }

    public String getTdsDatasetPath() {
        return this.tdsDatasetPath;
    }

    public FeatureCatalogue.FeaturesAndMemberName getFeaturesForLayer(String layerName, PlottingDomainParams params) throws EdalException {
        MapDomain mapDomain = new MapDomain(params.getBbox(), params.getWidth(), params.getHeight(), params.getTargetZ(), params.getTargetT());
        List extractedFeatures = this.dataset.extractMapFeatures(CollectionUtils.setOf((Object[])new String[]{layerName}), mapDomain);
        return new FeatureCatalogue.FeaturesAndMemberName((Collection)extractedFeatures, layerName);
    }

    public Collection<Dataset> getAllDatasets() {
        ArrayList<Dataset> ret = new ArrayList<Dataset>();
        ret.add((Dataset)this.dataset);
        return ret;
    }

    public boolean allowsGlobalCapabilities() {
        return true;
    }

    public Dataset getDatasetFromId(String layerName) {
        return this.dataset;
    }

    public String getDatasetTitle(String layerName) {
        return this.datasetTitle != null ? this.datasetTitle : "Untitled Dataset";
    }

    public boolean isDisabled(String layerName) {
        return false;
    }

    public boolean isDownloadable(String layerName) {
        return true;
    }

    public boolean isQueryable(String layerName) {
        return true;
    }

    public DateTime getLastUpdateTime() {
        return new DateTime();
    }

    public ContactInfo getContactInfo() {
        return new ContactInfo(){

            public String getTelephone() {
                return serverInfo.getContactPhone();
            }

            public String getOrganisation() {
                return serverInfo.getContactOrganization();
            }

            public String getName() {
                return serverInfo.getContactName();
            }

            public String getEmail() {
                return serverInfo.getContactEmail();
            }
        };
    }

    public static void setTdsServerInfo(TdsServerInfoBean info) {
        serverInfo = info;
    }

    public static void setWmsConfig(WmsConfigBean config) {
        wmsConfig = config;
    }

    public ServerInfo getServerInfo() {
        return new ServerInfo(){

            public String getName() {
                return serverInfo.getName();
            }

            public int getMaxSimultaneousLayers() {
                return 1;
            }

            public int getMaxImageWidth() {
                return wmsConfig.getMaxImageWidth();
            }

            public int getMaxImageHeight() {
                return wmsConfig.getMaxImageHeight();
            }

            public List<String> getKeywords() {
                String[] keywords;
                String tdsKeywords = serverInfo.getKeywords();
                List<String> wmsKeywords = new ArrayList<String>();
                if (tdsKeywords != null && (keywords = tdsKeywords.split(",")).length > 0) {
                    wmsKeywords = Arrays.asList(keywords);
                }
                return wmsKeywords;
            }

            public String getAbstract() {
                return serverInfo.getSummary();
            }

            public boolean allowsFeatureInfo() {
                return true;
            }

            public boolean allowsGlobalCapabilities() {
                return true;
            }
        };
    }

    public LayerNameMapper getLayerNameMapper() {
        return new LayerNameMapper(){

            public String getVariableIdFromLayerName(String layerName) throws EdalLayerNotFoundException {
                return layerName;
            }

            public String getLayerName(String datasetId, String varId) {
                return varId;
            }

            public String getDatasetIdFromLayerName(String layerName) throws EdalLayerNotFoundException {
                return ThreddsWmsCatalogue.this.dataset.getId();
            }
        };
    }

    public StyleCatalogue getStyleCatalogue() {
        return styleCatalogue;
    }

    public EnhancedVariableMetadata getLayerMetadata(VariableMetadata metadata) throws EdalLayerNotFoundException {
        return new TdsEnhancedVariableMetadata(this, metadata);
    }
}

