/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFileCollectionManager;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.writer.ThreddsMetadataExtractor;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ft2.coverage.adapter.DtCoverageAdapter;
import ucar.nc2.ft2.coverage.adapter.DtCoverageDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class InvDatasetFcFmrc
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcFmrc.class);
    private static final String FMRC = "fmrc.ncd";
    private static final String BEST = "best.ncd";
    private static final String RUNS = "runs";
    private static final String RUN_NAME = "RUN_";
    private static final String RUN_TITLE = "Forecast Model Run";
    private static final String FORECAST = "forecast";
    private static final String FORECAST_NAME = "ConstantForecast_";
    private static final String FORECAST_TITLE = "Constant Forecast Date";
    private static final String OFFSET = "offset";
    private static final String OFFSET_NAME = "Offset_";
    private static final String OFFSET_TITLE = "Constant Forecast Offset";
    private final Fmrc fmrc;
    private final Set<FeatureCollectionConfig.FmrcDatasetType> wantDatasets;

    InvDatasetFcFmrc(FeatureCollectionRef parent, FeatureCollectionConfig config) {
        super(parent, config);
        this.makeCollection();
        boolean filesFound = this.datasetCollection.getFilesSorted().iterator().hasNext();
        if (!filesFound) {
            String collectionName = parent.getCollectionName();
            String spec = config.spec;
            String catalog = parent.getParentCatalog().getUriString();
            String logMsg = String.format("The FMRC %s defined in %s cannot find any files matching the spec %s.", collectionName, catalog, spec);
            logger.warn(logMsg);
            String errMsg = String.format("The FMRC %s cannot find any files in the collection.", collectionName);
            throw new RuntimeException(errMsg);
        }
        Formatter errlog = new Formatter();
        try {
            this.fmrc = new Fmrc((MCollection)this.datasetCollection, config);
        }
        catch (Exception e) {
            throw new RuntimeException(errlog.toString());
        }
        this.wantDatasets = config.fmrcConfig.datasets;
        this.state = new InvDatasetFeatureCollection.State(this, null);
    }

    @Override
    public void close() {
        if (this.fmrc != null) {
            this.fmrc.close();
        }
        super.close();
    }

    @Override
    protected void update(CollectionUpdateType force) throws IOException {
        logger.debug("update {} force={}", (Object)this.name, (Object)force);
        switch (force) {
            case always: 
            case test: {
                MFileCollectionManager dcm = (MFileCollectionManager)this.getDatasetCollectionManager();
                boolean changed = dcm.scan(false);
                if (!changed) break;
                super.update(force);
                break;
            }
            case never: {
                return;
            }
            default: {
                super.update(force);
            }
        }
    }

    public void updateProto() {
        this.fmrc.updateProto();
    }

    @Override
    protected void updateCollection(InvDatasetFeatureCollection.State localState, CollectionUpdateType force) {
        try {
            this.fmrc.update();
            boolean checkInv = this.fmrc.checkInvState(localState.lastInvChange);
            boolean checkProto = this.fmrc.checkProtoState(localState.lastProtoChange);
            if (checkProto) {
                GridDataset gds = this.fmrc.getDataset2D(null);
                if (null != gds) {
                    ThreddsMetadataExtractor extractor = new ThreddsMetadataExtractor();
                    localState.vars = extractor.extractVariables(null, (ucar.nc2.dt.GridDataset)gds);
                    localState.coverage = extractor.extractGeospatial((ucar.nc2.dt.GridDataset)gds);
                    localState.dateRange = extractor.extractCalendarDateRange((ucar.nc2.dt.GridDataset)gds);
                }
                localState.lastProtoChange = System.currentTimeMillis();
            }
            if (checkInv) {
                localState.lastInvChange = System.currentTimeMillis();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CatalogBuilder makeCatalog(String match, String orgPath, URI catURI) throws IOException {
        logger.debug("FMRC make catalog for " + match + " " + catURI);
        InvDatasetFeatureCollection.State localState = this.checkState();
        try {
            if (match == null || match.length() == 0) {
                return this.makeCatalogTop(catURI, localState);
            }
            if (match.equals(RUNS) && this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.Runs)) {
                return this.makeCatalogRuns(catURI, localState);
            }
            if (match.equals(OFFSET) && this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
                return this.makeCatalogOffsets(catURI, localState);
            }
            if (match.equals(FORECAST) && this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
                return this.makeCatalogForecasts(catURI, localState);
            }
            if (match.startsWith("files") && this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.Files)) {
                return this.makeCatalogFiles(catURI, localState, this.datasetCollection.getFilenames(), true);
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.configPath, (Throwable)e);
        }
        return null;
    }

    private CatalogBuilder makeCatalog(URI catURI, InvDatasetFeatureCollection.State localState, String name) throws IOException {
        Catalog parentCatalog = this.parent.getParentCatalog();
        CatalogBuilder result = new CatalogBuilder();
        result.setName(this.makeFullName((DatasetNode)this.parent));
        result.setVersion(parentCatalog.getVersion());
        result.setBaseURI(catURI);
        result.addService(this.virtualService);
        DatasetBuilder top = new DatasetBuilder(null);
        top.transferInheritedMetadata((DatasetNode)this.parent);
        top.setName(name);
        ThreddsMetadata tmi = top.getInheritableMetadata();
        tmi.set("ServiceName", (Object)this.virtualService.getName());
        if (localState.coverage != null) {
            tmi.set("GeospatialCoverage", (Object)localState.coverage);
        }
        if (localState.dateRange != null) {
            tmi.set("TimeCoverage", (Object)localState.dateRange);
        }
        if (localState.vars != null) {
            tmi.set("VariableGroups", (Object)localState.vars);
        }
        result.addDataset(top);
        return result;
    }

    private CatalogBuilder makeCatalogRuns(URI catURI, InvDatasetFeatureCollection.State localState) throws IOException {
        CatalogBuilder runCatalog = this.makeCatalog(catURI, localState, RUN_TITLE);
        DatasetBuilder top = runCatalog.getTopDataset();
        if (top != null) {
            for (DatasetBuilder ds : this.makeRunDatasets(top)) {
                top.addDataset(ds);
            }
        }
        return runCatalog;
    }

    private CatalogBuilder makeCatalogOffsets(URI catURI, InvDatasetFeatureCollection.State localState) throws IOException {
        CatalogBuilder offCatalog = this.makeCatalog(catURI, localState, OFFSET_TITLE);
        DatasetBuilder top = offCatalog.getTopDataset();
        if (top != null) {
            for (DatasetBuilder ds : this.makeOffsetDatasets(top)) {
                top.addDataset(ds);
            }
        }
        return offCatalog;
    }

    private CatalogBuilder makeCatalogForecasts(URI catURI, InvDatasetFeatureCollection.State localState) throws IOException {
        CatalogBuilder forecastCatalog = this.makeCatalog(catURI, localState, FORECAST_TITLE);
        DatasetBuilder top = forecastCatalog.getTopDataset();
        if (top != null) {
            for (DatasetBuilder ds : this.makeForecastDatasets(top)) {
                top.addDataset(ds);
            }
        }
        return forecastCatalog;
    }

    private List<DatasetBuilder> makeRunDatasets(DatasetBuilder parent) throws IOException {
        ArrayList<DatasetBuilder> datasets = new ArrayList<DatasetBuilder>();
        for (CalendarDate runDate : this.fmrc.getRunDates()) {
            Object myname = this.name + "_RUN_" + runDate;
            myname = StringUtil2.replace((String)myname, (char)' ', (String)"_");
            DatasetBuilder nested = new DatasetBuilder(parent);
            nested.setName((String)myname);
            nested.put("UrlPath", (Object)(this.configPath + "/runs/" + (String)myname));
            nested.put("Id", (Object)(this.configPath + "/runs/" + (String)myname));
            nested.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Data from Run " + (String)myname));
            CalendarDateRange cdr = this.fmrc.getDateRangeForRun(runDate);
            if (cdr != null) {
                nested.put("TimeCoverage", (Object)new DateRange(cdr));
            }
            datasets.add(nested);
        }
        Collections.reverse(datasets);
        return datasets;
    }

    private List<DatasetBuilder> makeOffsetDatasets(DatasetBuilder parent) throws IOException {
        ArrayList<DatasetBuilder> datasets = new ArrayList<DatasetBuilder>();
        for (double offset : this.fmrc.getForecastOffsets()) {
            Object myname = this.name + "_Offset_" + offset + "hr";
            myname = StringUtil2.replace((String)myname, (char)' ', (String)"_");
            DatasetBuilder nested = new DatasetBuilder(parent);
            nested.setName((String)myname);
            nested.put("UrlPath", (Object)(this.configPath + "/offset/" + (String)myname));
            nested.put("Id", (Object)(this.configPath + "/offset/" + (String)myname));
            nested.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Data from the " + offset + " hour forecasts, across different model runs."));
            CalendarDateRange cdr = this.fmrc.getDateRangeForOffset(offset);
            if (cdr != null) {
                nested.put("TimeCoverage", (Object)new DateRange(cdr));
            }
            datasets.add(nested);
        }
        return datasets;
    }

    private List<DatasetBuilder> makeForecastDatasets(DatasetBuilder parent) throws IOException {
        ArrayList<DatasetBuilder> datasets = new ArrayList<DatasetBuilder>();
        for (CalendarDate forecastDate : this.fmrc.getForecastDates()) {
            Object myname = this.name + "_ConstantForecast_" + forecastDate;
            myname = StringUtil2.replace((String)myname, (char)' ', (String)"_");
            DatasetBuilder nested = new DatasetBuilder(parent);
            nested.setName((String)myname);
            nested.put("UrlPath", (Object)(this.configPath + "/forecast/" + (String)myname));
            nested.put("Id", (Object)(this.configPath + "/forecast/" + (String)myname));
            nested.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Data with the same forecast date, " + this.name + ", across different model runs."));
            nested.put("TimeCoverage", (Object)new DateRange(CalendarDateRange.of((CalendarDate)forecastDate, (CalendarDate)forecastDate)));
            datasets.add(nested);
        }
        return datasets;
    }

    @Override
    protected DatasetBuilder makeDatasetTop(URI catURI, InvDatasetFeatureCollection.State localState) {
        CatalogRefBuilder ds;
        Object myname;
        DatasetBuilder top = new DatasetBuilder(null);
        top.transferInheritedMetadata((DatasetNode)this.parent);
        top.setName(this.name);
        top.addServiceToCatalog(this.virtualService);
        ThreddsMetadata tmi = top.getInheritableMetadata();
        tmi.set("FeatureType", (Object)FeatureType.GRID.toString());
        tmi.set("ServiceName", (Object)this.virtualService.getName());
        if (localState.coverage != null) {
            tmi.set("GeospatialCoverage", (Object)localState.coverage);
        }
        if (localState.dateRange != null) {
            tmi.set("TimeCoverage", (Object)localState.dateRange);
        }
        if (localState.vars != null) {
            tmi.set("VariableGroups", (Object)localState.vars);
        }
        if (this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.TwoD)) {
            DatasetBuilder twoD = new DatasetBuilder(top);
            twoD.setName("Forecast Model Run Collection (2D time coordinates)");
            myname = this.name + "_fmrc.ncd";
            myname = StringUtil2.replace((String)myname, (char)' ', (String)"_");
            twoD.put("UrlPath", (Object)(this.configPath + "/" + (String)myname));
            twoD.put("Id", (Object)(this.configPath + "/" + (String)myname));
            twoD.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Forecast Model Run Collection (2D time coordinates)."));
            top.addDataset(twoD);
        }
        if (this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.Best)) {
            DatasetBuilder best = new DatasetBuilder(top);
            best.setName("Best Time Series");
            myname = this.name + "_best.ncd";
            myname = StringUtil2.replace((String)myname, (char)' ', (String)"_");
            best.put("UrlPath", (Object)(this.configPath + "/" + (String)myname));
            best.put("Id", (Object)(this.configPath + "/" + (String)myname));
            best.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Best time series, taking the data from the most recent run available."));
            top.addDataset(best);
        }
        if (this.config.fmrcConfig.getBestDatasets() != null) {
            for (FeatureCollectionConfig.BestDataset bd : this.config.fmrcConfig.getBestDatasets()) {
                DatasetBuilder ds2 = new DatasetBuilder(top);
                ds2.setName(bd.name);
                Object myname2 = this.name + "_" + bd.name;
                myname2 = StringUtil2.replace((String)myname2, (char)' ', (String)"_");
                ds2.put("UrlPath", (Object)(this.configPath + "/" + (String)myname2));
                ds2.put("Id", (Object)(this.configPath + "/" + (String)myname2));
                ds2.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Best time series, excluding offset hours less than " + bd.greaterThan));
                top.addDataset(ds2);
            }
        }
        if (this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.Runs)) {
            ds = new CatalogRefBuilder(top);
            ds.setTitle(RUN_TITLE);
            ds.setHref(this.getCatalogHref(RUNS));
            top.addDataset((DatasetBuilder)ds);
        }
        if (this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
            ds = new CatalogRefBuilder(top);
            ds.setTitle(FORECAST_TITLE);
            ds.setHref(this.getCatalogHref(FORECAST));
            top.addDataset((DatasetBuilder)ds);
        }
        if (this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
            ds = new CatalogRefBuilder(top);
            ds.setTitle(OFFSET_TITLE);
            ds.setHref(this.getCatalogHref(OFFSET));
            top.addDataset((DatasetBuilder)ds);
        }
        if (this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.Files) && this.topDirectory != null) {
            ds = new CatalogRefBuilder(top);
            ds.setTitle("files");
            ds.setHref(this.getCatalogHref("files"));
            top.addDataset((DatasetBuilder)ds);
        }
        return top;
    }

    @Override
    public CoverageCollection getGridCoverage(String matchPath) throws IOException {
        NetcdfDataset ncd = this.getNetcdfDataset(matchPath);
        if (ncd == null) {
            return null;
        }
        DtCoverageDataset gds = new DtCoverageDataset(ncd);
        FeatureDatasetCoverage cc = DtCoverageAdapter.factory((DtCoverageDataset)gds, (Formatter)new Formatter());
        if (cc == null) {
            return null;
        }
        assert (cc.getCoverageCollections().size() == 1);
        return (CoverageCollection)cc.getCoverageCollections().get(0);
    }

    @Override
    public GridDataset getGridDataset(String matchPath) throws IOException {
        InvDatasetFeatureCollection.State localState = this.checkState();
        int pos = matchPath.indexOf(47);
        String wantType = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String wantName = pos > -1 ? matchPath.substring(pos + 1) : matchPath;
        String hasName = StringUtil2.replace((String)this.name, (char)' ', (String)"_") + "_";
        try {
            if (wantType.equalsIgnoreCase("files")) {
                NetcdfDataset ncdNew = this.getNetcdfDataset(matchPath);
                NetcdfDataset ncd = new NetcdfDataset(ncdNew.getReferencedFile(), null);
                return ncd == null ? null : new GridDataset(ncd);
            }
            if (wantName.equals(hasName + FMRC) && this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.TwoD)) {
                return this.fmrc.getDataset2D(null);
            }
            if (wantName.equals(hasName + BEST) && this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.Best)) {
                return this.fmrc.getDatasetBest();
            }
            if (wantType.equals(OFFSET) && this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
                int pos1 = wantName.lastIndexOf(OFFSET_NAME);
                int pos2 = wantName.lastIndexOf("hr");
                if (pos1 < 0 || pos2 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + OFFSET_NAME.length(), pos2);
                try {
                    double hour = Double.parseDouble(id);
                    return this.fmrc.getConstantOffsetDataset(hour);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (wantType.equals(RUNS) && this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.Runs)) {
                int pos1 = wantName.indexOf(RUN_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + RUN_NAME.length());
                CalendarDate date = CalendarDate.parseISOformat(null, (String)id);
                if (date == null) {
                    return null;
                }
                return this.fmrc.getRunTimeDataset(date);
            }
            if (wantType.equals(FORECAST) && this.wantDatasets.contains(FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
                int pos1 = wantName.indexOf(FORECAST_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + FORECAST_NAME.length());
                CalendarDate date = CalendarDate.parseISOformat(null, (String)id);
                if (date == null) {
                    return null;
                }
                return this.fmrc.getConstantForecastDataset(date);
            }
            if (this.config.fmrcConfig.getBestDatasets() != null) {
                for (FeatureCollectionConfig.BestDataset bd : this.config.fmrcConfig.getBestDatasets()) {
                    if (!wantName.endsWith(bd.name)) continue;
                    return this.fmrc.getDatasetBest(bd);
                }
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return null;
    }
}

