/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.params;

import java.util.List;
import thredds.server.ncss.params.NcssParamsBean;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPoint;

public class NcssPointParamsBean
extends NcssParamsBean {
    private List<String> stns;

    public List<String> getStns() {
        return this.stns;
    }

    public void setStns(List<String> stns) {
        this.stns = stns;
    }

    public boolean hasStations() {
        return this.stns != null && !this.stns.isEmpty();
    }

    public NcssPointParamsBean() {
    }

    public NcssPointParamsBean(NcssParamsBean from) {
        super(from);
    }

    public SubsetParams makeSubset() {
        SubsetParams subset = new SubsetParams();
        subset.set("var", (Object)this.var);
        if (this.stns != null) {
            subset.set("stn", this.stns);
        } else if (this.hasLatLonBB()) {
            subset.set("latlonBB", (Object)this.getLatLonBoundingBox());
        } else if (this.hasLatLonPoint()) {
            subset.set("latlonPoint", (Object)LatLonPoint.create((double)this.getLatitude(), (double)this.getLongitude()));
        }
        CalendarDate date = this.getRequestedDate(Calendar.getDefault());
        CalendarDateRange dateRange = this.getCalendarDateRange(Calendar.getDefault());
        if (this.isAllTimes()) {
            subset.set("timeAll", (Object)true);
        } else if (date != null) {
            subset.set("time", (Object)date);
        } else if (dateRange != null) {
            subset.set("timeRange", (Object)dateRange);
        } else {
            subset.set("timePresent", (Object)true);
        }
        if (this.timeWindow != null) {
            CalendarPeriod period = CalendarPeriod.of((TimeDuration)this.timeWindow);
            subset.set("timeWindow", (Object)period);
        }
        return subset;
    }
}

