/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.viewer;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import thredds.client.catalog.Dataset;
import thredds.server.viewer.Viewer;

public interface ViewerLinkProvider
extends Viewer {
    public List<ViewerLink> getViewerLinks(Dataset var1, HttpServletRequest var2);

    public static class ViewerLink {
        private String title;
        private String url;
        private String description;
        private ViewerType type;

        public ViewerLink(String title, String url) {
            this(title, url, "", ViewerType.Unknown);
        }

        public ViewerLink(String title, String url, String description) {
            this(title, url, description, ViewerType.Unknown);
        }

        public ViewerLink(String title, String url, String description, ViewerType type) {
            this.title = title;
            this.url = url;
            this.description = description;
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            return this.url;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type.getName();
        }

        public static enum ViewerType {
            Application("Application"),
            Browser("Browser"),
            JupyterNotebook("Jupyter Notebook"),
            Unknown("Unknown");

            protected final String name;

            private ViewerType(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }
        }
    }
}

