/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection.cache;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import javax.annotation.Nullable;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.internal.dataset.ft.fmrc.InventoryCacheProvider;

public class GridInventoryCacheChronicle
implements InventoryCacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(GridInventoryCacheChronicle.class);
    private static ChronicleMap<String, byte[]> cache;

    public static void init(Path cacheDir) throws IOException {
        Path dbFile;
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            logger.info("Creating cache directory at {}", (Object)cacheDir.toString());
            Files.createDirectories(cacheDir, new FileAttribute[0]);
        }
        if (Files.exists(dbFile = cacheDir.resolve("GridDatasetInv.dat"), new LinkOption[0])) {
            logger.info("Previous grid inventory cache found. Using {}", (Object)dbFile.toString());
        } else {
            logger.info("Creating new grid inventory cache file at {}", (Object)dbFile.toString());
        }
        if (cache == null) {
            cache = ChronicleMapBuilder.of(String.class, byte[].class).name("GridDatasetInv").averageKey((Object)"/data/project/analysis/file.ext").averageValueSize(4096.0).entries(1000L).createOrRecoverPersistedTo(dbFile.toFile());
        }
    }

    @Nullable
    public GridDatasetInv get(MFile mfile) throws IOException {
        String mfileLoc;
        byte[] xmlBytes;
        GridDatasetInv inv = null;
        if (cache != null && (xmlBytes = (byte[])cache.getOrDefault((Object)(mfileLoc = mfile.getPath()), null)) != null) {
            inv = GridDatasetInv.readXML((byte[])xmlBytes);
            if (inv.isXmlVersionCompatible()) {
                long fileModifiedSecs = mfile.getLastModified() / 1000L;
                long xmlModifiedSecs = inv.getLastModified() / 1000L;
                if (xmlModifiedSecs >= fileModifiedSecs) {
                    logger.debug("cache ok {} >= {} for {}", new Object[]{xmlModifiedSecs, fileModifiedSecs, mfileLoc});
                } else {
                    logger.info(" cache out of date {} < {} for {}. Removing cache entry.", new Object[]{xmlModifiedSecs, fileModifiedSecs, mfileLoc});
                    cache.remove((Object)mfileLoc);
                }
            } else {
                logger.error("GridDatasetInv xml version needs upgrade for {}. Removing cache entry.", (Object)mfileLoc);
                cache.remove((Object)mfileLoc);
            }
        }
        return inv;
    }

    public void put(MFile mfile, GridDatasetInv inventory) throws IOException {
        if (cache != null) {
            String xml = inventory.writeXML(new Date(mfile.getLastModified()));
            cache.put((Object)mfile.getPath(), (Object)xml.getBytes(Charsets.UTF_8));
        }
    }

    public static void shutdown() {
        if (cache != null) {
            cache.close();
        }
    }
}

