/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DDS;
import opendap.dap.parsers.ParseException;
import opendap.servers.ServerDDS;
import opendap.servlet.www.jscriptCore;
import opendap.servlet.www.wwwFactory;
import opendap.servlet.www.wwwOutPut;
import thredds.server.config.ThreddsConfig;

public class GetHTMLInterfaceHandler2 {
    private static final boolean _Debug = false;
    private String helpLocation = "https://www.opendap.org/support/user-documentation";
    private String serverContactName = ThreddsConfig.get("serverInformation.contact.name", "UNKNOWN");
    private String serverContactEmail = ThreddsConfig.get("serverInformation.contact.email", "UNKNOWN");
    private String odapSupportEmail = "support-thredds@unidata.ucar.edu";

    public void sendDataRequestForm(HttpServletRequest request, HttpServletResponse response, String dataSet, ServerDDS sdds, DAS myDAS) throws DAP2Exception, ParseException {
        int suffixIndex = request.getRequestURL().toString().lastIndexOf(".");
        String requestURL = request.getRequestURL().substring(0, suffixIndex);
        String dapCssUrl = "/" + requestURL.split("/", 5)[3] + "/tdsDap.css";
        try {
            PrintWriter pw = response.getWriter();
            wwwOutPut wOut = new wwwOutPut(pw);
            DDS myDDS = this.getWebFormDDS(dataSet, sdds);
            jscriptCore jsc = new jscriptCore();
            pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"\n\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n<html><head><title>OPeNDAP Dataset Query Form</title>\n<link type=\"text/css\" rel=\"stylesheet\" media=\"screen\" href=\"" + dapCssUrl + "\"/>\n<base href=\"" + this.helpLocation + "\">\n<script type=\"text/javascript\">\n<!--\n");
            pw.flush();
            pw.println(jscriptCore.jScriptCode);
            pw.flush();
            pw.println("DODS_URL = new dods_url(\"" + requestURL + "\");\n// -->\n</script>\n</head>\n<body>\n<p><h2 align='center'>OPeNDAP Dataset Access Form</h2>\n<hr>\n<form action=\"\">\n<table>\n");
            pw.flush();
            wOut.writeDisposition(requestURL);
            pw.println("<tr><td><td><hr>\n");
            wOut.writeGlobalAttributes(myDAS, myDDS);
            pw.println("<tr><td><td><hr>\n");
            wOut.writeVariableEntries(myDAS, myDDS);
            pw.println("</table></form>\n");
            pw.println("<hr>\n");
            pw.println("<address>");
            pw.println("<p>For questions or comments about this dataset, contact the administrator of this server [" + this.serverContactName + "] at: <a href='mailto:" + this.serverContactEmail + "'>" + this.serverContactEmail + "</a></p>");
            pw.println("<p>For questions or comments about the OPeNDAP service bundled with the TDS, email THREDDS support at: <a href='mailto:" + this.odapSupportEmail + "'>" + this.odapSupportEmail + "</a></p>");
            pw.println("</address></body></html>");
            pw.println("<hr>");
            pw.println("<h2>DDS:</h2>");
            pw.println("<pre>");
            myDDS.print(pw);
            pw.println("</pre>");
            pw.println("<hr>");
            pw.flush();
        }
        catch (IOException ioe) {
            System.out.println("OUCH! IOException: " + ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
    }

    public DDS getWebFormDDS(String dataSet, ServerDDS sDDS) throws DAP2Exception, ParseException {
        wwwFactory wfactory = new wwwFactory();
        DDS wwwDDS = new DDS(dataSet, (BaseTypeFactory)wfactory);
        wwwDDS.setURL(dataSet);
        StringWriter ddsSW = new StringWriter();
        sDDS.print(new PrintWriter(ddsSW));
        ByteArrayInputStream bai = null;
        try {
            bai = new ByteArrayInputStream(ddsSW.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new DAP2Exception("UTF-8 encoding not supported");
        }
        wwwDDS.parse((InputStream)bai);
        return wwwDDS;
    }
}

