/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_0_0_1;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.wcs.Request;
import thredds.server.wcs.v1_0_0_1.GetCapabilities;
import thredds.server.wcs.v1_0_0_1.WcsRequestBuilder;
import ucar.nc2.ft2.coverage.CoverageCollection;

public class GetCapabilitiesBuilder
extends WcsRequestBuilder {
    private Logger logger = LoggerFactory.getLogger(GetCapabilitiesBuilder.class);
    private URI serverUri;
    private GetCapabilities.Section section;
    private String updateSequence;
    private GetCapabilities.ServiceInfo serviceInfo;

    GetCapabilitiesBuilder(String versionString, Request.Operation operation, CoverageCollection dataset, String datasetPath) {
        super(versionString, operation, dataset, datasetPath);
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public GetCapabilitiesBuilder setServerUri(URI serverUri) {
        this.serverUri = serverUri;
        return this;
    }

    public GetCapabilities.Section getSection() {
        return this.section;
    }

    public GetCapabilitiesBuilder setSection(GetCapabilities.Section section) {
        this.section = section;
        return this;
    }

    public String getUpdateSequence() {
        return this.updateSequence;
    }

    public GetCapabilitiesBuilder setUpdateSequence(String updateSequence) {
        this.updateSequence = updateSequence;
        return this;
    }

    public GetCapabilities.ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public GetCapabilitiesBuilder setServiceInfo(GetCapabilities.ServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
        return this;
    }

    public GetCapabilities buildGetCapabilities() {
        if (this.serverUri == null) {
            throw new IllegalStateException("Null server URI not allowed.");
        }
        if (this.section == null) {
            throw new IllegalStateException("Null section not allowed.");
        }
        return new GetCapabilities(this.getOperation(), this.getVersionString(), this.getWcsDataset(), this.serverUri, this.section, this.updateSequence, this.serviceInfo);
    }
}

