/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.notebook;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.client.catalog.Dataset;
import thredds.server.config.TdsContext;
import thredds.server.notebook.JupyterNotebookViewerService;
import thredds.server.notebook.NotebookMetadata;
import thredds.server.viewer.ViewerService;

@Component
public class JupyterNotebookServiceCache {
    private static final Logger logger = LoggerFactory.getLogger(JupyterNotebookServiceCache.class);
    @Autowired
    TdsContext tdsContext;
    @Autowired
    ViewerService viewerService;
    private Set<NotebookMetadata> allNotebooks;
    private Cache<String, Set<NotebookMetadata>> notebookMappingCache;

    public void init(int maxAge, int maxSize) {
        this.allNotebooks = new HashSet<NotebookMetadata>();
        this.notebookMappingCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(maxAge)).maximumSize((long)maxSize).build();
        this.buildNotebookList();
        this.viewerService.registerViewers(new JupyterNotebookViewerService(this, this.tdsContext.getContentRootPathProperty()).getViewers());
    }

    public Set<NotebookMetadata> getMappedNotebooks(Dataset ds) {
        try {
            Set nbmd = (Set)this.notebookMappingCache.get((Object)ds.getID(), () -> this.getNotebookMapping(ds));
            return nbmd;
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return null;
        }
    }

    private void buildNotebookList() {
        File notebooksDir = new File(this.tdsContext.getThreddsDirectory(), "notebooks");
        if (notebooksDir.exists() && notebooksDir.isDirectory()) {
            File[] files;
            for (File notebookFile : files = notebooksDir.listFiles(pathname -> pathname.getName().endsWith(".ipynb"))) {
                try {
                    NotebookMetadata nb = new NotebookMetadata(notebookFile);
                    this.allNotebooks.add(nb);
                }
                catch (NotebookMetadata.InvalidJupyterNotebookException e) {
                    logger.warn(e.getMessage());
                }
                catch (FileNotFoundException e) {
                    logger.warn(e.getMessage());
                }
            }
        }
    }

    private Set<NotebookMetadata> getNotebookMapping(Dataset ds) {
        HashSet<NotebookMetadata> matches = new HashSet<NotebookMetadata>();
        for (NotebookMetadata nbmd : this.allNotebooks) {
            if (!nbmd.isValidForDataset(ds)) continue;
            matches.add(nbmd);
        }
        return matches;
    }

    public Set<NotebookMetadata> getAllNotebooks() {
        return this.allNotebooks;
    }
}

