/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.core.TdsRequestedDataset;
import thredds.server.wcs.Request;
import thredds.server.wcs.v1_0_0_1.DescribeCoverage;
import thredds.server.wcs.v1_0_0_1.GetCapabilities;
import thredds.server.wcs.v1_0_0_1.GetCoverage;
import thredds.server.wcs.v1_0_0_1.WcsCoverage;
import thredds.server.wcs.v1_0_0_1.WcsDataset;
import thredds.server.wcs.v1_0_0_1.WcsException;
import thredds.server.wcs.v1_0_0_1.WcsRequest;
import thredds.servlet.ServletUtil;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;

public class WcsRequestParser {
    private static Logger log = LoggerFactory.getLogger(WcsRequestParser.class);

    public static WcsRequest parseRequest(String version, URI serverURI, HttpServletRequest req, HttpServletResponse res) throws WcsException, IOException {
        TdsRequestedDataset trd = new TdsRequestedDataset(req, "/wcs");
        CoverageCollection gridDataset = null;
        try {
            gridDataset = trd.openAsCoverageDataset(req, res);
            if (gridDataset == null) {
                return null;
            }
            WcsDataset wcsDataset = new WcsDataset(gridDataset, trd.getPath());
            String requestParam = ServletUtil.getParameterIgnoreCase(req, "Request");
            Request.Operation operation = WcsRequestParser.parseOperation(requestParam);
            if (operation == null) {
                log.debug("parseRequest(): Unsupported operation request [" + requestParam + "].");
                throw new WcsException(WcsException.Code.InvalidParameterValue, "Request", "Unsupported operation request [" + requestParam + "].");
            }
            if (operation.equals((Object)Request.Operation.GetCapabilities)) {
                GetCapabilities.Section section;
                String sectionParam = ServletUtil.getParameterIgnoreCase(req, "Section");
                String updateSequenceParam = ServletUtil.getParameterIgnoreCase(req, "UpdateSequence");
                if (sectionParam == null) {
                    sectionParam = "";
                }
                if ((section = WcsRequestParser.parseGetCapabilitiesSection(sectionParam)) == null) {
                    log.debug("parseRequest(): Unsupported GetCapabilities section requested [" + sectionParam + "].");
                    throw new WcsException(WcsException.Code.InvalidParameterValue, "Section", "Unsupported GetCapabilities section requested [" + sectionParam + "].");
                }
                return new GetCapabilities(operation, version, wcsDataset, serverURI, section, updateSequenceParam, null);
            }
            if (operation.equals((Object)Request.Operation.DescribeCoverage)) {
                List<String> coverageIdList;
                String coverageIdListParam = ServletUtil.getParameterIgnoreCase(req, "Coverage");
                if (coverageIdListParam != null) {
                    coverageIdList = WcsRequestParser.splitCommaSeparatedList(coverageIdListParam);
                } else {
                    coverageIdList = new ArrayList<String>();
                    for (WcsCoverage curCov : wcsDataset.getAvailableCoverageCollection()) {
                        coverageIdList.add(curCov.getName());
                    }
                }
                return new DescribeCoverage(operation, version, wcsDataset, coverageIdList);
            }
            if (operation.equals((Object)Request.Operation.GetCoverage)) {
                String coverageId = ServletUtil.getParameterIgnoreCase(req, "Coverage");
                String crs = ServletUtil.getParameterIgnoreCase(req, "CRS");
                String responseCRS = ServletUtil.getParameterIgnoreCase(req, "RESPONSE_CRS");
                String bbox = ServletUtil.getParameterIgnoreCase(req, "BBOX");
                String time = ServletUtil.getParameterIgnoreCase(req, "TIME");
                String parameter = ServletUtil.getParameterIgnoreCase(req, "Vertical");
                String formatString = ServletUtil.getParameterIgnoreCase(req, "FORMAT");
                WcsCoverage.VerticalRange verticalRange = WcsRequestParser.parseRangeSetAxisValues(parameter);
                if (formatString == null) {
                    log.debug("parseRequest(): FORMAT parameter required.");
                    throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", "FORMAT parameter required.");
                }
                Request.Format format = WcsRequestParser.parseFormat(formatString);
                if (format == null) {
                    String msg = "Unrecognized FORMAT parameter value [" + formatString + "].";
                    log.debug("parseRequest(): " + msg);
                    throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", msg);
                }
                return new GetCoverage(operation, version, wcsDataset, coverageId, crs, responseCRS, WcsRequestParser.parseBoundingBox(bbox), WcsRequestParser.parseTime(time), verticalRange, format);
            }
            log.debug("parseRequest(): Invalid request operation [" + requestParam + "].");
            throw new WcsException(WcsException.Code.InvalidParameterValue, "Request", "Invalid requested operation [" + requestParam + "].");
        }
        catch (Throwable t) {
            if (gridDataset != null) {
                gridDataset.close();
            }
            throw t;
        }
    }

    private static Request.Operation parseOperation(String operationString) {
        Request.Operation[] ops;
        for (Request.Operation curOp : ops = Request.Operation.values()) {
            if (!curOp.toString().equalsIgnoreCase(operationString)) continue;
            return curOp;
        }
        return null;
    }

    private static GetCapabilities.Section parseGetCapabilitiesSection(String sectionString) {
        GetCapabilities.Section[] sections;
        for (GetCapabilities.Section curSection : sections = GetCapabilities.Section.values()) {
            if (!curSection.toString().equalsIgnoreCase(sectionString)) continue;
            return curSection;
        }
        return null;
    }

    private static Request.Format parseFormat(String formatString) throws WcsException {
        Request.Format[] formats;
        for (Request.Format curFormat : formats = Request.Format.values()) {
            if (!curFormat.toString().equalsIgnoreCase(formatString)) continue;
            return curFormat;
        }
        return null;
    }

    private static Request.BoundingBox parseBoundingBox(String bboxString) throws WcsException {
        if (bboxString == null || bboxString.equals("")) {
            return null;
        }
        String[] bboxSplit = bboxString.split(",");
        if (bboxSplit.length != 4) {
            String msg = "BBOX [" + bboxString + "] has more values [" + bboxSplit.length + "] than expected [4] (not limited to X and Y).";
            log.debug("parseBoundingBox(): " + msg);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "BBOX", msg);
        }
        double[] minP = new double[2];
        double[] maxP = new double[2];
        try {
            minP[0] = Double.parseDouble(bboxSplit[0]);
            minP[1] = Double.parseDouble(bboxSplit[1]);
            maxP[0] = Double.parseDouble(bboxSplit[2]);
            maxP[1] = Double.parseDouble(bboxSplit[3]);
        }
        catch (NumberFormatException e) {
            String msg = "BBOX [" + bboxString + "] contains an invalid number(s).";
            log.debug("parseBoundingBox(): " + msg);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "BBOX", msg);
        }
        if (minP[0] > maxP[0] || minP[1] > maxP[1]) {
            String msg = "BBOX [" + bboxString + "] minimum point larger than maximum point.";
            log.debug("parseBoundingBox(): " + msg);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "BBOX", msg);
        }
        return new Request.BoundingBox(minP, maxP);
    }

    private static CalendarDateRange parseTime(String time) throws WcsException {
        CalendarDateRange dateRange;
        if (time == null || time.equals("")) {
            return null;
        }
        if (time.contains(",")) {
            log.debug("parseTime(): Unsupported time parameter (list) [" + time + "].");
            throw new WcsException(WcsException.Code.InvalidParameterValue, "TIME", "Not currently supporting time list.");
        }
        if (time.contains("/")) {
            String[] timeRange = time.split("/");
            if (timeRange.length != 2) {
                log.debug("parseTime(): Unsupported time parameter (time range with resolution) [" + time + "].");
                throw new WcsException(WcsException.Code.InvalidParameterValue, "TIME", "Not currently supporting time range with resolution.");
            }
            dateRange = CalendarDateRange.of((CalendarDate)CalendarDate.parseISOformat(null, (String)timeRange[0]), (CalendarDate)CalendarDate.parseISOformat(null, (String)timeRange[1]));
        } else {
            CalendarDate date = CalendarDate.parseISOformat(null, (String)time);
            dateRange = CalendarDateRange.of((CalendarDate)date, (CalendarDate)date);
        }
        return dateRange;
    }

    private static WcsCoverage.VerticalRange parseRangeSetAxisValues(String rangeSetAxisSelectionString) throws WcsException {
        WcsCoverage.VerticalRange range;
        if (rangeSetAxisSelectionString == null || rangeSetAxisSelectionString.equals("")) {
            return null;
        }
        if (rangeSetAxisSelectionString.contains(",")) {
            log.debug("parseRangeSetAxisValues(): Vertical value list not supported [" + rangeSetAxisSelectionString + "].");
            throw new WcsException(WcsException.Code.InvalidParameterValue, "Vertical", "Not currently supporting list of Vertical values (just range, i.e., \"min/max\").");
        }
        if (rangeSetAxisSelectionString.contains("/")) {
            String[] rangeSplit = rangeSetAxisSelectionString.split("/");
            if (rangeSplit.length != 2) {
                log.debug("parseRangeSetAxisValues(): Unsupported Vertical value (range with resolution) [" + rangeSetAxisSelectionString + "].");
                throw new WcsException(WcsException.Code.InvalidParameterValue, "Vertical", "Not currently supporting vertical range with resolution.");
            }
            double minValue = 0.0;
            double maxValue = 0.0;
            try {
                minValue = Double.parseDouble(rangeSplit[0]);
                maxValue = Double.parseDouble(rangeSplit[1]);
            }
            catch (NumberFormatException e) {
                log.debug("parseRangeSetAxisValues(): Failed to parse Vertical range min or max [" + rangeSetAxisSelectionString + "]: " + e.getMessage());
                throw new WcsException(WcsException.Code.InvalidParameterValue, "Vertical", "Failed to parse Vertical range min or max.");
            }
            if (minValue > maxValue) {
                log.debug("parseRangeSetAxisValues(): Vertical range must be \"min/max\" [" + rangeSetAxisSelectionString + "].");
                throw new WcsException(WcsException.Code.InvalidParameterValue, "Vertical", "Vertical range must be \"min/max\".");
            }
            range = new WcsCoverage.VerticalRange(minValue, maxValue, 1);
        } else {
            double value = 0.0;
            try {
                value = Double.parseDouble(rangeSetAxisSelectionString);
            }
            catch (NumberFormatException e) {
                log.debug("parseRangeSetAxisValues(): Failed to parse Vertical value [" + rangeSetAxisSelectionString + "]: " + e.getMessage());
                throw new WcsException(WcsException.Code.InvalidParameterValue, "Vertical", "Failed to parse Vertical value.");
            }
            range = new WcsCoverage.VerticalRange(value, 1);
        }
        return range;
    }

    private static List<String> splitCommaSeparatedList(String identifiers) {
        String[] idArray;
        ArrayList<String> idList = new ArrayList<String>();
        for (String anIdArray : idArray = identifiers.split(",")) {
            idList.add(anIdArray.trim());
        }
        return idList;
    }
}

