/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import com.google.common.base.Preconditions;
import javax.servlet.http.HttpServletRequest;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.write.NetcdfFileFormat;

public class TdsPathUtils {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static String extractPath(HttpServletRequest req, String removePrefix) {
        String dataPath = req.getPathInfo();
        if (dataPath == null) {
            dataPath = req.getServletPath();
        }
        if (dataPath == null) {
            return "";
        }
        if (removePrefix != null) {
            if (dataPath.startsWith(removePrefix)) {
                dataPath = dataPath.substring(removePrefix.length());
            } else if (dataPath.startsWith("/") && (dataPath = dataPath.substring(1)).startsWith(removePrefix)) {
                dataPath = dataPath.substring(removePrefix.length());
            }
        }
        if (dataPath.startsWith("/")) {
            dataPath = dataPath.substring(1);
        }
        if (dataPath.contains("..")) {
            throw new IllegalArgumentException("path cannot contain '..'");
        }
        return dataPath;
    }

    public static String extractPath(HttpServletRequest req, String removePrefix, String[] endings) {
        String path = TdsPathUtils.extractPath(req, removePrefix);
        if (endings == null) {
            return path;
        }
        for (String ending : endings) {
            if (!path.endsWith(ending)) continue;
            int len = path.length() - ending.length();
            path = path.substring(0, len);
            break;
        }
        return path;
    }

    public static String getFileNameForResponse(String pathInfo, NetcdfFileWriter.Version version) {
        Preconditions.checkNotNull((Object)version, (Object)"version == null");
        return TdsPathUtils.getFileNameForResponse(pathInfo, version.getSuffix());
    }

    public static String getSuffix(NetcdfFileFormat format) {
        Preconditions.checkNotNull((Object)format, (Object)"format == null");
        switch (format) {
            case NETCDF4: {
                return ".nc4";
            }
            case NCSTREAM: {
                return ".ncs";
            }
        }
        return ".nc";
    }

    public static String getFileNameForResponse(String pathInfo, NetcdfFileFormat format) {
        Preconditions.checkNotNull((Object)format, (Object)"format == null");
        return TdsPathUtils.getFileNameForResponse(pathInfo, TdsPathUtils.getSuffix(format));
    }

    public static String getFileNameForResponse(String pathInfo, String extension) {
        Object dotExtension;
        Preconditions.checkArgument((pathInfo != null && !pathInfo.isEmpty() ? 1 : 0) != 0, (String)"pathInfo == %s", (Object)pathInfo);
        Preconditions.checkNotNull((Object)extension, (Object)"extension == null");
        String parentDirName = TdsPathUtils.getBaseName(TdsPathUtils.doGetPath(pathInfo, 0));
        String baseName = TdsPathUtils.getBaseName(pathInfo);
        Object object = dotExtension = extension.startsWith(".") ? extension : "." + extension;
        if (!parentDirName.isEmpty()) {
            return parentDirName + "_" + baseName + (String)dotExtension;
        }
        return baseName + (String)dotExtension;
    }

    private static String getBaseName(String filename) {
        return TdsPathUtils.removeExtension(TdsPathUtils.getName(filename));
    }

    private static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = TdsPathUtils.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    private static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = TdsPathUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = TdsPathUtils.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    private static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    private static String doGetPath(String filename, int separatorAdd) {
        if (filename == null) {
            return null;
        }
        int prefix = TdsPathUtils.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        int index = TdsPathUtils.indexOfLastSeparator(filename);
        int endIndex = index + separatorAdd;
        if (prefix >= filename.length() || index < 0 || prefix >= endIndex) {
            return "";
        }
        return filename.substring(prefix, endIndex);
    }

    private static int getPrefixLength(String filename) {
        if (filename == null) {
            return -1;
        }
        int len = filename.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = filename.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return TdsPathUtils.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = filename.indexOf(47, 1);
            int posWin = filename.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = filename.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !TdsPathUtils.isSeparator(filename.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (TdsPathUtils.isSeparator(ch0) && TdsPathUtils.isSeparator(ch1)) {
            int posUnix = filename.indexOf(47, 2);
            int posWin = filename.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        return TdsPathUtils.isSeparator(ch0) ? 1 : 0;
    }

    private static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }
}

