/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.util.filesource.BasicDescendantFileSource;
import thredds.util.filesource.FileSource;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

@Component(value="TdsContext")
public final class TdsContext
implements ServletContextAware,
InitializingBean,
DisposableBean {
    private final Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    @Value(value="${tds.version}")
    private String tdsVersion;
    @Value(value="${tds.version.builddate}")
    private String tdsVersionBuildDate;
    @Value(value="${tds.content.path}")
    private String contentPathProperty;
    @Value(value="${tds.content.startup.path}")
    private String contentStartupPathProperty;
    @Value(value="${tds.config.file}")
    private String configFileProperty;
    @Value(value="${tds.content.root.path}")
    private String contentRootPathProperty;
    @Value(value="${tds.debug.flags:}")
    private String tdsDebugFlagsProperty;
    private ServletContext servletContext;
    private String contextPath;
    private String webappDisplayName;
    private File servletRootDirectory;
    private File contentRootDir;
    private File threddsDirectory;
    private File publicContentDirectory;
    private File startupContentDirectory;
    private File tomcatLogDir;
    private FileSource publicContentDirSource;
    private RequestDispatcher defaultRequestDispatcher;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void destroy() {
    }

    public void afterPropertiesSet() {
        Object msg;
        if (this.servletContext == null) {
            throw new IllegalArgumentException("ServletContext must not be null.");
        }
        this.webappDisplayName = this.servletContext.getServletContextName();
        this.contextPath = this.servletContext.getContextPath();
        InvDatasetFeatureCollection.setContextName(this.contextPath);
        String rootPath = this.servletContext.getRealPath("/");
        if (rootPath == null) {
            String msg2 = "Webapp [" + this.webappDisplayName + "] must run with exploded deployment directory (not from .war).";
            this.logServerStartup.error("TdsContext.init(): " + msg2);
            throw new IllegalStateException(msg2);
        }
        this.servletRootDirectory = new File(rootPath);
        this.startupContentDirectory = new File(this.servletRootDirectory, this.contentStartupPathProperty);
        BasicDescendantFileSource startupContentDirSource = new BasicDescendantFileSource(this.startupContentDirectory);
        this.startupContentDirectory = startupContentDirSource.getRootDirectory();
        try {
            String base = System.getProperty("catalina.base");
            if (base != null) {
                this.tomcatLogDir = new File(base, "logs").getCanonicalFile();
                if (!this.tomcatLogDir.exists()) {
                    msg = "'catalina.base' directory not found: " + this.tomcatLogDir;
                    this.logServerStartup.error("TdsContext.init(): " + (String)msg);
                }
            } else {
                msg = "'catalina.base' property not found - probably not a tomcat server";
                this.logServerStartup.warn("TdsContext.init(): " + (String)msg);
            }
        }
        catch (IOException e) {
            msg = "tomcatLogDir could not be created";
            this.logServerStartup.error("TdsContext.init(): " + (String)msg);
        }
        String contentRootPathKey = "tds.content.root.path";
        if (this.contentRootPathProperty.equals("${tds.content.root.path}")) {
            String message = String.format("\"%s\" property isn't defined.", contentRootPathKey);
            this.logServerStartup.error(message);
            throw new IllegalStateException(message);
        }
        this.contentRootPathProperty = StringUtil2.replace((String)this.contentRootPathProperty, (String)"\\", (String)"/");
        if (!this.contentRootPathProperty.endsWith("/")) {
            this.contentRootPathProperty = this.contentRootPathProperty + "/";
        }
        this.contentRootDir = new File(this.contentRootPathProperty);
        if (!this.contentRootDir.isAbsolute()) {
            this.threddsDirectory = new File(new File(this.servletRootDirectory, this.contentRootPathProperty), this.contentPathProperty);
        } else if (this.contentRootDir.isDirectory()) {
            this.threddsDirectory = new File(this.contentRootDir, this.contentPathProperty);
        } else {
            msg = "Content root directory [" + this.contentRootPathProperty + "] not a directory.";
            this.logServerStartup.error("TdsContext.init(): " + (String)msg);
            throw new IllegalStateException((String)msg);
        }
        if (!this.threddsDirectory.isDirectory()) {
            String message = String.format("TdsContext.init(): Content directory is not a directory: %s", this.threddsDirectory.getAbsolutePath());
            this.logServerStartup.error(message);
            throw new IllegalStateException(message);
        }
        BasicDescendantFileSource contentDirSource = new BasicDescendantFileSource(StringUtils.cleanPath((String)this.threddsDirectory.getAbsolutePath()));
        this.threddsDirectory = contentDirSource.getRootDirectory();
        this.publicContentDirectory = new File(this.threddsDirectory, "public");
        if (!this.publicContentDirectory.exists() && !this.publicContentDirectory.mkdirs()) {
            String msg3 = "Couldn't create TDS public directory [" + this.publicContentDirectory.getPath() + "].";
            this.logServerStartup.error("TdsContext.init(): " + msg3);
            throw new IllegalStateException(msg3);
        }
        this.publicContentDirSource = new BasicDescendantFileSource(this.publicContentDirectory);
        File templatesDirectory = new File(this.threddsDirectory, "templates");
        if (!templatesDirectory.exists() && !templatesDirectory.mkdir()) {
            String msg4 = "Couldn't create TDS templates directory [" + templatesDirectory.getPath() + "].";
            this.logServerStartup.error("TdsContext.init(): " + msg4);
            throw new IllegalStateException(msg4);
        }
        File notebooksDirectory = new File(this.threddsDirectory, "notebooks");
        if (!notebooksDirectory.exists() && !notebooksDirectory.mkdir()) {
            String msg5 = "Couldn't create TDS notebooks directory [" + notebooksDirectory.getPath() + "].";
            this.logServerStartup.error("TdsContext.init(): " + msg5);
            throw new IllegalStateException(msg5);
        }
        this.defaultRequestDispatcher = this.servletContext.getNamedDispatcher("default");
        try {
            File customTemplateFragmentsFile;
            File wmsConfigXmlFile;
            File threddsConfigFile;
            File catalogFile;
            File threddsDirReadMe;
            File rootDirReadMe = new File(this.contentRootDir, "README.txt");
            if (!rootDirReadMe.exists()) {
                File defaultRootDirReadMeFile = new File(this.startupContentDirectory, "root_README.txt");
                this.logServerStartup.info("TdsContext.init(): Copying root README file from {}.", (Object)defaultRootDirReadMeFile);
                IO.copyFile((File)defaultRootDirReadMeFile, (File)rootDirReadMe);
            }
            if (!(threddsDirReadMe = new File(this.threddsDirectory, "README.txt")).exists()) {
                File defaultThreddsDirReadMeFile = new File(this.startupContentDirectory, "thredds_README.txt");
                this.logServerStartup.info("TdsContext.init(): Copying thredds README file from {}.", (Object)defaultThreddsDirReadMeFile);
                IO.copyFile((File)defaultThreddsDirReadMeFile, (File)threddsDirReadMe);
            }
            if (!(catalogFile = new File(this.threddsDirectory, "catalog.xml")).exists()) {
                File defaultCatalogFile = new File(this.startupContentDirectory, "catalog.xml");
                this.logServerStartup.info("TdsContext.init(): Copying default catalog file from {}.", (Object)defaultCatalogFile);
                IO.copyFile((File)defaultCatalogFile, (File)catalogFile);
                File enhancedCatalogFile = new File(this.threddsDirectory, "enhancedCatalog.xml");
                File defaultEnhancedCatalogFile = new File(this.startupContentDirectory, "enhancedCatalog.xml");
                this.logServerStartup.info("TdsContext.init(): Copying default enhanced catalog file from {}.", (Object)defaultEnhancedCatalogFile);
                IO.copyFile((File)defaultEnhancedCatalogFile, (File)enhancedCatalogFile);
                File dataDir = new File(new File(this.threddsDirectory, "public"), "testdata");
                File defaultDataDir = new File(new File(this.startupContentDirectory, "public"), "testdata");
                this.logServerStartup.info("TdsContext.init(): Copying default testdata directory from {}.", (Object)defaultDataDir);
                IO.copyDirTree((String)defaultDataDir.getCanonicalPath(), (String)dataDir.getCanonicalPath());
            }
            if (!(threddsConfigFile = new File(this.threddsDirectory, "threddsConfig.xml")).exists()) {
                File defaultThreddsConfigFile = new File(this.startupContentDirectory, "threddsConfig.xml");
                this.logServerStartup.info("TdsContext.init(): Copying default THREDDS config file from {}.", (Object)defaultThreddsConfigFile);
                IO.copyFile((File)defaultThreddsConfigFile, (File)threddsConfigFile);
            }
            if (!(wmsConfigXmlFile = new File(this.threddsDirectory, "wmsConfig.xml")).exists()) {
                File defaultWmsConfigXmlFile = new File(this.startupContentDirectory, "wmsConfig.xml");
                this.logServerStartup.info("TdsContext.init(): Copying default WMS config file from {}.", (Object)defaultWmsConfigXmlFile);
                IO.copyFile((File)defaultWmsConfigXmlFile, (File)wmsConfigXmlFile);
            }
            if (!(customTemplateFragmentsFile = new File(templatesDirectory, "tdsTemplateFragments.html")).exists()) {
                File defaultTemplateFragmentsFile = new File(this.startupContentDirectory, "tdsTemplateFragments.html");
                this.logServerStartup.info("TdsContext.init(): Copying default template fragments file from {}.", (Object)defaultTemplateFragmentsFile);
                IO.copyFile((File)defaultTemplateFragmentsFile, (File)customTemplateFragmentsFile);
            }
            File startupNotebooks = new File(this.startupContentDirectory, "jupyter_notebooks");
            for (File defaultNotebook : startupNotebooks.listFiles()) {
                String fileName = defaultNotebook.getName();
                File jupyterViewer = new File(notebooksDirectory, fileName);
                if (jupyterViewer.exists()) continue;
                this.logServerStartup.info("TdsContext.init(): Copying default jupyter notebook file {}.", (Object)defaultNotebook);
                IO.copyFile((File)defaultNotebook, (File)jupyterViewer);
            }
        }
        catch (IOException e) {
            String message = String.format("Could not copy default startup files to %s.", this.threddsDirectory);
            this.logServerStartup.error("TdsContext.init(): " + message);
            throw new IllegalStateException(message, e);
        }
        File logDir = new File(this.threddsDirectory, "logs");
        if (!logDir.exists() && !logDir.mkdirs()) {
            String msg6 = "Couldn't create TDS log directory [" + logDir.getPath() + "].";
            this.logServerStartup.error("TdsContext.init(): " + msg6);
            throw new IllegalStateException(msg6);
        }
        String loggingDirectory = logDir.getPath().replace("\\", "/");
        System.setProperty("tds.log.dir", loggingDirectory);
        this.logServerStartup.info("TdsContext version= " + this.getVersionInfo());
        this.logServerStartup.info("TdsContext initialized logging in " + logDir.getPath());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TdsContext{");
        sb.append("\n  contextPath='").append(this.contextPath).append('\'');
        sb.append("\n  webappName='").append(this.webappDisplayName).append('\'');
        sb.append("\n  webappVersion='").append(this.tdsVersion).append('\'');
        sb.append("\n  webappVersionBuildDate='").append(this.tdsVersionBuildDate).append('\'');
        sb.append("\n");
        sb.append("\n  contentPath= '").append(this.contentPathProperty).append('\'');
        sb.append("\n  contentRootPath= '").append(this.contentRootPathProperty).append('\'');
        sb.append("\n  contentStartupPath= '").append(this.contentStartupPathProperty).append('\'');
        sb.append("\n  configFile= '").append(this.configFileProperty).append('\'');
        sb.append("\n");
        sb.append("\n  servletRootDir=   ").append(this.servletRootDirectory);
        sb.append("\n  contentRootDir=   ").append(this.contentRootDir);
        sb.append("\n  threddsDirectory= ").append(this.threddsDirectory);
        sb.append("\n  publicContentDir= ").append(this.publicContentDirectory);
        sb.append("\n  startupContentDir=").append(this.startupContentDirectory);
        sb.append("\n  tomcatLogDir=     ").append(this.tomcatLogDir);
        sb.append("\n");
        sb.append("\n  publicContentDirSource= ").append(this.publicContentDirSource);
        sb.append('}');
        return sb.toString();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getWebappVersion() {
        return this.tdsVersion;
    }

    public String getTdsVersionBuildDate() {
        return this.tdsVersionBuildDate;
    }

    public String getVersionInfo() {
        Formatter f = new Formatter();
        f.format("%s", this.getWebappVersion());
        if (this.getTdsVersionBuildDate() != null) {
            f.format(" - %s", this.getTdsVersionBuildDate());
        }
        return f.toString();
    }

    public String getWebappDisplayName() {
        return this.webappDisplayName;
    }

    public File getServletRootDirectory() {
        return this.servletRootDirectory;
    }

    public File getTomcatLogDirectory() {
        return this.tomcatLogDir;
    }

    public File getThreddsDirectory() {
        return this.threddsDirectory;
    }

    public File getContentRootDir() {
        return this.contentRootDir;
    }

    public FileSource getPublicContentDirSource() {
        return this.publicContentDirSource;
    }

    public RequestDispatcher getDefaultRequestDispatcher() {
        return this.defaultRequestDispatcher;
    }

    public String getContentRootPathProperty() {
        return this.contentRootPathProperty;
    }

    public String getConfigFileProperty() {
        return this.configFileProperty;
    }

    @Deprecated
    public File getUploadDir() {
        return null;
    }

    @Deprecated
    public File getDownloadDir() {
        return null;
    }

    @Deprecated
    public File getUploadForm() {
        return null;
    }

    @Deprecated
    public File getDownloadForm() {
        return null;
    }

    public String getTdsDebugFlags() {
        return this.tdsDebugFlagsProperty;
    }

    public void setContentRootPathProperty(String contentRootPathProperty) {
        this.contentRootPathProperty = contentRootPathProperty;
    }

    @Deprecated
    public void setUploadDirProperty(String uploadDirProperty) {
    }

    @Deprecated
    public void setDownloadDirProperty(String downloadDirProperty) {
    }

    @Deprecated
    public void setUploadFormProperty(String uploadFormProperty) {
    }

    @Deprecated
    public void setDownloadFormProperty(String downloadFormProperty) {
    }

    @Deprecated
    public File getPropertyDir(String prop, String key, boolean create) {
        return null;
    }

    @Deprecated
    public File getPropertyFile(String prop, String key, boolean writeable) {
        return null;
    }
}

