/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.dap4;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.servlet.DapController;
import dap4.servlet.DapRequest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.core.TdsRequestedDataset;
import thredds.server.config.TdsContext;

@Controller
@RequestMapping(value={"/dap4"})
public class Dap4Controller
extends DapController {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    static final String SERVICEID = "/dap4";
    @Autowired
    private TdsContext tdscontext;

    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        super.handleRequest(req, res);
    }

    protected void doFavicon(String icopath, DapContext cxt) throws IOException {
        throw new UnsupportedOperationException("Favicon");
    }

    protected void doCapabilities(DapRequest drq, DapContext cxt) throws IOException {
        this.addCommonHeaders(drq);
        OutputStream out = drq.getOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, DapUtil.UTF8));
        pw.println("Capabilities page not supported");
        pw.flush();
    }

    public long getBinaryWriteLimit() {
        return 100000000L;
    }

    public String getServletID() {
        StringBuilder id;
        String cp = this.tdscontext.getContextPath();
        if (cp == null || cp.length() == 0) {
            cp = "dap4";
        }
        if ((id = new StringBuilder(cp)).charAt(id.length() - 1) == '/') {
            id.deleteCharAt(id.length());
        }
        if (id.charAt(0) != '/') {
            id.insert(0, '/');
        }
        return id.toString();
    }

    public String getWebContentRoot(DapRequest drq) throws DapException {
        File root = this.tdscontext.getServletRootDirectory();
        if (!(root.exists() && root.canRead() && root.isDirectory())) {
            throw new DapException("Cannot locate WEB-INF root").setCode(404);
        }
        String rootpath = root.getAbsolutePath() + "/WEB-INF";
        return DapUtil.canonicalpath((String)rootpath);
    }

    public String getResourcePath(DapRequest drq, String location) throws DapException {
        String path;
        assert (location.charAt(0) == '/');
        if (location.startsWith(SERVICEID)) {
            location = location.substring(SERVICEID.length());
        }
        if ((path = TdsRequestedDataset.getLocationFromRequestPath(location)) == null || path.length() == 0) {
            throw new DapException(String.format("getLocationFromRequestPath: location=|%s| path=null", location, path)).setCode(404);
        }
        File f = new File(path);
        if (!(f.exists() && f.canRead() && f.isFile())) {
            throw new DapException("Cannot locate resource: " + location).setCode(404);
        }
        return DapUtil.canonicalpath((String)path);
    }
}

