/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.any_point;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import thredds.server.ncss.view.dsg.HttpHeaderWriter;
import thredds.server.ncss.view.dsg.any_point.AbstractMixedFeatureTypeSubsetWriter;
import thredds.server.ncss.view.dsg.point.PointSubsetWriterCSV;
import thredds.server.ncss.view.dsg.station.StationProfileSubsetWriterCSV;
import thredds.server.ncss.view.dsg.station.StationSubsetWriterCSV;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft2.coverage.SubsetParams;

public class MixedFeatureTypeSubsetWriterCSV
extends AbstractMixedFeatureTypeSubsetWriter {
    public MixedFeatureTypeSubsetWriterCSV(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out) throws NcssException, IOException, XMLStreamException {
        super(fdPoint, ncssParams, out);
        this.initWriters();
    }

    @Override
    DsgSubsetWriter newInstance(FeatureType featureType, int collectionIndex) throws NcssException, IOException {
        switch (featureType) {
            case POINT: {
                return new PointSubsetWriterCSV(this.fdPoint, this.ncssParams, this.out, collectionIndex);
            }
            case STATION: {
                return new StationSubsetWriterCSV(this.fdPoint, this.ncssParams, this.out, collectionIndex);
            }
            case STATION_PROFILE: {
                return new StationProfileSubsetWriterCSV(this.fdPoint, this.ncssParams, this.out, collectionIndex);
            }
        }
        throw new UnsupportedOperationException(String.format("%s feature type is not yet supported.", featureType));
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        return HttpHeaderWriter.getHttpHeadersForCSV(datasetPath, isStream);
    }

    @Override
    public void write() throws Exception {
        for (DsgSubsetWriter writer : this.writers) {
            writer.write();
        }
    }
}

