/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.controller.NcssDiskCache;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.HttpHeaderWriter;
import thredds.server.ncss.view.dsg.station.AbstractStationProfileSubsetWriter;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.ft.point.writer.WriterCFStationProfileCollection;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IO;

public class StationProfileSubsetWriterNetcdf
extends AbstractStationProfileSubsetWriter {
    private final OutputStream out;
    private final NetcdfFileWriter.Version version;
    private final File netcdfResult;
    private final WriterCFStationProfileCollection cfWriter;
    private final NcssDiskCache ncssDiskCache;

    public StationProfileSubsetWriterNetcdf(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, NcssDiskCache ncssDiskCache, OutputStream out, NetcdfFileWriter.Version version) throws NcssException, IOException {
        super(fdPoint, ncssParams);
        assert (fdPoint.getPointFeatureCollectionList().size() == 1) : "Multiple feature collections cannot be written as a CF dataset";
        this.ncssDiskCache = ncssDiskCache;
        this.out = out;
        this.version = version;
        this.netcdfResult = ncssDiskCache.getDiskCache().createUniqueFile("ncss-station", ".nc");
        ArrayList<Attribute> attribs = new ArrayList<Attribute>();
        attribs.add(new Attribute("title", "Extracted data from TDS Feature Collection " + fdPoint.getLocation()));
        String altUnits = this.stationFeatureCollection.getAltUnits();
        CalendarDateUnit timeUnit = this.stationFeatureCollection.getTimeUnit();
        if (timeUnit == null) {
            timeUnit = CalendarDateUnit.unixDateUnit;
        }
        this.cfWriter = new WriterCFStationProfileCollection(this.netcdfResult.getAbsolutePath(), attribs, this.wantedVariables, timeUnit, altUnits, new CFPointWriterConfig(version));
        this.cfWriter.setStations(this.wantedStations);
        int name_strlen = 0;
        int countProfiles = 0;
        for (StationFeature spf : this.stationFeatureCollection.getStationFeatures()) {
            assert (spf instanceof StationProfileFeature) : "Expected StationProfileFeature, not " + spf.getClass().toString();
            String name = spf.getName();
            if (this.wantedStations.stream().noneMatch(stn -> stn.getName().equals(name))) continue;
            if (this.wantedRange != null) {
                spf = ((StationProfileFeature)spf).subset(this.wantedRange);
            }
            name_strlen = Math.max(name_strlen, spf.getName().length());
            if (((StationProfileFeature)spf).size() >= 0) {
                countProfiles += ((StationProfileFeature)spf).size();
                continue;
            }
            for (ProfileFeature pf : (StationProfileFeature)spf) {
                ++countProfiles;
            }
        }
        this.cfWriter.setFeatureAuxInfo(countProfiles, name_strlen);
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        return HttpHeaderWriter.getHttpHeadersForNetcdf(datasetPath, this.ncssDiskCache, this.version);
    }

    @Override
    protected void writeHeader(StationProfileFeature stn) throws Exception {
        ArrayList<StationProfileFeature> asList = new ArrayList<StationProfileFeature>();
        asList.add(stn);
        this.cfWriter.writeHeader(asList);
    }

    @Override
    protected void writeProfileFeature(StationProfileFeature stn, ProfileFeature profileFeat) throws Exception {
        this.cfWriter.writeProfile(stn, profileFeat);
    }

    @Override
    protected void writeStationPointFeature(StationProfileFeature stn, StationPointFeature stationPointFeat) throws Exception {
        this.cfWriter.writeObsData((PointFeature)stationPointFeat);
    }

    @Override
    protected void writeFooter() throws Exception {
        this.cfWriter.finish();
        IO.copyFileB((File)this.netcdfResult, (OutputStream)this.out, (int)60000);
        this.out.flush();
    }
}

