/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImmutable;
import ucar.unidata.geoloc.LatLonRect;

@XmlRootElement(name="stationsList")
public class StationList {
    private Map<String, Station> stations = new TreeMap<String, Station>();

    public void loadFromXmlFile(String filename) {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(false);
        File f = new File(filename);
        try {
            Document doc = builder.build(f);
            Element list = doc.getRootElement();
            for (Element station : list.getChildren()) {
                Element loc = station.getChild("location3D");
                String stid = station.getAttributeValue("value");
                Station newStation = this.addStation(stid, LatLonPoint.create((double)Double.valueOf(loc.getAttributeValue("latitude")), (double)Double.valueOf(loc.getAttributeValue("longitude"))));
                newStation.setElevation(Double.valueOf(loc.getAttributeValue("elevation")));
                newStation.setName(station.getAttributeValue("name"));
                newStation.setState(station.getAttributeValue("state"));
                newStation.setCountry(station.getAttributeValue("country"));
            }
        }
        catch (IOException | JDOMException e) {
            e.printStackTrace();
        }
    }

    public Station addStation(String stid, LatLonPoint loc) {
        Station added = new Station(stid, (LatLonPoint)new LatLonPointImmutable(loc));
        this.stations.put(stid, added);
        return added;
    }

    public Station getNearest(double longitude, double latitude) {
        LatLonPointImmutable pt = new LatLonPointImmutable(latitude, longitude);
        Station nearest = null;
        double minDist = Double.POSITIVE_INFINITY;
        for (Station s : this.stations.values()) {
            Bearing b = Bearing.calculateBearing((LatLonPoint)pt, (LatLonPoint)s.location);
            if (!(b.getDistance() < minDist)) continue;
            minDist = b.getDistance();
            nearest = s;
        }
        return nearest;
    }

    public List<Station> getStations(double east, double west, double north, double south) {
        LatLonRect rect = new LatLonRect((LatLonPoint)new LatLonPointImmutable(south, west), (LatLonPoint)new LatLonPointImmutable(north, east));
        ArrayList<Station> result = new ArrayList<Station>();
        for (Station s : this.stations.values()) {
            if (!rect.contains((LatLonPoint)s.location)) continue;
            result.add(s);
        }
        return result;
    }

    @XmlElement(name="station")
    public Collection<Station> getAll() {
        return this.stations.values();
    }

    public Station get(String stid) {
        return this.stations.get(stid);
    }

    @XmlRootElement(name="station")
    public static class Station {
        private LatLonPointImmutable location;
        private String stid;
        private String name;
        private String state;
        private String country;
        private double elevation;

        public Station() {
            this.stid = "UNK";
            this.name = "Unnamed";
        }

        public Station(String stid, LatLonPoint loc) {
            this.stid = stid;
            this.location = new LatLonPointImmutable(loc);
            this.name = "Unnamed";
        }

        @XmlAttribute(name="id")
        @XmlID
        String getStid() {
            return this.stid;
        }

        void setStid(String stid) {
            this.stid = stid;
        }

        LatLonPoint getLocation() {
            return this.location;
        }

        void setLocation(LatLonPointImmutable loc) {
            this.location = loc;
        }

        @XmlElement(name="longitude")
        double getLongitude() {
            return this.location.getLongitude();
        }

        @XmlElement(name="latitude")
        double getLatitude() {
            return this.location.getLatitude();
        }

        @XmlElement(name="elevation")
        double getElevation() {
            return this.elevation;
        }

        void setElevation(double elev) {
            this.elevation = elev;
        }

        @XmlElement(name="name")
        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        @XmlAttribute(name="state")
        String getState() {
            return this.state;
        }

        void setState(String state) {
            this.state = state;
        }

        @XmlAttribute(name="country")
        String getCountry() {
            return this.country;
        }

        void setCountry(String country) {
            this.country = country;
        }
    }
}

