/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.viewer;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Property;
import thredds.server.viewer.Viewer;
import thredds.server.viewer.ViewerLinkProvider;
import thredds.server.viewer.ViewerService;
import thredds.server.wms.Godiva3Viewer;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

@Component
public class ViewerServiceImpl
implements ViewerService,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(ViewerServiceImpl.class);
    private List<Viewer> viewers = new ArrayList<Viewer>();
    private HashMap<String, String> templates = new HashMap();
    private static final String propertyNamePrefix = "viewer";

    public static ViewerLinkProvider getStaticView() {
        return new StaticView();
    }

    @Override
    public List<Viewer> getViewers() {
        return null;
    }

    @Override
    public Viewer getViewer(String viewer) {
        return null;
    }

    @Override
    public boolean registerViewer(Viewer v) {
        return this.viewers.add(v);
    }

    @Override
    public boolean registerViewers(List<Viewer> v) {
        return this.viewers.addAll(v);
    }

    @Override
    @Deprecated
    public String getViewerTemplate(String path) {
        String template = this.templates.get(path);
        if (template != null) {
            return template;
        }
        try {
            template = IO.readFile((String)path);
        }
        catch (IOException ioe) {
            return null;
        }
        this.templates.put(path, template);
        return template;
    }

    @Override
    public void showViewers(Formatter out, Dataset dataset, HttpServletRequest req) {
        int count = 0;
        for (Viewer viewer : this.viewers) {
            if (!viewer.isViewable(dataset)) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        out.format("<h3>Viewers:</h3><ul>\r\n", new Object[0]);
        for (Viewer viewer : this.viewers) {
            if (!viewer.isViewable(dataset)) continue;
            if (viewer instanceof ViewerLinkProvider) {
                List<ViewerLinkProvider.ViewerLink> sp = ((ViewerLinkProvider)viewer).getViewerLinks(dataset, req);
                for (ViewerLinkProvider.ViewerLink vl : sp) {
                    if (vl.getUrl() == null || vl.getUrl().equals("")) continue;
                    out.format("<li><a href='%s'>%s</a></li>\r\n", vl.getUrl(), vl.getTitle() != null ? vl.getTitle() : vl.getUrl());
                }
                continue;
            }
            String viewerLinkHtml = viewer.getViewerLinkHtml(dataset, req);
            if (viewerLinkHtml == null) continue;
            out.format("  <li> %s</li>\r\n", viewerLinkHtml);
        }
        out.format("</ul>\r\n", new Object[0]);
    }

    @Override
    public List<ViewerLinkProvider.ViewerLink> getViewerLinks(Dataset dataset, HttpServletRequest req) {
        ArrayList<ViewerLinkProvider.ViewerLink> viewerLinks = new ArrayList<ViewerLinkProvider.ViewerLink>();
        for (Viewer viewer : this.viewers) {
            if (!viewer.isViewable(dataset)) continue;
            if (viewer instanceof ViewerLinkProvider) {
                viewerLinks.addAll(((ViewerLinkProvider)viewer).getViewerLinks(dataset, req));
                continue;
            }
            viewerLinks.add(viewer.getViewerLink(dataset, req));
        }
        return viewerLinks;
    }

    public void afterPropertiesSet() {
        this.registerViewer(new Godiva3Viewer());
        this.registerViewer(new StaticView());
    }

    private static class StaticView
    implements ViewerLinkProvider {
        private StaticView() {
        }

        @Override
        public boolean isViewable(Dataset ds) {
            return this.hasViewerProperties(ds);
        }

        @Override
        public String getViewerLinkHtml(Dataset ds, HttpServletRequest req) {
            List<ViewerLinkProvider.ViewerLink> viewerLinks = this.getViewerLinks(ds, req);
            if (viewerLinks.isEmpty()) {
                return null;
            }
            ViewerLinkProvider.ViewerLink firstLink = viewerLinks.get(0);
            return "<a href='" + firstLink.getUrl() + "'>" + firstLink.getTitle() + "</a>";
        }

        @Override
        public ViewerLinkProvider.ViewerLink getViewerLink(Dataset ds, HttpServletRequest req) {
            List<ViewerLinkProvider.ViewerLink> viewerLinks = this.getViewerLinks(ds, req);
            if (viewerLinks.isEmpty()) {
                return null;
            }
            return viewerLinks.get(0);
        }

        @Override
        public List<ViewerLinkProvider.ViewerLink> getViewerLinks(Dataset ds, HttpServletRequest req) {
            List<Property> viewerProperties = this.findViewerProperties(ds);
            if (viewerProperties.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ViewerLinkProvider.ViewerLink> result = new ArrayList<ViewerLinkProvider.ViewerLink>();
            for (Property p : viewerProperties) {
                ViewerLinkProvider.ViewerLink viewerLink = this.parseViewerPropertyValue(p.getName(), p.getValue(), ds);
                if (viewerLink == null) continue;
                result.add(viewerLink);
            }
            return result;
        }

        private ViewerLinkProvider.ViewerLink parseViewerPropertyValue(String viewerName, String viewerValue, Dataset ds) {
            String viewerTitle;
            String[] viewerLinkParts = viewerValue.split(",");
            String viewerUrl = viewerLinkParts[0];
            if (viewerUrl.isEmpty()) {
                return null;
            }
            viewerUrl = this.sub(viewerUrl, ds);
            int nParts = viewerLinkParts.length;
            String string = viewerTitle = nParts > 1 ? viewerLinkParts[1] : viewerName;
            if (viewerTitle.isEmpty()) {
                viewerTitle = viewerName;
            }
            String description = nParts > 2 ? viewerLinkParts[2] : "";
            ViewerLinkProvider.ViewerLink.ViewerType viewerType = nParts > 3 ? this.parseViewerType(viewerLinkParts[3]) : ViewerLinkProvider.ViewerLink.ViewerType.Unknown;
            return new ViewerLinkProvider.ViewerLink(viewerTitle, viewerUrl, description, viewerType);
        }

        private ViewerLinkProvider.ViewerLink.ViewerType parseViewerType(String type) {
            try {
                return ViewerLinkProvider.ViewerLink.ViewerType.valueOf(type);
            }
            catch (IllegalArgumentException ex) {
                return ViewerLinkProvider.ViewerLink.ViewerType.Unknown;
            }
        }

        private boolean hasViewerProperties(Dataset ds) {
            for (Property p : ds.getProperties()) {
                if (!p.getName().startsWith(ViewerServiceImpl.propertyNamePrefix)) continue;
                return true;
            }
            return false;
        }

        private List<Property> findViewerProperties(Dataset ds) {
            ArrayList<Property> result = new ArrayList<Property>();
            for (Property p : ds.getProperties()) {
                if (!p.getName().startsWith(ViewerServiceImpl.propertyNamePrefix)) continue;
                result.add(p);
            }
            return result;
        }

        private String sub(String org, Dataset ds) {
            URI uri;
            Access acc2;
            List access = ds.getAccess();
            if (access.size() == 0) {
                return org;
            }
            for (Access acc2 : access) {
                URI uri2;
                String sname = "{" + acc2.getService().getServiceTypeName() + "}";
                if (!org.contains(sname) || (uri2 = acc2.getStandardUri()) == null) continue;
                return StringUtil2.substitute((String)org, (String)sname, (String)uri2.toString());
            }
            String sname = "{url}";
            if (org.contains(sname) && access.size() > 0 && (uri = (acc2 = (Access)access.get(0)).getStandardUri()) != null) {
                return StringUtil2.substitute((String)org, (String)sname, (String)uri.toString());
            }
            return org;
        }
    }
}

