/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.views;

import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templateresource.FileTemplateResource;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;
import thredds.server.config.TdsContext;

public class TdsExtensibleTemplateResolver
extends SpringResourceTemplateResolver
implements ApplicationContextAware {
    private static final String EXT_FRAG_PREFIX = "ext:";
    private static final int PREFIX_LENGTH = "ext:".length();
    private ApplicationContext applicationContext = null;

    protected TdsExtensibleTemplateResolver() {
        this.setCheckExistence(true);
        HashSet<String> resolvablePatterns = new HashSet<String>();
        resolvablePatterns.add("ext:*");
        this.setResolvablePatterns(resolvablePatterns);
    }

    protected String computeResourceName(IEngineConfiguration configuration, String ownerTemplate, String template, String prefix, String suffix, boolean forceSuffix, Map<String, String> templateAliases, Map<String, Object> templateResolutionAttributes) {
        Validate.notNull((Object)template, (String)"Template name cannot be null");
        if (!template.startsWith(EXT_FRAG_PREFIX)) {
            return template;
        }
        Object resourceName = template.substring(PREFIX_LENGTH);
        if (!StringUtils.isEmptyOrWhitespace((String)prefix)) {
            resourceName = prefix + (String)resourceName;
        }
        if (!StringUtils.isEmptyOrWhitespace((String)suffix)) {
            resourceName = (String)resourceName + suffix;
        }
        TdsContext tdsContext = (TdsContext)this.applicationContext.getBean("TdsContext");
        resourceName = tdsContext.getThreddsDirectory() + (String)resourceName;
        return resourceName;
    }

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        return new FileTemplateResource(resourceName, characterEncoding);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

