/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms.config;

import org.jdom2.Element;
import thredds.server.wms.config.WmsConfigException;
import uk.ac.rdg.resc.edal.domain.Extent;
import uk.ac.rdg.resc.edal.util.Extents;

public class LayerSettings {
    private Boolean allowFeatureInfo = null;
    private Extent<Float> defaultColorScaleRange = null;
    private String defaultPaletteName = null;
    private Boolean logScaling = null;
    private Boolean intervalTime = null;
    private Integer defaultNumColorBands = null;

    LayerSettings(Element parentElement) throws WmsConfigException {
        if (parentElement == null) {
            return;
        }
        this.allowFeatureInfo = LayerSettings.getBoolean(parentElement, "allowFeatureInfo");
        this.defaultColorScaleRange = LayerSettings.getRange(parentElement, "defaultColorScaleRange");
        this.defaultPaletteName = parentElement.getChildTextTrim("defaultPaletteName");
        if (this.defaultPaletteName != null && this.defaultPaletteName.isEmpty()) {
            throw new WmsConfigException("defaultPaletteName must contain a value");
        }
        this.defaultNumColorBands = LayerSettings.getInteger(parentElement, "defaultNumColorBands", (Extent<Integer>)Extents.newExtent((Object)5, (Object)250));
        this.logScaling = LayerSettings.getBoolean(parentElement, "logScaling");
        this.intervalTime = LayerSettings.getBoolean(parentElement, "intervalTime");
        if (this.intervalTime == null) {
            this.intervalTime = false;
        }
    }

    LayerSettings() {
    }

    private static Boolean getBoolean(Element parentElement, String childName) throws WmsConfigException {
        String str = parentElement.getChildTextTrim(childName);
        if (str == null) {
            return null;
        }
        if (str.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (str.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new WmsConfigException("Value of " + childName + " must be true or false");
    }

    private static Integer getInteger(Element parentElement, String childName, Extent<Integer> validRange) throws WmsConfigException {
        int val;
        String str = parentElement.getChildTextTrim(childName);
        if (str == null) {
            return null;
        }
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            throw new WmsConfigException(nfe);
        }
        if (val < (Integer)validRange.getLow()) {
            return (Integer)validRange.getLow();
        }
        if (val > (Integer)validRange.getHigh()) {
            return (Integer)validRange.getHigh();
        }
        return val;
    }

    private static Extent<Float> getRange(Element parentElement, String childName) throws WmsConfigException {
        String str = parentElement.getChildTextTrim(childName);
        if (str == null) {
            return null;
        }
        String[] els = str.split(" ");
        if (els.length != 2) {
            throw new WmsConfigException("Invalid range format");
        }
        try {
            float min = Float.parseFloat(els[0]);
            float max = Float.parseFloat(els[1]);
            return Extents.newExtent((Object)Float.valueOf(min), (Object)Float.valueOf(max));
        }
        catch (NumberFormatException nfe) {
            throw new WmsConfigException("Invalid floating-point value in range");
        }
    }

    public Boolean isAllowFeatureInfo() {
        return this.allowFeatureInfo;
    }

    public Extent<Float> getDefaultColorScaleRange() {
        return this.defaultColorScaleRange;
    }

    public String getDefaultPaletteName() {
        return this.defaultPaletteName;
    }

    public Boolean isLogScaling() {
        return this.logScaling;
    }

    @Deprecated
    public boolean isIntervalTime() {
        return this.intervalTime;
    }

    public Integer getDefaultNumColorBands() {
        return this.defaultNumColorBands;
    }

    void replaceNullValues(LayerSettings newSettings) {
        if (this.allowFeatureInfo == null) {
            this.allowFeatureInfo = newSettings.allowFeatureInfo;
        }
        if (this.defaultColorScaleRange == null) {
            this.defaultColorScaleRange = newSettings.defaultColorScaleRange;
        }
        if (this.defaultPaletteName == null) {
            this.defaultPaletteName = newSettings.defaultPaletteName;
        }
        if (this.logScaling == null) {
            this.logScaling = newSettings.logScaling;
        }
        if (this.intervalTime == null) {
            this.intervalTime = newSettings.intervalTime;
        }
        if (this.defaultNumColorBands == null) {
            this.defaultNumColorBands = newSettings.defaultNumColorBands;
        }
    }

    void setDefaultColorScaleRange(Extent<Float> defaultColorScaleRange) {
        this.defaultColorScaleRange = defaultColorScaleRange;
    }

    public String toString() {
        return String.format("allowFeatureInfo = %s, defaultColorScaleRange = %s, defaultPaletteName = %s, defaultNumColorBands = %s, logScaling = %s", this.allowFeatureInfo, this.defaultColorScaleRange, this.defaultPaletteName, this.defaultNumColorBands, this.logScaling);
    }
}

