/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.wms.ThreddsWmsCatalogue;
import thredds.server.wms.config.DatasetPathSettings;
import thredds.server.wms.config.LayerSettings;
import thredds.server.wms.config.StandardNameSettings;
import thredds.server.wms.config.WmsConfigException;
import ucar.nc2.units.SimpleUnit;
import uk.ac.rdg.resc.edal.domain.Extent;
import uk.ac.rdg.resc.edal.metadata.VariableMetadata;
import uk.ac.rdg.resc.edal.util.Extents;

public class WmsDetailedConfig {
    private static final Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private LayerSettings defaultSettings;
    private final Map<String, StandardNameSettings> standardNames = new HashMap<String, StandardNameSettings>();
    private final Map<String, DatasetPathSettings> datasetPaths = new HashMap<String, DatasetPathSettings>();

    private WmsDetailedConfig() {
    }

    @Nullable
    public static WmsDetailedConfig fromLocation(String wmsConfigFileLocation) {
        WmsDetailedConfig wmsConfig = null;
        boolean loadingFailure = true;
        try (FileInputStream in = new FileInputStream(wmsConfigFileLocation);){
            wmsConfig = WmsDetailedConfig.loadFromStream(in);
            loadingFailure = false;
        }
        catch (IOException e) {
            startupLog.warn("Cannot read wmsConfig.xml:");
            startupLog.warn(e.getMessage());
        }
        if (loadingFailure) {
            startupLog.info("Will try using the default wmsConfig.xml file shipped with the TDS war file.");
        }
        return wmsConfig;
    }

    public static WmsDetailedConfig loadFromStream(InputStream in) {
        WmsDetailedConfig wmsConfig = new WmsDetailedConfig();
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setXMLReaderFactory((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
            builder.setExpandEntities(false);
            Document doc = builder.build(in);
            XPathExpression defaultSettingsExpression = XPathFactory.instance().compile("/wmsConfig/global/defaults", Filters.element(), null, new Namespace[]{Namespace.NO_NAMESPACE});
            Element defaultSettingsEl = (Element)defaultSettingsExpression.evaluateFirst((Object)doc);
            wmsConfig.defaultSettings = new LayerSettings(defaultSettingsEl);
            XPathExpression standardNamesExpression = XPathFactory.instance().compile("/wmsConfig/global/standardNames/standardName", Filters.element(), null, new Namespace[]{Namespace.NO_NAMESPACE});
            List standardNamesList = standardNamesExpression.evaluate((Object)doc);
            for (Element standardNameEl : standardNamesList) {
                StandardNameSettings sns = new StandardNameSettings(standardNameEl);
                wmsConfig.standardNames.put(sns.getStandardName(), sns);
            }
            XPathExpression datasetPathsExpression = XPathFactory.instance().compile("/wmsConfig/overrides/datasetPath", Filters.element(), null, new Namespace[]{Namespace.NO_NAMESPACE});
            List datasetPathsList = datasetPathsExpression.evaluate((Object)doc);
            for (Element datasetPathEl : datasetPathsList) {
                DatasetPathSettings pathSettings = new DatasetPathSettings(datasetPathEl);
                wmsConfig.datasetPaths.put(pathSettings.getPathSpec(), pathSettings);
            }
        }
        catch (IOException e) {
            startupLog.warn("Cannot read wmsConfig.xml:");
            startupLog.warn(e.getMessage());
        }
        catch (JDOMException | WmsConfigException ex) {
            startupLog.warn("Cannot parse wmsConfig.xml:");
            startupLog.warn(ex.getMessage());
        }
        return wmsConfig;
    }

    public LayerSettings getSettings(ThreddsWmsCatalogue layer, VariableMetadata variableMetadata) {
        StandardNameSettings stdNameSettings;
        String standardName = variableMetadata.getParameter().getStandardName();
        String unit = variableMetadata.getParameter().getUnits();
        LayerSettings settings = new LayerSettings();
        String dsPath = layer.getTdsDatasetPath();
        DatasetPathSettings dpSettings = this.getBestDatasetPathMatch(dsPath);
        if (dpSettings != null) {
            LayerSettings pathDefaults;
            LayerSettings varSettings = dpSettings.getSettingsPerVariable().get(variableMetadata.getId());
            if (varSettings != null) {
                settings.replaceNullValues(varSettings);
            }
            if ((pathDefaults = dpSettings.getDefaultSettings()) != null) {
                settings.replaceNullValues(pathDefaults);
            }
        }
        if (standardName != null && (stdNameSettings = this.standardNames.get(standardName)) != null) {
            boolean defaultColorScaleRangeUnset = settings.getDefaultColorScaleRange() == null;
            settings.replaceNullValues(stdNameSettings.getSettings());
            if (defaultColorScaleRangeUnset && stdNameSettings.getSettings().getDefaultColorScaleRange() != null) {
                Extent<Float> newColorScaleRange = WmsDetailedConfig.convertUnits(stdNameSettings.getSettings().getDefaultColorScaleRange(), stdNameSettings.getUnits(), unit);
                settings.setDefaultColorScaleRange(newColorScaleRange);
            }
        }
        settings.replaceNullValues(this.defaultSettings);
        return settings;
    }

    @Nullable
    private static Extent<Float> convertUnits(Extent<Float> floatRange, String oldUnits, String newUnits) {
        SimpleUnit oldUnit = SimpleUnit.factory((String)oldUnits);
        SimpleUnit newUnit = SimpleUnit.factory((String)newUnits);
        if (oldUnit == null || newUnit == null) {
            return null;
        }
        try {
            return Extents.newExtent((Object)Float.valueOf((float)oldUnit.convertTo((double)((Float)floatRange.getLow()).floatValue(), newUnit)), (Object)Float.valueOf((float)oldUnit.convertTo((double)((Float)floatRange.getHigh()).floatValue(), newUnit)));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private DatasetPathSettings getBestDatasetPathMatch(String urlPath) {
        DatasetPathSettings settings = this.datasetPaths.get(urlPath);
        if (settings != null) {
            return settings;
        }
        int longestPatternMatchLength = 0;
        DatasetPathSettings bestMatch = null;
        for (DatasetPathSettings dpSettings : this.datasetPaths.values()) {
            if (!dpSettings.pathSpecMatches(urlPath) || dpSettings.getPathSpec().length() <= longestPatternMatchLength) continue;
            longestPatternMatchLength = dpSettings.getPathSpec().length();
            bestMatch = dpSettings;
        }
        return bestMatch;
    }
}

