/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection.cache;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import javax.annotation.Nullable;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.internal.dataset.ft.fmrc.InventoryCacheProvider;

public class GridInventoryCacheChronicle
implements InventoryCacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(GridInventoryCacheChronicle.class);
    private static ChronicleMap<String, byte[]> cache;
    private static final int DEFAULT_ENTRIES = 1000;
    private static final int DEFAULT_BLOAT_FACTOR = 1;

    public static void init(Path cacheDir) throws IOException {
        GridInventoryCacheChronicle.init(cacheDir, 1000, 1);
    }

    public static void init(Path cacheDir, int maxEntries, int maxBloatFactor) throws IOException {
        GridInventoryCacheChronicle.init(cacheDir, maxEntries, maxBloatFactor, AverageValueSize.defaultSize.size);
    }

    public static void init(Path cacheDir, int maxEntries, int maxBloatFactor, String averageValueSizeName) throws IOException {
        int averageValueSize = averageValueSizeName == null ? AverageValueSize.defaultSize.size : AverageValueSize.valueOf((String)averageValueSizeName.toLowerCase((Locale)Locale.ROOT)).size;
        GridInventoryCacheChronicle.init(cacheDir, maxEntries, maxBloatFactor, averageValueSize);
    }

    private static void init(Path cacheDir, int maxEntries, int maxBloatFactor, int averageValueSize) throws IOException {
        Path dbFile;
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            logger.info("Creating cache directory at {}", (Object)cacheDir.toString());
            Files.createDirectories(cacheDir, new FileAttribute[0]);
        }
        if (Files.exists(dbFile = cacheDir.resolve("GridDatasetInv.dat"), new LinkOption[0])) {
            logger.info("Previous grid inventory cache found. Using {}", (Object)dbFile.toString());
        } else {
            logger.info("Creating new grid inventory cache file at {}", (Object)dbFile.toString());
        }
        if (cache == null) {
            logger.info("Grid inventory cache built with: maxEntries={}, maxBloatFactor={}, averageValueSize={}", new Object[]{maxEntries, maxBloatFactor, averageValueSize});
            cache = ChronicleMapBuilder.of(String.class, byte[].class).name("GridDatasetInv").averageKey((Object)"/data/project/analysis/file.ext").averageValueSize((double)averageValueSize).entries((long)maxEntries).maxBloatFactor((double)maxBloatFactor).createOrRecoverPersistedTo(dbFile.toFile());
        }
    }

    @Nullable
    public GridDatasetInv get(MFile mfile) throws IOException {
        String mfileLoc;
        byte[] xmlBytes;
        GridDatasetInv inv = null;
        if (cache != null && (xmlBytes = (byte[])cache.getOrDefault((Object)(mfileLoc = mfile.getPath()), null)) != null) {
            inv = GridDatasetInv.readXML((byte[])xmlBytes);
            if (inv.isXmlVersionCompatible()) {
                long fileModifiedSecs = mfile.getLastModified() / 1000L;
                long xmlModifiedSecs = inv.getLastModified() / 1000L;
                if (xmlModifiedSecs >= fileModifiedSecs) {
                    logger.debug("cache ok {} >= {} for {}", new Object[]{xmlModifiedSecs, fileModifiedSecs, mfileLoc});
                } else {
                    logger.info(" cache out of date {} < {} for {}. Removing cache entry.", new Object[]{xmlModifiedSecs, fileModifiedSecs, mfileLoc});
                    cache.remove((Object)mfileLoc);
                }
            } else {
                logger.error("GridDatasetInv xml version needs upgrade for {}. Removing cache entry.", (Object)mfileLoc);
                cache.remove((Object)mfileLoc);
            }
        }
        return inv;
    }

    public void put(MFile mfile, GridDatasetInv inventory) throws IOException {
        if (cache != null) {
            String xml = inventory.writeCompactXML(new Date(mfile.getLastModified()));
            cache.put((Object)mfile.getPath(), (Object)xml.getBytes(Charsets.UTF_8));
        }
    }

    public static void shutdown() {
        if (cache != null) {
            cache.close();
        }
    }

    public static void showCache(Formatter formatter) {
        if (cache == null) {
            formatter.format("%nFMRC GridInventoryCache: turned off%n", new Object[0]);
        } else {
            formatter.format("%nFMRC GridInventoryCache:%n", new Object[0]);
            formatter.format("numberOfEntries=%d, ", GridInventoryCacheChronicle.getNumberOfEntries());
            formatter.format("remainingAutoResizes=%d, ", GridInventoryCacheChronicle.getRemainingAutoResizes());
            formatter.format("percentageFreeSpace=%d, ", GridInventoryCacheChronicle.getPercentageFreeSpace());
            formatter.format("offHeapMemoryUsed=%d", GridInventoryCacheChronicle.getOffHeapMemoryUsed());
            formatter.format("%n", new Object[0]);
        }
    }

    static void resetCache() {
        GridInventoryCacheChronicle.shutdown();
        cache = null;
    }

    static long getNumberOfEntries() {
        return cache.longSize();
    }

    static int getRemainingAutoResizes() {
        return cache.remainingAutoResizes();
    }

    static int getPercentageFreeSpace() {
        return cache.percentageFreeSpace();
    }

    static long getOffHeapMemoryUsed() {
        return cache.offHeapMemoryUsed();
    }

    private static enum AverageValueSize {
        small(4096),
        medium(16384),
        large(65536),
        defaultSize(AverageValueSize.small.size);

        private final int size;

        private AverageValueSize(int size) {
            this.size = size;
        }
    }
}

