/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.server.config.HtmlConfigBean;
import thredds.server.config.TdsContext;
import thredds.server.config.TdsServerInfoBean;
import thredds.server.config.TdsUpdateConfigBean;
import thredds.server.config.ThreddsConfig;
import thredds.server.config.WmsConfigBean;
import thredds.server.wms.TdsEnhancedVariableMetadata;
import thredds.server.wms.ThreddsWmsCatalogue;
import thredds.server.wms.config.WmsDetailedConfig;
import uk.ac.rdg.resc.edal.graphics.utils.ColourPalette;
import uk.ac.rdg.resc.edal.graphics.utils.SldTemplateStyleCatalogue;

@Component
class TdsConfigMapper {
    @Autowired
    private TdsServerInfoBean tdsServerInfo;
    @Autowired
    private HtmlConfigBean htmlConfig;
    @Autowired
    private WmsConfigBean wmsConfig;
    @Autowired
    private TdsUpdateConfigBean tdsUpdateConfig;
    private static final Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");

    private static String getValueFromThreddsConfig(String key, String alternateKey, String defaultValue) {
        String value = ThreddsConfig.get(key, null);
        if (value == null && alternateKey != null) {
            value = ThreddsConfig.get(alternateKey, null);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String getValueFromThreddsConfigOrDefault(WmsConfigMappings property, String defaultValue) {
        String value = property.getValueFromThreddsConfig();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    TdsConfigMapper() {
    }

    void init(TdsContext tdsContext) {
        ServerInfoMappings.load(this.tdsServerInfo);
        HtmlConfigMappings.load(this.htmlConfig, tdsContext, this.tdsServerInfo);
        WmsConfigMappings.load(this.wmsConfig, tdsContext);
        TdsUpdateConfigMappings.load(this.tdsUpdateConfig);
    }

    static enum WmsConfigMappings {
        WMS_ALLOW("WMS.allow", null, "true"),
        WMS_ALLOW_REMOTE("WMS.allowRemote", null, "false"),
        WMS_PALETTE_LOCATION_DIR("WMS.paletteLocationDir", null, null),
        WMS_STYLES_LOCATION_DIR("WMS.stylesLocationDir", null, null),
        WMS_MAXIMUM_IMAGE_WIDTH("WMS.maxImageWidth", null, "2048"),
        WMS_MAXIMUM_IMAGE_HEIGHT("WMS.maxImageHeight", null, "2048"),
        WMS_CONFIG_FILE("WMS.configFile", null, null);

        private String key;
        private String alternateKey;
        private String defaultValue;

        private WmsConfigMappings(String key, String alternateKey, String defaultValue) {
            if (key == null) {
                throw new IllegalArgumentException("The key may not be null.");
            }
            this.key = key;
            this.alternateKey = alternateKey;
            this.defaultValue = defaultValue;
        }

        String getDefaultValue() {
            return this.defaultValue;
        }

        String getValueFromThreddsConfig() {
            return TdsConfigMapper.getValueFromThreddsConfig(this.key, this.alternateKey, this.defaultValue);
        }

        static void load(WmsConfigBean wmsConfig, TdsContext tdsContext) {
            String defaultWmsConfigFile;
            block18: {
                String defaultStylesLocation;
                block17: {
                    String defaultPaletteLocation = tdsContext.getThreddsDirectory() + "/wmsPalettes";
                    defaultStylesLocation = tdsContext.getThreddsDirectory() + "/wmsStyles";
                    defaultWmsConfigFile = tdsContext.getThreddsDirectory() + "/wmsConfig.xml";
                    wmsConfig.setAllow(Boolean.parseBoolean(WMS_ALLOW.getValueFromThreddsConfig()));
                    wmsConfig.setAllowRemote(Boolean.parseBoolean(WMS_ALLOW_REMOTE.getValueFromThreddsConfig()));
                    String paletteLocation = TdsConfigMapper.getValueFromThreddsConfigOrDefault(WMS_PALETTE_LOCATION_DIR, defaultPaletteLocation);
                    wmsConfig.setPaletteLocationDir(paletteLocation);
                    try {
                        startupLog.info("Loading custom WMS palette files from " + paletteLocation);
                        ColourPalette.addPaletteDirectory((File)new File(paletteLocation));
                    }
                    catch (FileNotFoundException e) {
                        if (paletteLocation.equals(defaultPaletteLocation)) break block17;
                        startupLog.warn("Could not find custom palette directory {}", (Object)paletteLocation, (Object)e);
                    }
                }
                String stylesLocation = TdsConfigMapper.getValueFromThreddsConfigOrDefault(WMS_STYLES_LOCATION_DIR, defaultStylesLocation);
                wmsConfig.setStylesLocationDir(stylesLocation);
                try {
                    startupLog.info("Loading custom WMS style files from " + stylesLocation);
                    SldTemplateStyleCatalogue.getStyleCatalogue().addStylesInDirectory(new File(stylesLocation));
                }
                catch (FileNotFoundException e) {
                    if (stylesLocation.equals(defaultStylesLocation)) break block18;
                    startupLog.warn("Could not find custom styles directory {}", (Object)stylesLocation, (Object)e);
                }
            }
            String wmsConfigFile = TdsConfigMapper.getValueFromThreddsConfigOrDefault(WMS_CONFIG_FILE, defaultWmsConfigFile);
            WmsDetailedConfig wdc = WmsDetailedConfig.fromLocation(wmsConfigFile);
            if (wdc == null) {
                String defaultWmsConfig = "/WEB-INF/altContent/startup/wmsConfig.xml";
                try (InputStream in = tdsContext.getServletContext().getResourceAsStream(defaultWmsConfig);){
                    wdc = WmsDetailedConfig.loadFromStream(in);
                }
                catch (IOException e) {
                    startupLog.error("Cannot read wmsConfig.xml from TDS war file:");
                    startupLog.error(e.getMessage());
                    startupLog.error("Failed to configure WMS server. Disabling the service.");
                    wmsConfig.setAllow(false);
                    wmsConfig.setAllowRemote(false);
                }
            }
            wmsConfig.setWmsDetailedConfig(wdc);
            try {
                wmsConfig.setMaxImageWidth(Integer.parseInt(WMS_MAXIMUM_IMAGE_WIDTH.getValueFromThreddsConfig()));
            }
            catch (NumberFormatException e) {
                wmsConfig.setMaxImageWidth(Integer.parseInt(WMS_MAXIMUM_IMAGE_WIDTH.getDefaultValue()));
            }
            try {
                wmsConfig.setMaxImageHeight(Integer.parseInt(WMS_MAXIMUM_IMAGE_HEIGHT.getValueFromThreddsConfig()));
            }
            catch (NumberFormatException e) {
                wmsConfig.setMaxImageHeight(Integer.parseInt(WMS_MAXIMUM_IMAGE_HEIGHT.getDefaultValue()));
            }
            TdsEnhancedVariableMetadata.setWmsConfig(wmsConfig);
            ThreddsWmsCatalogue.setWmsConfig(wmsConfig);
        }
    }

    static enum ServerInfoMappings {
        SERVER_NAME("serverInformation.name", "htmlSetup.installName", "Initial TDS Installation"),
        SERVER_LOGO_URL("serverInformation.logoUrl", "htmlSetup.installLogoUrl", "threddsIcon.png"),
        SERVER_LOGO_ALT_TEXT("serverInformation.logoAltText", "htmlSetup.installLogoAlt", "Initial TDS Installation"),
        SERVER_ABSTRACT("serverInformation.abstract", null, "Scientific Data"),
        SERVER_KEYWORDS("serverInformation.keywords", null, "meteorology, atmosphere, climate, ocean, earth science"),
        SERVER_CONTACT_NAME("serverInformation.contact.name", null, ""),
        SERVER_CONTACT_ORGANIZATION("serverInformation.contact.organization", null, ""),
        SERVER_CONTACT_EMAIL("serverInformation.contact.email", null, ""),
        SERVER_CONTACT_PHONE("serverInformation.contact.phone", null, ""),
        SERVER_HOST_INSTITUTION_NAME("serverInformation.hostInstitution.name", "htmlSetup.hostInstName", ""),
        SERVER_HOST_INSTITUTION_WEBSITE("serverInformation.hostInstitution.webSite", "htmlSetup.hostInstUrl", ""),
        SERVER_HOST_INSTITUTION_LOGO_URL("serverInformation.hostInstitution.logoUrl", "htmlSetup.hostInstLogoUrl", ""),
        SERVER_HOST_INSTITUTION_LOGO_ALT_TEXT("serverInformation.hostInstitution.logoAltText", "htmlSetup.hostInstLogoAlt", "");

        private String key;
        private String alternateKey;
        private String defaultValue;

        private ServerInfoMappings(String key, String alternateKey, String defaultValue) {
            if (key == null || defaultValue == null) {
                throw new IllegalArgumentException("The key and default value may not be null.");
            }
            this.key = key;
            this.alternateKey = alternateKey;
            this.defaultValue = defaultValue;
        }

        String getValueFromThreddsConfig() {
            return TdsConfigMapper.getValueFromThreddsConfig(this.key, this.alternateKey, this.defaultValue);
        }

        static void load(TdsServerInfoBean info) {
            info.setName(SERVER_NAME.getValueFromThreddsConfig());
            info.setLogoUrl(SERVER_LOGO_URL.getValueFromThreddsConfig());
            info.setLogoAltText(SERVER_LOGO_ALT_TEXT.getValueFromThreddsConfig());
            info.setSummary(SERVER_ABSTRACT.getValueFromThreddsConfig());
            info.setKeywords(SERVER_KEYWORDS.getValueFromThreddsConfig());
            info.setContactName(SERVER_CONTACT_NAME.getValueFromThreddsConfig());
            info.setContactOrganization(SERVER_CONTACT_ORGANIZATION.getValueFromThreddsConfig());
            info.setContactEmail(SERVER_CONTACT_EMAIL.getValueFromThreddsConfig());
            info.setContactPhone(SERVER_CONTACT_PHONE.getValueFromThreddsConfig());
            info.setHostInstitutionName(SERVER_HOST_INSTITUTION_NAME.getValueFromThreddsConfig());
            info.setHostInstitutionWebSite(SERVER_HOST_INSTITUTION_WEBSITE.getValueFromThreddsConfig());
            info.setHostInstitutionLogoUrl(SERVER_HOST_INSTITUTION_LOGO_URL.getValueFromThreddsConfig());
            info.setHostInstitutionLogoAltText(SERVER_HOST_INSTITUTION_LOGO_ALT_TEXT.getValueFromThreddsConfig());
            ThreddsWmsCatalogue.setTdsServerInfo(info);
        }
    }

    static enum HtmlConfigMappings {
        HTML_STANDARD_CSS_URL("htmlSetup.standardCssUrl", null, ""),
        HTML_CATALOG_CSS_URL("htmlSetup.catalogCssUrl", null, ""),
        HTML_DATASET_CSS_URL("htmlSetup.datasetCssUrl", null, ""),
        HTML_OPENDAP_CSS_URL("htmlSetup.openDapCssUrl", null, "tdsDap.css"),
        GOOGLE_TRACKING_CODE("htmlSetup.googleTrackingCode", null, ""),
        HTML_FOLDER_ICON_URL("htmlSetup.folderIconUrl", null, "folder.gif"),
        HTML_FOLDER_ICON_ALT("htmlSetup.folderIconAlt", null, "Folder"),
        HTML_DATASET_ICON_URL("htmlSetup.datasetIconUrl", null, ""),
        HTML_DATASET_ICON_ALT("htmlSetup.datasetIconAlt", null, ""),
        HTML_USE_REMOTE_CAT_SERVICE("htmlSetup.useRemoteCatalogService", null, "true"),
        HTML_GENERATE_DATASET_JSON_LD("htmlSetup.generateDatasetJsonLD", null, "false");

        private String key;
        private String alternateKey;
        private String defaultValue;

        private HtmlConfigMappings(String key, String alternateKey, String defaultValue) {
            if (key == null || defaultValue == null) {
                throw new IllegalArgumentException("The key and default value may not be null.");
            }
            this.key = key;
            this.alternateKey = alternateKey;
            this.defaultValue = defaultValue;
        }

        String getValueFromThreddsConfig() {
            return TdsConfigMapper.getValueFromThreddsConfig(this.key, this.alternateKey, this.defaultValue);
        }

        static void load(HtmlConfigBean htmlConfig, TdsContext tdsContext, TdsServerInfoBean serverInfo) {
            htmlConfig.init(tdsContext.getWebappDisplayName(), tdsContext.getWebappVersion(), tdsContext.getTdsVersionBuildDate(), tdsContext.getContextPath());
            htmlConfig.setInstallName(serverInfo.getName());
            htmlConfig.setInstallLogoUrl(serverInfo.getLogoUrl());
            htmlConfig.setInstallLogoAlt(serverInfo.getLogoAltText());
            htmlConfig.setHostInstName(serverInfo.getHostInstitutionName());
            htmlConfig.setHostInstUrl(serverInfo.getHostInstitutionWebSite());
            htmlConfig.setHostInstLogoUrl(serverInfo.getHostInstitutionLogoUrl());
            htmlConfig.setHostInstLogoAlt(serverInfo.getHostInstitutionLogoAltText());
            htmlConfig.setPageCssUrl(HTML_STANDARD_CSS_URL.getValueFromThreddsConfig());
            htmlConfig.setCatalogCssUrl(HTML_CATALOG_CSS_URL.getValueFromThreddsConfig());
            htmlConfig.setDatasetCssUrl(HTML_DATASET_CSS_URL.getValueFromThreddsConfig());
            htmlConfig.setOpenDapCssUrl(HTML_OPENDAP_CSS_URL.getValueFromThreddsConfig());
            htmlConfig.setGoogleTrackingCode(GOOGLE_TRACKING_CODE.getValueFromThreddsConfig());
            htmlConfig.setFolderIconUrl(HTML_FOLDER_ICON_URL.getValueFromThreddsConfig());
            htmlConfig.setFolderIconAlt(HTML_FOLDER_ICON_ALT.getValueFromThreddsConfig());
            htmlConfig.setDatasetIconUrl(HTML_DATASET_ICON_URL.getValueFromThreddsConfig());
            htmlConfig.setDatasetIconAlt(HTML_DATASET_ICON_ALT.getValueFromThreddsConfig());
            htmlConfig.setUseRemoteCatalogService(Boolean.parseBoolean(HTML_USE_REMOTE_CAT_SERVICE.getValueFromThreddsConfig()));
            htmlConfig.setGenerateDatasetJsonLD(Boolean.parseBoolean(HTML_GENERATE_DATASET_JSON_LD.getValueFromThreddsConfig()));
        }
    }

    static enum TdsUpdateConfigMappings {
        TDSUPDAATE_LOGVERSIONINFO("TdsUpdateConfig.logVersionInfo", null, "true");

        private String key;
        private String alternateKey;
        private String defaultValue;

        private TdsUpdateConfigMappings(String key, String alternateKey, String defaultValue) {
            if (key == null) {
                throw new IllegalArgumentException("The key may not be null.");
            }
            this.key = key;
            this.alternateKey = alternateKey;
            this.defaultValue = defaultValue;
        }

        String getDefaultValue() {
            return this.defaultValue;
        }

        String getValueFromThreddsConfig() {
            return TdsConfigMapper.getValueFromThreddsConfig(this.key, this.alternateKey, this.defaultValue);
        }

        static void load(TdsUpdateConfigBean tdsUpdateConfig) {
            tdsUpdateConfig.setLogVersionInfo(Boolean.parseBoolean(TDSUPDAATE_LOGVERSIONINFO.getValueFromThreddsConfig()));
        }
    }
}

