/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import thredds.core.AllowedServices;
import thredds.core.StandardService;
import thredds.core.TdsRequestedDataset;
import thredds.server.config.ThreddsConfig;
import thredds.server.exception.RequestTooLargeException;
import thredds.server.exception.ServiceNotAllowed;
import thredds.server.ncss.controller.AbstractNcssController;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.exception.UnsupportedResponseFormatException;
import thredds.server.ncss.exception.VariableNotContainedInDatasetException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.format.SupportedOperation;
import thredds.server.ncss.params.NcssGridParamsBean;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import thredds.server.ncss.view.dsg.DsgSubsetWriterFactory;
import thredds.util.Constants;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.writer.CFGridCoverageWriter;
import ucar.nc2.ft2.coverage.writer.CoverageAsPoint;
import ucar.nc2.ft2.coverage.writer.CoverageDatasetCapabilities;
import ucar.nc2.util.IO;
import ucar.nc2.write.NetcdfFileFormat;
import ucar.nc2.write.NetcdfFormatWriter;

@Controller
@RequestMapping(value={"/ncss/grid"})
public class NcssGridController
extends AbstractNcssController {
    private static final short ESTIMATED_COMPRESSION_RATE = 4;
    private static final Pattern LATLON_WKT_PATTERN = Pattern.compile(",?(-?\\d+(\\.?\\d+)?)\\s(-?\\d+(\\.?\\d+)?),?");
    @Autowired
    private AllowedServices allowedServices;

    @Override
    protected String getBase() {
        return StandardService.netcdfSubsetGrid.getBase();
    }

    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res, @Valid NcssGridParamsBean params, BindingResult validationResult) throws Exception {
        if (!this.allowedServices.isAllowed(StandardService.netcdfSubsetGrid)) {
            throw new ServiceNotAllowed(StandardService.netcdfSubsetGrid.toString());
        }
        if (validationResult.hasErrors()) {
            throw new BindException(validationResult);
        }
        String datasetPath = this.getDatasetPath(req);
        try (CoverageCollection gcd = TdsRequestedDataset.getCoverageCollection(req, res, datasetPath);){
            if (gcd == null) {
                return;
            }
            Formatter errs = new Formatter();
            if (!params.intersectsTime(gcd.getCalendarDateRange(), errs)) {
                this.handleValidationErrorMessage(res, 400, errs.toString());
                return;
            }
            this.checkRequestedVars(gcd, params);
            if (params.hasLatLonPoint()) {
                this.handleRequestGridAsPoint(res, params, datasetPath, gcd);
            } else {
                this.handleRequestGrid(res, params, datasetPath, gcd);
            }
        }
    }

    private void handleRequestGrid(HttpServletResponse res, NcssGridParamsBean params, String datasetPath, CoverageCollection gcd) throws IOException, NcssException, InvalidRangeException {
        Object filename;
        SupportedFormat sf = SupportedOperation.GRID_REQUEST.getSupportedFormat(params.getAccept());
        NetcdfFileFormat version = NcssGridController.getNetcdfFileFormat(sf);
        if (params.getVertCoord() != null && !this.checkVarsHaveSameVertAxis(gcd, params)) {
            throw new NcssException("The variables requested: " + params.getVar() + " have different vertical levels. Grid requests with vertCoord must have variables with same vertical levels.");
        }
        String responseFile = this.getResponseFileName();
        File netcdfResult = this.makeCFNetcdfFile(gcd, responseFile, params, version);
        String suffix = sf.getFileSuffix();
        int pos = datasetPath.lastIndexOf("/");
        Object object = filename = pos >= 0 ? datasetPath.substring(pos + 1) : datasetPath;
        if (!((String)filename).endsWith(suffix)) {
            filename = (String)filename + suffix;
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Content-Type", sf.getMimeType());
        httpHeaders.set("Content-Disposition", Constants.setContentDispositionValue((String)filename));
        httpHeaders.set("Content-Length", Constants.getContentLengthValue((File)netcdfResult));
        this.setResponseHeaders(res, httpHeaders);
        IO.copyFileB((File)netcdfResult, (OutputStream)res.getOutputStream(), (int)60000);
        res.flushBuffer();
        res.getOutputStream().close();
        res.setStatus(200);
        netcdfResult.delete();
    }

    private static NetcdfFileFormat getNetcdfFileFormat(SupportedFormat supportedFormat) {
        switch (supportedFormat) {
            case NETCDF3: {
                return NetcdfFileFormat.NETCDF3;
            }
            case NETCDF4: {
                return NetcdfFileFormat.NETCDF4_CLASSIC;
            }
            case NETCDF4EXT: {
                return NetcdfFileFormat.NETCDF4;
            }
        }
        throw new UnsupportedOperationException("Format '" + supportedFormat.getFormatName() + "' not currently supported for writing NetCDF files.");
    }

    private File makeCFNetcdfFile(CoverageCollection gcd, String responseFilename, NcssGridParamsBean params, NetcdfFileFormat version) throws InvalidRangeException, IOException, NcssException {
        SubsetParams subset = params.makeSubset(gcd);
        long maxFileDownloadSize = ThreddsConfig.getBytes("NetcdfSubsetService.maxFileDownloadSize", -1L);
        if (version.isNetcdf4Format()) {
            maxFileDownloadSize *= 4L;
        }
        NetcdfFormatWriter.Builder writerb = NetcdfFormatWriter.builder().setLocation(responseFilename).setFormat(version);
        CFGridCoverageWriter.Result result = CFGridCoverageWriter.write((CoverageCollection)gcd, params.getVar(), (SubsetParams)subset, (boolean)params.isAddLatLon(), (NetcdfFormatWriter.Builder)writerb, (long)maxFileDownloadSize);
        if (!result.wasWritten()) {
            String errorMessage = result.getErrorMessage();
            if (errorMessage.equals("Request too large")) {
                throw new RequestTooLargeException(result.sizeToBeWritten(), maxFileDownloadSize);
            }
            throw new NcssException(errorMessage);
        }
        return new File(responseFilename);
    }

    private String getResponseFileName() {
        File ncFile = this.ncssDiskCache.getDiskCache().createUniqueFile("ncss-grid", ".nc");
        if (ncFile == null) {
            throw new IllegalStateException("NCSS misconfigured cache");
        }
        return ncFile.getPath();
    }

    private void handleRequestGridAsPoint(HttpServletResponse res, NcssGridParamsBean params, String datasetPath, CoverageCollection gcd) throws Exception {
        SupportedFormat sf = SupportedOperation.POINT_REQUEST.getSupportedFormat(params.getAccept());
        CoverageAsPoint covp = new CoverageAsPoint(gcd, params.getVar(), params.makeSubset(gcd));
        try (FeatureDatasetPoint fd = covp.asFeatureDatasetPoint();){
            SubsetParams ncssParams = new SubsetParams().set("timeAll", (Object)true).set("var", params.getVar());
            DsgSubsetWriter pds = DsgSubsetWriterFactory.newInstance(fd, ncssParams, this.ncssDiskCache, (OutputStream)res.getOutputStream(), sf);
            this.setResponseHeaders(res, pds.getHttpHeaders(datasetPath, sf.isStream()));
            pds.respond(res, (FeatureDataset)fd, datasetPath, ncssParams, sf);
        }
    }

    @RequestMapping(value={"**/dataset.xml", "**/pointDataset.xml"})
    public ModelAndView getDatasetDescriptionXml(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String datasetPath = this.getDatasetPath(req);
        try (CoverageCollection gcd = TdsRequestedDataset.getCoverageCollection(req, res, datasetPath);){
            if (gcd == null) {
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            String datasetUrlPath = this.buildDatasetUrl(datasetPath);
            CoverageDatasetCapabilities writer = new CoverageDatasetCapabilities(gcd, "path");
            Document doc = writer.makeDatasetDescription();
            Element root = doc.getRootElement();
            root.setAttribute("location", datasetUrlPath);
            root.addContent((Content)NcssGridController.makeAcceptXML(SupportedOperation.GRID_REQUEST));
            ModelAndView modelAndView = new ModelAndView("threddsXmlView", "Document", (Object)doc);
            return modelAndView;
        }
    }

    @RequestMapping(value={"**/dataset.html"})
    public ModelAndView getGridDatasetDescriptionHtml(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.getDatasetDescriptionHtml(req, res, SupportedOperation.GRID_REQUEST);
    }

    @RequestMapping(value={"**/pointDataset.html"})
    public ModelAndView getGridAsPointDatasetDescriptionHtml(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.getDatasetDescriptionHtml(req, res, SupportedOperation.GRID_AS_POINT_REQUEST);
    }

    private ModelAndView getDatasetDescriptionHtml(HttpServletRequest req, HttpServletResponse res, SupportedOperation op) throws IOException {
        String datasetPath = this.getDatasetPath(req);
        try (CoverageCollection gcd = TdsRequestedDataset.getCoverageCollection(req, res, datasetPath);){
            if (gcd == null) {
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            String datasetUrlPath = this.buildDatasetUrl(datasetPath);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("gcd", gcd);
            model.put("datasetPath", datasetUrlPath);
            String horizontalExtentWKT = gcd.getHorizCoordSys().getLatLonBoundaryAsWKT(50, 100);
            Matcher latLonWktMatcher = LATLON_WKT_PATTERN.matcher(horizontalExtentWKT);
            if (latLonWktMatcher.groupCount() > 3) {
                model.put("horizExtentWKT", horizontalExtentWKT);
            } else {
                model.put("horizExtentWKT", "POLYGON((-90 45, 90 45, 90 -45, -90 -45, -90 45))");
            }
            model.put("accept", NcssGridController.makeAcceptList(op));
            switch (op) {
                case GRID_REQUEST: {
                    ModelAndView modelAndView = new ModelAndView("templates/ncssGrid", model);
                    return modelAndView;
                }
                case GRID_AS_POINT_REQUEST: {
                    ModelAndView modelAndView = new ModelAndView("templates/ncssGridAsPoint", model);
                    return modelAndView;
                }
            }
            throw new AssertionError((Object)("Who passed in a " + op + "?"));
        }
    }

    @RequestMapping(value={"**/datasetBoundaries.xml"})
    public void getDatasetBoundaries(NcssParamsBean params, HttpServletRequest req, HttpServletResponse res) throws IOException, UnsupportedResponseFormatException {
        SupportedFormat format = SupportedOperation.DATASET_BOUNDARIES_REQUEST.getSupportedFormat(params.getAccept());
        switch (format) {
            case WKT: {
                this.getDatasetBoundariesWKT(req, res);
                break;
            }
            case JSON: {
                this.getDatasetBoundariesGeoJSON(req, res);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Expected %s or %s, but got %s", new Object[]{SupportedFormat.WKT, SupportedFormat.JSON, format}));
            }
        }
    }

    @RequestMapping(value={"**/datasetBoundaries.wkt"})
    public void getDatasetBoundariesWKT(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try (CoverageCollection gcd = TdsRequestedDataset.getCoverageCollection(req, res, this.getDatasetPath(req));){
            if (gcd == null) {
                return;
            }
            res.setContentType(SupportedFormat.WKT.getMimeType());
            res.getWriter().write(gcd.getHorizCoordSys().getLatLonBoundaryAsWKT());
            res.getWriter().flush();
        }
    }

    @RequestMapping(value={"**/datasetBoundaries.json"})
    public void getDatasetBoundariesGeoJSON(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try (CoverageCollection gcd = TdsRequestedDataset.getCoverageCollection(req, res, this.getDatasetPath(req));){
            if (gcd == null) {
                return;
            }
            res.setContentType(SupportedFormat.JSON.getMimeType());
            res.getWriter().write(gcd.getHorizCoordSys().getLatLonBoundaryAsGeoJSON());
            res.getWriter().flush();
        }
    }

    private void checkRequestedVars(CoverageCollection gcd, NcssGridParamsBean params) throws VariableNotContainedInDatasetException {
        if (params.getVar().get(0).equalsIgnoreCase("all")) {
            params.setVar(this.getAllGridNames(gcd));
            return;
        }
        for (String gridName : params.getVar()) {
            Coverage grid = gcd.findCoverage(gridName);
            if (grid != null) continue;
            throw new VariableNotContainedInDatasetException("Variable: " + gridName + " is not contained in the requested dataset");
        }
    }

    private List<String> getAllGridNames(CoverageCollection gcd) {
        ArrayList<String> result = new ArrayList<String>();
        for (Coverage var : gcd.getCoverages()) {
            result.add(var.getName());
        }
        return result;
    }

    protected boolean checkVarsHaveSameVertAxis(CoverageCollection gcd, NcssGridParamsBean params) {
        String zaxisName = null;
        for (String gridName : params.getVar()) {
            Coverage grid = gcd.findCoverage(gridName);
            CoverageCoordAxis zaxis = grid.getCoordSys().getZAxis();
            if (zaxis == null) continue;
            if (zaxisName == null) {
                zaxisName = zaxis.getName();
                continue;
            }
            if (zaxisName.equals(zaxis.getName())) continue;
            return false;
        }
        return true;
    }
}

