/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.validation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import thredds.server.ncss.params.NcssGridParamsBean;
import thredds.server.ncss.validation.NcssGridRequestConstraint;
import thredds.server.ncss.validation.TimeParamsValidator;
import ucar.nc2.time.CalendarDate;

public class NcssGridRequestValidator
implements ConstraintValidator<NcssGridRequestConstraint, NcssGridParamsBean> {
    public void initialize(NcssGridRequestConstraint arg0) {
    }

    public boolean isValid(NcssGridParamsBean params, ConstraintValidatorContext constraintValidatorContext) {
        constraintValidatorContext.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (!(params.getLatitude() == null && params.getLongitude() == null || params.hasLatLonPoint())) {
            isValid = false;
            constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.lat_or_lon_missing}").addConstraintViolation();
        }
        if (params.getNorth() != null || params.getSouth() != null || params.getEast() != null || params.getWest() != null) {
            if (!params.hasLatLonBB()) {
                isValid = false;
                constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.wrong_bbox}").addConstraintViolation();
            }
            if (params.getNorth() < params.getSouth()) {
                isValid = false;
                constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.north_south}").addConstraintViolation();
            }
            if (params.getEast() < params.getWest()) {
                isValid = false;
                constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.east_west}").addConstraintViolation();
            }
        }
        if (params.getMaxx() != null || params.getMinx() != null || params.getMaxy() != null || params.getMiny() != null) {
            if (!params.hasProjectionBB()) {
                isValid = false;
                constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.wrong_pbox}").addConstraintViolation();
            }
            if (params.getMaxx() < params.getMinx()) {
                isValid = false;
                constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.rangex}").addConstraintViolation();
            }
            if (params.getMaxy() < params.getMiny()) {
                isValid = false;
                constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.rangey}").addConstraintViolation();
            }
        }
        if (params.getRuntime() != null) {
            if ("latest".equalsIgnoreCase(params.getRuntime())) {
                params.setLatestRuntime(true);
            } else if ("all".equalsIgnoreCase(params.getRuntime())) {
                params.setAllRuntime(true);
            } else {
                CalendarDate cd = TimeParamsValidator.validateISOString(params.getRuntime(), "{thredds.server.ncSubset.validation.param.runtime}", constraintValidatorContext);
                if (cd != null) {
                    params.setRuntimeDate(cd);
                }
            }
        }
        if (params.getTimeOffset() != null) {
            if ("first".equalsIgnoreCase(params.getTimeOffset())) {
                params.setFirstTimeOffset(true);
            } else {
                try {
                    double val = Double.parseDouble(params.getTimeOffset());
                    params.setTimeOffsetVal(val);
                }
                catch (NumberFormatException e) {
                    constraintValidatorContext.buildConstraintViolationWithTemplate("{thredds.server.ncSubset.validation.param.time_offset}").addConstraintViolation();
                }
            }
        }
        return isValid;
    }
}

